/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "XMLConfigurationParser.h"

namespace NS_DM_Client
{

IConfigurationParser* IConfigurationParser::GetInstance(ConfigurationParserType type)
{
    IConfigurationParser* instance = 0;
    switch(type)
    {
    case e_XML:
        instance = new(std::nothrow) XMLConfigurationParser;
        break;
    default:
        break;
    };
    return instance;
}

bool IConfigurationParser::Init(const String& configuration, const char* group)
{
    return Init(configuration.c_str(), group);
}

}
