#include "Event.h"
#include <Windows.h>

namespace NS_DM_Client
{
	namespace NS_Common
	{
		Event::Event(bool autoReset/* = true*/)
		{
			m_handle = ::CreateEvent(0, !autoReset, FALSE, 0);
		}
		//-------------------------------------------------------------------------------------------

		Event::~Event()
		{
			::CloseHandle(m_handle);
		}
		//-------------------------------------------------------------------------------------------

		void Event::wait()
		{
			::WaitForSingleObject(m_handle, INFINITE);
		}
		//-------------------------------------------------------------------------------------------

		void Event::reset()
		{
			::ResetEvent(m_handle);
		}

		void Event::signal()
		{
			::SetEvent(m_handle); // skip result of operation
		}

        long    EventEx::wait()
        {
            Event::wait();
            return m_param;
        }
        
        void    EventEx::signal(long param)
        {
            m_param = param;
            Event::signal();
        }
    }
}
