/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <vector>
#include "Logger/LoggerMacroses.h"
#include "serverexchange/CommandStorage.h"
#include "serverexchange/wrappers/SCommandAdapter.h"
#include "serverexchange/wrappers/SResponseCommand.h"


using namespace NS_DM_Client::NS_SyncMLCommand;

const char* s_cStorage = "CommandStorage";

CommandStorage::CommandStorage()
{
}


CommandStorage::~CommandStorage()
{
}


void CommandStorage::Add(SCommandPtr ptrCommand)
{
    if(ptrCommand.get() == NULL)
    {
        LOG_WARNING_(NS_Logging::GetLogger(s_cStorage),"ptrCommand is NULL");
    }

    m_commands.push_back(ptrCommand);
}


void CommandStorage::Clear()
{
    m_commands.clear();
}


void CommandStorage::InsertFirst(SCommandPtr ptrCommand)
{
    if(ptrCommand.get() == NULL)
    {
        LOG_WARNING_(NS_Logging::GetLogger(s_cStorage),"ptrCommand is NULL");
    }

    m_commands.insert(m_commands.begin(), ptrCommand);
}


void CommandStorage::Remove(const char * msgid, const char * cmdid, const char *cmdname)
{
    if (m_commands.empty() || !msgid || !cmdid || !cmdname) return;

    SCommands::iterator it = m_commands.begin();
    SCommands  newlist;

    while (it != m_commands.end())
    {
        SCommandPtr &cmd = *it;
        if(cmd.get() == NULL)
        {
            LOG_WARNING_(NS_Logging::GetLogger(s_cStorage),"cmd is NULL");
        }

        if (cmd.get() ||
            (cmd->GetMessageID() && strcmp(msgid, cmd->GetMessageID())) ||
            (cmd->GetCmdID() && strcmp(cmdid, cmd->GetCmdID()))
            )
        {
            cmd->Prepare();
            if (cmd->Internal().get() && 
                (!strcmp(cmd->Internal()->getName(), RESULTS_COMMAND_NAME) || 
                 !strcmp(cmd->Internal()->getName(), STATUS_COMMAND_NAME)))
            {
                // both SResultsCommand and SStatusCommand are derived from SResponseCommand
                SResponseCommand *pResponse = static_cast<SResponseCommand*>(cmd.get());
                if (pResponse->GetCmdRef() && strcmp(cmdname, pResponse->GetCmdRef()))
                    newlist.push_back(*it);
            }
            else
                newlist.push_back(*it);
        }
        ++it;
    }

    if (newlist.size() != m_commands.size())
        m_commands = newlist;
}


int CommandStorage::Size()
{
    return m_commands.size();
}


SCommandPtr CommandStorage::operator[] (unsigned int index)
{
    if (m_commands.size() && index < m_commands.size() && index >= 0)
    {
        return m_commands[index];
    }
    else
    {
        return NS_SyncMLCommand::SCommandPtr();
    }
}
