/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */


#include "commontypes.h"
#include "serverexchange/commands/AdjustDurationCommand.h"
#include "serverexchange/commands/DRMDReadyNotificationCommand.h"
#include "serverexchange/commands/NotifySEMDRMDReadyCommand.h"
#include "daemon/INotificationCenter.h"
#include "treemanager/IMOTreeManager.h"
#include "treemanager/MOTreeExecCommand.h"
#include "executionqueue/IExecutionQueue.h"
#include <Logger/LoggerMacroses.h>

const char* const c_LogName = "DRMDReadyNotificationCommand";

using namespace NS_DM_Client;

DRMDReadyNotificationCommand::DRMDReadyNotificationCommand(ProfileComponentsHolder* pch)
: m_pProfile(pch)
{
}


bool DRMDReadyNotificationCommand::Execute()
{

	String valueServerid;
	if (e_Ok == m_pProfile->GetMOTreeManager()->GetValue(URI_DIAGNOSTICS_SERVERID, valueServerid, NULL))
	{
		// check if there is an acc record for server_id //ask SEM
/*
		if (!m_pProfile->GetServerExchangeManager()->HasAccountFor(valueServerid))
		{
			GDLERROR("Received 'exec diagnostics' but no DRMD server acc found in the tree");
			return false;
		}
*/
	}
	else
	{
		return false;
	}

	String valueOriginationid;
	if (e_Ok != m_pProfile->GetMOTreeManager()->GetValue(URI_DIAGNOSTICS_ORIGINATIONID, valueOriginationid, NULL))
	{
		return false;
	}

	String diagDuration(URI_DIAGNOSTICS_DURATION);
	AdjustDurationCommand cmdAdjust(m_pProfile, diagDuration);
	cmdAdjust.Execute();

	ICommand* cmd = new(std::nothrow) NotifySEMDRMDReadyCommand(*m_pProfile->GetServerExchangeManager(), valueServerid, valueOriginationid);
	if (cmd != NULL)
	{
		if (!m_pProfile->GetExecutionQueue()->Add(*cmd))
		{
			delete cmd;
			cmd = NULL;
		}
	}
    else
    {
        GDLWARN("new NotifySEMDRMDReadyCommand");
    }
	
	return cmd != NULL;
}


