/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "executionqueue/IExecutionQueue.h"
#include "serverexchange/commands/HandleNetworkEntryCommand.h"
#include "serverexchange/commands/SEMNetworkEntranceCommand.h"
#include "serverexchange/IServerExchangeManager.h"
#include "treemanager/IMOTreeManager.h"

#include "Logger/LoggerMacroses.h"
#include "Utils.h"
#include "daemon/ProfileTypes.h"

const char* const c_LogName = "HandleNetworkEntryCommand";

using namespace NS_DM_Client;


HandleNetworkEntryCommand::HandleNetworkEntryCommand(ProfileComponentsHolder& pch, int homeNspID, const char* operatorName)
:
m_pch(pch),
m_homeNspID(homeNspID)
{
	if (operatorName)
	{
		m_operatorName = operatorName;
	}
}


bool HandleNetworkEntryCommand::Execute()
{
	bool startWIB = false;
	
	bool result = false;
	if (m_pch.GetProfileType().compare(NS_Daemon::c_ProfileTypeWiMAX) == 0)
	{
		result = triggerWIB(startWIB);
	}
	
	SEMNetworkEntranceCommand *cmd = new(std::nothrow) SEMNetworkEntranceCommand(*m_pch.GetServerExchangeManager(), m_homeNspID, m_operatorName.c_str(), startWIB);
    if(cmd == NULL)
    {
        GDLWARN("new SEMNetworkEntranceCommand");
    }

	if (!m_pch.GetExecutionQueue()->Add(*cmd))
	{
//		LOG_ERROR_(m_logger, "Failed to add command %p to Q", cmd);
		delete cmd;
		cmd = NULL;
		result = false;
	}

	return result;
}


bool HandleNetworkEntryCommand::triggerWIB(bool& startWIB)
{
	// command checks if WIB should be triggered
	// and starts WIB (submits appropriate command)
	IMOTreeManager* treeManager = m_pch.GetMOTreeManager();
	if (!treeManager)
	{
		// command failed to execute
		return false;
	}

	bool result = true;
	String operatorURI = "./WiMAXSupp/Operator";

	String idHomeNSP = ToString(m_homeNspID);
	IMOTreeManager::ChildrenPaths children;
	if (treeManager->GetChildren(operatorURI, children) == e_Ok)
	{
		bool homeNspIDFound = false;
		String homeNSP;
		homeNSP.reserve(128);
		for (unsigned i = 0; !homeNspIDFound && i < children.size(); ++i)
		{
			homeNSP = operatorURI;
			homeNSP += "/";
			homeNSP += children[i].c_str();
			homeNSP += "/NetworkParameters/H-NSP";

			IMOTreeManager::ChildrenPaths childrenHNSP;
			if (treeManager->GetChildren(homeNSP, childrenHNSP) == e_Ok)
			{
				String nodeValue;
				String homeNSPIdUri;
				homeNSPIdUri.reserve(128);
				for (unsigned j = 0; j < childrenHNSP.size(); ++j)
				{
					homeNSPIdUri = homeNSP;
					homeNSPIdUri += "/";
					homeNSPIdUri +=	childrenHNSP[j].c_str();
					homeNSPIdUri += "/H-NSP-ID";
					if (treeManager->GetValue(homeNSPIdUri, nodeValue) == e_Ok)
					{
						if (nodeValue == idHomeNSP)
						{
							homeNspIDFound = true;
							break;
						}
					}
				}
			}
		}

		if (!homeNspIDFound)
		{
			startWIB = true;
		}
	}

	return result;
}


