/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */


#include "commontypes.h"
#include "serverexchange/commands/TriggerDRMDCollectingCommand.h"
#include "treemanager/IMOTreeManager.h"
#include "treemanager/MOTreeExecCommand.h"
#include "daemon/INotificationCenter.h"

using namespace NS_DM_Client;

TriggerDRMDCollectingCommand::TriggerDRMDCollectingCommand(ProfileComponentsHolder* pch, int duration)
	: m_pch(pch), m_duration(duration), m_readDuration(false)
{
}

TriggerDRMDCollectingCommand::TriggerDRMDCollectingCommand(ProfileComponentsHolder* pch)
	: m_pch(pch), m_duration(0), m_readDuration(true)
{
}

bool TriggerDRMDCollectingCommand::Execute()
{
	if (m_readDuration)
	{
		String valueDuration;
		if (e_Ok == m_pch->GetMOTreeManager()->GetValue(URI_DIAGNOSTICS_DURATION, valueDuration, NULL))
		{
			m_duration = atoi(valueDuration.c_str());
		}
		else
		{
			return false;
		}
	}

	if (0 == m_duration || 3 == m_duration || 4 == m_duration)
	{
		return false;
	}
	
	return requestData(m_duration);
}

bool TriggerDRMDCollectingCommand::requestData(int duration)
{
	m_pch->GetNotificationCenter()->StartDRMDCollecting(duration);
	return true;
}
