/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "MOTreeManagerTransactionData.h"

namespace NS_DM_Client
{
	class MOTreeManagerListenerCollection;
	class IDeviceUpdater;
	class IDeviceAdapter;
	class ProfileComponentsHolder;
	class MOTreeManager;

	class MOTreeManagerTransaction
	{
	public:
		MOTreeManagerTransaction();
		~MOTreeManagerTransaction();

		bool Init(MOTreeManagerListenerCollection* listeners, IDeviceAdapter* deviceAdapter, 
				NS_DataStorage::IDataStorage* dataStorage, MOTreeManager* manager);
		bool Release();

		bool StartTransaction();
		bool Commit();
		bool Rollback(bool delete_backup = true);

		MOTreeManagerTransactionData& Data();

		// for unit tests
		void SetDeviceUpdater(IDeviceUpdater* updater);

	private:
		MOTreeManagerTransaction(const MOTreeManagerTransaction&);
		MOTreeManagerTransaction& operator=(const MOTreeManagerTransaction&);

		bool executeDeviceUpdater();
		bool rollbackFromCommit();
		void callListeners();

		MOTreeManagerTransactionData m_data;
		IDeviceUpdater* m_deviceUpdater; // also identify if component is inited
		MOTreeManager* m_manager;
		MOTreeManagerListenerCollection* m_listeners;
		bool m_inTransaction;
	};
}
