#pragma once

#include "serverexchange/IServerExchangeManager.h"
#include "serverexchange/wrappers/SCommandAdapter.h"
#include "serverexchange/Connection.h"

namespace NS_DM_Client
{

class ServerExchangeManagerMock : public IServerExchangeManager
{
public:
    // from IComponent
	virtual bool Init(const StringMap& settings, const String& loggerInstance, ProfileComponentsHolder& pch);
	virtual bool Start();
	virtual bool Stop();
	virtual void Release();

   // from ServerExchangeManager
	virtual void AddCommand(NS_SyncMLCommand::SCommandPtr ptrCommand, const char *connid);
	virtual void AddCommands(NS_SyncMLCommand::SCommandsArray &commands, const char *connid);
	virtual NS_Communication::Connection * DefaultConnection();
	virtual void HandleNetworkEntrance(int homeNspID, const char* operatorName, bool startWIB);
	virtual void NotifyDiagnosticsReady(String &serverID, String &origID);
	virtual void NotifyFWJobStatus(String &serverID, int result, ExecPtr &exec, const char *alertType);
	virtual bool HasAccountFor(String &serverID);
	virtual void SetServerPollerInfo(bool pollingSupported, int pollingInterval, int pollingAttempts);
	virtual void SetConnectionsInfo(NS_Communication::ConnInfoList &);
	virtual void SetDevInfo(Funambol::DevInf &devInf);
	virtual void StartClientSession();
	virtual void StartClientSession(NS_SyncMLCommand::SAlertCommandPtr ptrAlert);
	virtual void RequestSessionStart(const NS_NotificationListener::SessionInfo& sessionInfo);
	virtual void ProcessBootstrapMessage(const char *bsm, uint length);
	virtual void RequestFWUpdate(bool userInitiated, const char *fumouri, int data);
	virtual void UpdateFW(ExecPtr cmd);
	virtual void StartWIB();
	virtual NS_Communication::FirmwareManager* GetFirmwareManager();
};

}
