/*
 * Copyright 2010 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

//-------------------------------------------------------------------------------------------

#include "common/Errors.h"
#include "treemanager/IMOTreeManager.h"
#include "treemanager/TreeManagerUtils.h"
#include "treemanager/ValidDMAccByServerIDCommand.h"
#include "Logger/LoggerMacroses.h"

//-------------------------------------------------------------------------------------------

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Communication;

//-------------------------------------------------------------------------------------------

const char* const c_LogName = "DMAccountCommand";

//-------------------------------------------------------------------------------------------

ValidDMAccByServerIDCommand::ValidDMAccByServerIDCommand(ProfileComponentsHolder &pch, IResultSink &rsink, const String& serverID) : 
	ValidDMAccAvailableCommand(pch, rsink), m_serverID(serverID)
{
}

//-------------------------------------------------------------------------------------------

bool ValidDMAccByServerIDCommand::Execute()
{
	IMOTreeManager::ChildrenPaths accounts;
	
	if (TMUtils::IsDMAccNode(m_treeManager, URI_DMACC))
	{
		FStringBuffer uriAccount = URI_DMACC;
		if (isEqualAccountServerId(uriAccount, m_serverID))
		{
			FStringBuffer uri(URI_DMACC);
			m_resultSink.SetResult(isValidAccount(uri));
		}
		else
		{
			m_resultSink.SetResult(false);
		}
	}
	else if (e_Ok == m_pch.GetMOTreeManager()->GetChildren(URI_DMACC, accounts, NULL))
	{
		bool brc = false;

		for (size_t i=0; i<accounts.size(); ++i)
		{
			brc = false;
			String accname = accounts[i];
			FStringBuffer uriAccount0(URI_DMACC);
			uriAccount0.append("/").append(accname.c_str()); // this is uri ./DMAcc/X
			brc = isValidAccount(uriAccount0);
			if (isEqualAccountServerId(uriAccount0, m_serverID))
			{
				// account with equal ServerID is found. not continue
				GDLDEBUG("Account vith equal ServerID is found. URI '%s', ServerID '%s', Is valid '%d'. Stop searching.", uriAccount0.c_str(), m_serverID.c_str(), brc);
				break;
			}				
		}
		
		m_resultSink.SetResult(brc);
	}
	else
	{
		m_resultSink.SetResult(false);
	}
	return true;
}

//-------------------------------------------------------------------------------------------

bool ValidDMAccByServerIDCommand::isEqualAccountServerId(FStringBuffer& uriAccount, const String& serverID)
{
	FStringBuffer sID;
	if (!getLeafValue(uriAccount, "ServerID", sID))
	{
		GDLERROR("failed to get ServerID");
		return false;
	}
	
	if (sID != FStringBuffer(serverID.c_str()))	
	{
		GDLERROR("account ServerID is not equal with comparable");
		return false;
	}

	return true;
}

//-------------------------------------------------------------------------------------------
