/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.persist.jpa;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.internal.util.;
import com.google.inject.persist.PersistModule;
import com.google.inject.persist.PersistService;
import com.google.inject.persist.UnitOfWork;
import com.google.inject.persist.finder.DynamicFinder;
import com.google.inject.persist.finder.Finder;
import com.google.inject.persist.jpa.Jpa;
import com.google.inject.persist.jpa.JpaFinderProxy;
import com.google.inject.persist.jpa.JpaLocalTxnInterceptor;
import com.google.inject.persist.jpa.JpaPersistService;
import com.google.inject.util.Providers;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JpaPersistModule
extends PersistModule {
    private final String jpaUnit;
    private Properties properties;
    private MethodInterceptor transactionInterceptor;
    private final List<Class<?>> dynamicFinders = .Lists.newArrayList();

    public JpaPersistModule(String jpaUnit) {
        .Preconditions.checkArgument((null != jpaUnit && jpaUnit.length() > 0 ? 1 : 0) != 0, (Object)"JPA unit name must be a non-empty string.");
        this.jpaUnit = jpaUnit;
    }

    @Override
    protected void configurePersistence() {
        this.bindConstant().annotatedWith(Jpa.class).to(this.jpaUnit);
        if (null != this.properties) {
            this.bind(Properties.class).annotatedWith(Jpa.class).toInstance((Object)this.properties);
        } else {
            this.bind(Properties.class).annotatedWith(Jpa.class).toProvider(Providers.of(null));
        }
        this.bind(JpaPersistService.class).in(Singleton.class);
        this.bind(PersistService.class).to(JpaPersistService.class);
        this.bind(UnitOfWork.class).to(JpaPersistService.class);
        this.bind(EntityManager.class).toProvider(JpaPersistService.class);
        this.bind(EntityManagerFactory.class).toProvider(JpaPersistService.EntityManagerFactoryProvider.class);
        this.transactionInterceptor = new JpaLocalTxnInterceptor();
        this.requestInjection(this.transactionInterceptor);
        for (Class<?> finder : this.dynamicFinders) {
            this.bindFinder(finder);
        }
    }

    @Override
    protected MethodInterceptor getTransactionInterceptor() {
        return this.transactionInterceptor;
    }

    public JpaPersistModule properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public <T> JpaPersistModule addFinder(Class<T> iface) {
        this.dynamicFinders.add(iface);
        return this;
    }

    private <T> void bindFinder(Class<T> iface) {
        if (!this.isDynamicFinderValid(iface)) {
            return;
        }
        InvocationHandler finderInvoker = new InvocationHandler(){
            @Inject
            JpaFinderProxy finderProxy;

            public Object invoke(final Object thisObject, final Method method, final Object[] args) throws Throwable {
                if (!method.isAnnotationPresent(Finder.class)) {
                    return method.invoke((Object)this, args);
                }
                return this.finderProxy.invoke(new MethodInvocation(){

                    public Method getMethod() {
                        return method;
                    }

                    public Object[] getArguments() {
                        return null == args ? new Object[]{} : args;
                    }

                    public Object proceed() throws Throwable {
                        return method.invoke(thisObject, args);
                    }

                    public Object getThis() {
                        throw new UnsupportedOperationException("Bottomless proxies don't expose a this.");
                    }

                    public AccessibleObject getStaticPart() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
        this.requestInjection(finderInvoker);
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{iface}, finderInvoker);
        this.bind(iface).toInstance(proxy);
    }

    private boolean isDynamicFinderValid(Class<?> iface) {
        boolean valid = true;
        if (!iface.isInterface()) {
            this.addError(iface + " is not an interface. Dynamic Finders must be interfaces.", new Object[0]);
            valid = false;
        }
        for (Method method : iface.getMethods()) {
            DynamicFinder finder = DynamicFinder.from(method);
            if (null != finder) continue;
            this.addError("Dynamic Finder methods must be annotated with @Finder, but " + iface + "." + method.getName() + " was not", new Object[0]);
            valid = false;
        }
        return valid;
    }
}

