package infra.services.impl
import play.api.mvc._
import play.api._
import play.api.i18n._
import com.typesafe.plugin._
import play.api.Play.current
import infra.services._

case class SendMailImpl() extends SendMail{
  def sendMail(notifyTypeForMessage: Long, fromAddress: String, partId: Long, designChangeId: Long, notifyTypeForLink: Long, state: Long, toAddress:String): Unit = {
    var mail = use[com.typesafe.plugin.MailerPlugin].email
    mail.addFrom(fromAddress)
    mail.setSubject(Messages("mail.message1" + notifyTypeForMessage))
    mail.addRecipient(toAddress)
    if(partId != 0) {
    	mail.sendHtml("<html>" + Messages("mail.message1" + notifyTypeForMessage) +
    		"<br /><a href=\"http://" + Messages("apserver.name") + ":9000/notifylist?page=0&partId=" + partId + "&notifyType=" + notifyTypeForLink + "&state=" + state + "\" " + ">" + Messages("mail.message2") + "</a></html>")
    } else {
    	mail.sendHtml("<html>" + Messages("mail.message1" + notifyTypeForMessage) +
    		"<br /><a href=\"http://" + Messages("apserver.name") + ":9000/designChangeNotifylist?page=0&designChangeId=" + designChangeId + "&notifyType=" + notifyTypeForLink + "&state=" + state + "\" " + ">" + Messages("mail.message2") + "</a></html>")      
    }
  }
}
