/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.persist;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.PersistService;
import com.google.inject.persist.UnitOfWork;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

@Singleton
public final class PersistFilter
implements Filter {
    private final UnitOfWork unitOfWork;
    private final PersistService persistService;

    @Inject
    public PersistFilter(UnitOfWork unitOfWork, PersistService persistService) {
        this.unitOfWork = unitOfWork;
        this.persistService = persistService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.persistService.start();
    }

    public void destroy() {
        this.persistService.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.unitOfWork.begin();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.unitOfWork.end();
        }
    }
}

