package mvc
import play.api._
import play.api.mvc._

case class AuthAction[A](action :Action[A]) extends Action[A]{ 
  def apply(request: Request[A]):Result = {
    request.headers.get("Authorization").map { user =>
    	action(request)
    } getOrElse {
    	action(null)
    	// Httpサーバー側で認証する場合は、下一行をコメントアウト。上１行をコメント解除。
    	//action(request)
     }
  }
  lazy val parser = action.parser
}

