package controllers

import play.api._
import play.api.mvc._
import play.api.i18n._
import models._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import java.io.File
import java.io.FileInputStream

object AtachController extends Controller{

  val Home = Redirect(routes.PartsMasterController.list(0,""))

  def showAtach(id:Long) = Action {
	  inTransaction {
		  val atach = PartsListDb.atachs.where(p => p.id === id).head	  
		  val file = new File(Messages("atach.folder") + "/" + atach.fileName)
		  val data = new Array[Byte](file.length().asInstanceOf[Int])
		  val io = new FileInputStream(file)
		  io.read(data)
		  io.close
		  Ok(data).as(atach.contentType)
	  }
  }
  
  def dropAtach(id:Long) = Action {
	  inTransaction {
	    PartsListDb.atachs.deleteWhere(a => a.id === id)
    	Home.flashing("success" -> "Part %s has been created".format(id))	    
	  }
  }

}