/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import java.util.concurrent.TimeUnit;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.Stats$;
import scala.concurrent.stm.ccstm.WakeupManager;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005uc!B\u0001\u0003\u0001\tQ!\u0001\u0003*fiJL8+\u001a;\u000b\u0005\r!\u0011!B2dgRl'BA\u0003\u0007\u0003\r\u0019H/\u001c\u0006\u0003\u000f!\t!bY8oGV\u0014(/\u001a8u\u0015\u0005I\u0011!B:dC2\f7C\u0001\u0001\f!\ta\u0011#D\u0001\u000e\u0015\tqq\"\u0001\u0003mC:<'\"\u0001\t\u0002\t)\fg/Y\u0005\u0003%5\u0011aa\u00142kK\u000e$\b\u0002\u0003\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\tML'0Z\u0002\u0001+\u00059\u0002C\u0001\r\u001a\u001b\u0005A\u0011B\u0001\u000e\t\u0005\rIe\u000e\u001e\u0005\t9\u0001\u0011\t\u0011)A\u0005/\u0005)1/\u001b>fA!Aa\u0004\u0001B\u0001B\u0003%q$A\u0004iC:$G.Z:\u0011\u0007a\u0001#%\u0003\u0002\"\u0011\t)\u0011I\u001d:bsB\u00121%\u000b\t\u0004I\u0015:S\"\u0001\u0002\n\u0005\u0019\u0012!A\u0002%b]\u0012dW\r\u0005\u0002)S1\u0001A!\u0003\u0016\u0001\u0003\u0003\u0005\tQ!\u0001,\u0005\ryF%M\t\u0003Y=\u0002\"\u0001G\u0017\n\u00059B!a\u0002(pi\"Lgn\u001a\t\u00031AJ!!\r\u0005\u0003\u0007\u0005s\u0017\u0010\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0003!1XM]:j_:\u001c\bc\u0001\r!kA\u0011a'\u000f\b\u0003I]J!\u0001\u000f\u0002\u0002\u000b\r\u001b5\u000bV'\n\u0005iZ$a\u0002,feNLwN\u001c\u0006\u0003q\tAQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtD\u0003B A\u0003\u001e\u0003\"\u0001\n\u0001\t\u000bQa\u0004\u0019A\f\t\u000bya\u0004\u0019\u0001\"\u0011\u0007a\u00013\t\r\u0002E\rB\u0019A%J#\u0011\u0005!2E!\u0003\u0016=\u0003\u0003\u0005\tQ!\u0001,\u0011\u0015\u0019D\b1\u00015\u0011\u0015I\u0005\u0001\"\u0001K\u0003)\tw/Y5u%\u0016$(/\u001f\u000b\u0003\u0017:\u0003\"\u0001\u0007'\n\u00055C!\u0001\u0002'p]\u001eDQa\u0014%A\u0002-\u000bA\u0002^5nK>,HOT1o_ND3\u0001S)`!\rA\"\u000bV\u0005\u0003'\"\u0011a\u0001\u001e5s_^\u001c\bC\u0001\u0015V\t\u00151\u0006A1\u0001X\u0005\u0005!\u0016C\u0001\u0017Y!\tIFL\u0004\u0002\u00195&\u00111\fC\u0001\ba\u0006\u001c7.Y4f\u0013\tifLA\u0005UQJ|w/\u00192mK*\u00111\fC\u0012\u0002AB\u0011\u0011m\u001a\b\u0003Ejs!a\u00194\u000e\u0003\u0011T!!Z\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011B\u00015_\u0005QIe\u000e^3seV\u0004H/\u001a3Fq\u000e,\u0007\u000f^5p]\")!\u000e\u0001C\u0005W\u0006a\u0011\r\u001e;f[B$\u0018i^1jiR\u0011An\u001c\t\u000315L!A\u001c\u0005\u0003\u000f\t{w\u000e\\3b]\")\u0001/\u001ba\u0001\u0017\u0006aa.\u00198p\t\u0016\fG\r\\5oK\"\u001a\u0011N]0\u0011\u0007a\u00116\u000f\u0005\u0002)i\u0012)a\u000b\u0001b\u0001/\")a\u000f\u0001C\u0005o\u0006!\"\r\\8dW&tw-\u0011;uK6\u0004H/Q<bSR$R\u0001\u001c=z\u0003\u000bAQ\u0001];A\u0002-CqA_;\u0011\u0002\u0003\u000710A\u0003fm\u0016tG\u000f\u0005\u0002}\u007f:\u0011A%`\u0005\u0003}\n\tQbV1lKV\u0004X*\u00198bO\u0016\u0014\u0018\u0002BA\u0001\u0003\u0007\u0011Q!\u0012<f]RT!A \u0002\t\u0011\u0005\u001dQ\u000f%AA\u0002]\t\u0011!\u001b\u0015\u0004k\u0006-\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0001\"\u0001\u0006b]:|G/\u0019;j_:LA!!\u0006\u0002\u0010\t9A/Y5me\u0016\u001c\u0007\u0006B;\u0002\u001a}\u0003B\u0001\u0007*\u0002\u001cA\u0019\u0001&!\b\u0005\u000bY\u0003!\u0019A,\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$\u0005\u0001\u0012\r\u001a3QK:$\u0017N\\4XC.,W\u000f\u001d\u000b\u0006Y\u0006\u0015\u00121\u0007\u0005\t\u0003O\ty\u00021\u0001\u0002*\u00051\u0001.\u00198eY\u0016\u0004D!a\u000b\u00020A!A%JA\u0017!\rA\u0013q\u0006\u0003\f\u0003c\ty\"!A\u0001\u0002\u000b\u00051FA\u0002`IIBq!!\u000e\u0002 \u0001\u0007Q'A\u0002wKJDC!a\b\u0002\f!9\u00111\b\u0001\u0005\n\u0005u\u0012aB2iC:<W\rZ\u000b\u0002Y\"I\u0011\u0011\t\u0001\u0012\u0002\u0013%\u00111I\u0001\u001fE2|7m[5oO\u0006#H/Z7qi\u0006;\u0018-\u001b;%I\u00164\u0017-\u001e7uII*\"!!\u0012+\u0007m\f9e\u000b\u0002\u0002JA!\u00111JA)\u001b\t\tiE\u0003\u0003\u0002P\u0005=\u0011!C;oG\",7m[3e\u0013\u0011\t\u0019&!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002X\u0001\t\n\u0011\"\u0003\u0002Z\u0005q\"\r\\8dW&tw-\u0011;uK6\u0004H/Q<bSR$C-\u001a4bk2$HeM\u000b\u0003\u00037R3aFA$\u0001")
public class RetrySet {
    private final int size;
    private final Handle<?>[] handles;
    private final long[] versions;

    public int size() {
        return this.size;
    }

    public long awaitRetry(long timeoutNanos) throws InterruptedException {
        if (this.size() == 0 && timeoutNanos == Long.MAX_VALUE) {
            throw new IllegalStateException("explicit retries cannot succeed because cumulative read set is empty");
        }
        long begin = System.nanoTime();
        long d = begin + timeoutNanos;
        long deadline = d < 0L ? Long.MAX_VALUE : d;
        boolean timeoutExceeded = !this.attemptAwait(deadline);
        long actualElapsed = System.nanoTime() - begin;
        if (Stats$.MODULE$.top() != null) {
            Stats$.MODULE$.top().retrySet().$plus$eq(this.size());
            long millis = TimeUnit.NANOSECONDS.toMillis(actualElapsed);
            Stats$.MODULE$.top().retryWaitElapsed().$plus$eq((int)millis);
        }
        return package$.MODULE$.min(actualElapsed, deadline - begin);
    }

    private boolean attemptAwait(long nanoDeadline) throws InterruptedException {
        int spins = 0;
        while (this.size() > 0 && spins < CCSTM$.MODULE$.SpinCount() + CCSTM$.MODULE$.YieldCount()) {
            if (this.changed()) {
                return true;
            }
            if ((spins += this.size()) <= CCSTM$.MODULE$.SpinCount()) continue;
            Thread.yield();
            if (nanoDeadline == Long.MAX_VALUE || System.nanoTime() <= nanoDeadline) continue;
            return false;
        }
        return this.blockingAttemptAwait(nanoDeadline, this.blockingAttemptAwait$default$2(), this.blockingAttemptAwait$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean blockingAttemptAwait(long nanoDeadline, WakeupManager.Event event, int i) throws InterruptedException {
        while (true) {
            if (i < 0) {
                if (!event.tryAwaitUntil(nanoDeadline)) return false;
                if (this.changed()) {
                    return true;
                }
                i = this.blockingAttemptAwait$default$3();
                event = this.blockingAttemptAwait$default$2();
                continue;
            }
            Handle<?> h = this.handles[i];
            if (event.addSource(h)) {
                if (!this.addPendingWakeup(h, this.versions[i])) return true;
                --i;
                continue;
            }
            if (this.changed()) {
                return true;
            }
            i = this.blockingAttemptAwait$default$3();
            event = this.blockingAttemptAwait$default$2();
        }
    }

    private WakeupManager.Event blockingAttemptAwait$default$2() {
        return CCSTM$.MODULE$.wakeupManager().subscribe();
    }

    private int blockingAttemptAwait$default$3() {
        return this.size() - 1;
    }

    private boolean addPendingWakeup(Handle<?> handle, long ver) {
        boolean bl;
        block1: {
            long m;
            do {
                if (!CCSTM$.MODULE$.changing(m = handle.meta()) && CCSTM$.MODULE$.version(m) == ver) continue;
                bl = false;
                break block1;
            } while (!CCSTM$.MODULE$.pendingWakeups(m) && !handle.metaCAS(m, CCSTM$.MODULE$.withPendingWakeups(m)));
            bl = true;
        }
        return bl;
    }

    private boolean changed() {
        for (int i = this.size() - 1; i >= 0; --i) {
            long m = this.handles[i].meta();
            if (!CCSTM$.MODULE$.changing(m) && CCSTM$.MODULE$.version(m) == this.versions[i]) continue;
            return true;
        }
        return false;
    }

    public RetrySet(int size, Handle<?>[] handles, long[] versions) {
        this.size = size;
        this.handles = handles;
        this.versions = versions;
    }
}

