/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.xid;

import javax.transaction.xa.Xid;
import tyrex.services.UUID;
import tyrex.tm.xid.BaseXid;
import tyrex.tm.xid.BranchXid;

public final class GlobalXid
extends BaseXid {
    private final byte[] _global;
    protected static final char[] XID_PREFIX_ARRAY = BaseXid.createPrefix(14745550);
    protected static final int GLOBAL_FORMAT_ID = 14745550;

    public GlobalXid() {
        byte[] byArray = UUID.createBinary();
        StringBuffer stringBuffer = new StringBuffer(45);
        stringBuffer.append(XID_PREFIX_ARRAY);
        int n = byArray.length;
        while (n-- > 0) {
            stringBuffer.append(BaseXid.HEX_DIGITS[(byArray[n] & 0xF0) >> 4]);
            stringBuffer.append(BaseXid.HEX_DIGITS[byArray[n] & 0xF]);
        }
        this._global = byArray;
        this._string = stringBuffer.toString();
    }

    GlobalXid(String string, byte[] byArray) {
        this._string = string;
        this._global = byArray;
    }

    public int getFormatId() {
        return 14745550;
    }

    public byte[] getGlobalTransactionId() {
        return this._global;
    }

    public byte[] getBranchQualifier() {
        return BaseXid.EMPTY_ARRAY;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GlobalXid) {
            return this._string.equals(((GlobalXid)object)._string);
        }
        if (object instanceof Xid) {
            Xid xid = (Xid)object;
            if (xid.getFormatId() != 14745550) {
                return false;
            }
            byte[] byArray = xid.getBranchQualifier();
            if (byArray != null && byArray.length != 0) {
                return false;
            }
            byArray = xid.getGlobalTransactionId();
            if (byArray == null || byArray.length != this._global.length) {
                return false;
            }
            int n = byArray.length;
            while (n-- > 0) {
                if (byArray[n] == this._global[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Xid newBranch() {
        return new BranchXid(this._global, UUID.createBinary());
    }
}

