package models
import org.squeryl.Schema
import org.squeryl.PrimitiveTypeMode._
object PartsListDb extends Schema{
  val parts = table[Part]
  val atachs = table[Atach]
  val projects = table[Project]
  val users = table[User]
  val notifies = table[Notify]
  val replies = table[Reply]
  
  on( parts )( p => declare(
    // varchar(20)にしてみる
    p.name is ( dbType( "varchar(20)" ) )
  ) )
  
  val partRelations = manyToManyRelation(parts, parts).via[PartRelation]((pp,cp,pr) => (pp.id === pr.parentId, cp.id === pr.childId))
  val projectMembers = manyToManyRelation(projects, users).via[ProjectMembers]((p, u, pm) => (p.id === pm.projectId, u.id === pm.userId))
  val partsAtache = oneToManyRelation(parts, atachs).via((p, a) => p.id === a.foreignId)
  val projectParts = oneToManyRelation(projects, parts).via((pr, p) => pr.id === p.projectId)
  val partsNotifies = oneToManyRelation(parts, notifies).via((p, n) => p.id === n.partId)
  val userNotifies = oneToManyRelation(users, notifies).via((u, n) => u.id === n.announceId)
  val NotifyReplies = oneToManyRelation(notifies, replies).via((n, r) => n.id === r.notifyId)
  val userReplies = oneToManyRelation(users, replies).via((u, r) => u.id === r.replyUserId)
  val replyRelations = oneToManyRelation(replies, replies).via((pre, cre) => pre.id === cre.replyId )
}