<?php
/*
 * Created on  2010/03/26
 * Filename    jpayment.php
 * Project     opencart142
 * Support     http://forum.opencart.jp/
 * Author      http://officesoya.net/ I.Suzuki
 *
 */
class ControllerPaymentJpayment extends Controller {
	protected function index() {
		$this->language->load('payment/jpayment');

		$this->data['text_credit_card'] = $this->language->get('text_credit_card');
		$this->data['text_wait'] = $this->language->get('text_wait');

		$this->data['entry_cc_owner'] = $this->language->get('entry_cc_owner');
		$this->data['entry_cc_owner_first'] = $this->language->get('entry_cc_owner_first');
		$this->data['entry_cc_owner_last'] = $this->language->get('entry_cc_owner_last');
		$this->data['entry_cc_number'] = $this->language->get('entry_cc_number');
		$this->data['entry_cc_expire_date'] = $this->language->get('entry_cc_expire_date');
		$this->data['text_timeout'] = $this->language->get('text_timeout');

		$this->data['button_confirm'] = $this->language->get('button_confirm');
		$this->data['button_back'] = $this->language->get('button_back');

		$this->data['months'] = array ();

		for ($i = 1; $i <= 12; $i++) {
			$this->data['months'][] = array (
				'text' => strftime('%m',
				mktime(0,
				0,
				0,
				$i,
				1,
				2000
			)), 'value' => sprintf('%02d', $i));
		}

		$today = getdate();

		$this->data['year_expire'] = array ();

		for ($i = $today['year']; $i < $today['year'] + 11; $i++) {
			$this->data['year_expire'][] = array (
				'text' => strftime('%Y',
				mktime(0,
				0,
				0,
				1,
				1,
				$i
			)), 'value' => strftime('%Y', mktime(0, 0, 0, 1, 1, $i)));
		}

		if ($this->request->get['route'] != 'checkout/guest_step_3') {
			$this->data['back'] = HTTPS_SERVER . 'index.php?route=checkout/payment';
		} else {
			$this->data['back'] = HTTPS_SERVER . 'index.php?route=checkout/guest_step_2';
		}

		$this->id = 'payment';

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/jpayment.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/payment/jpayment.tpl';
		} else {
			$this->template = 'default/template/payment/jpayment.tpl';
		}

		$this->render();
	}

	public function send() {
		$this->load->model('checkout/order');
		$this->language->load('payment/jpayment');

		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		$url = 'https://credit.j-payment.co.jp/gateway/gateway.aspx';

		$data = 'aid=' . $this->config->get('jpayment_merchant_id');
		$data .= '&jb=' . $this->config->get('jpayment_job_type');
		$data .= '&rt=1';
		$data .= '&cod=' . $this->session->data['order_id'];
		$data .= '&cn=' . urlencode($this->request->post['cc_number']);
		$data .= '&ed=' . urlencode(substr($this->request->post['cc_expire_date_year'], '2') . $this->request->post['cc_expire_date_month']);
		$data .= '&fn=' . urlencode($this->request->post['cc_owner_first']);
		$data .= '&ln=' . urlencode($this->request->post['cc_owner_last']);
		$data .= '&em=' . urlencode($order_info['email']);
		$data .= '&pn=' . urlencode(str_replace("-", "", $order_info['telephone']));
		if (isset ($order_info['sepalete']) && $order_info['sepalete']==1) {
			$data .= '&am=' . urlencode($this->currency->format($order_info['subtotal'], $order_info['currency'], $order_info['value'], FALSE));
			$data .= '&tx=' . urlencode($this->currency->format($order_info['tax'], $order_info['currency'], $order_info['value'], FALSE));
			$data .= '&sf=' . urlencode($this->currency->format($order_info['shippingcost'], $order_info['currency'], $order_info['value'], FALSE));
		} else {
			$data .= '&am=' . urlencode($this->currency->format($order_info['total'], $order_info['currency'], $order_info['value'], FALSE));
			$data .= '&tx=0';
			$data .= '&sf=0';
		}

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		$response = curl_exec($ch);

		curl_close($ch);
		list ($payment_id, $result, $ap, $error, $god, $order_id, $am, $tax, $trans, $total) = explode(",", $response);
		$json = array ();

		if ($result === "1") {
			$message = $this->language->get('text_message') . "\n";
			$message .= $this->language->get('text_setlement_no') . $payment_id . "\n";
			$message .= $this->language->get('text_claimant_name') . $this->config->get('config_store') . "\n";
			$message .= $this->language->get('text_contact_telephone') . $this->config->get('config_telephone') . "\n";
			$message .= $this->language->get('text_order_id') . $order_id . "\n";

			$this->model_checkout_order->confirm($this->session->data['order_id'], $this->config->get('config_order_status_id'));
			$this->model_checkout_order->update($this->session->data['order_id'], $this->config->get('jpayment_order_status_id'), $message, TRUE);

			$json['success'] = HTTPS_SERVER . 'index.php?route=checkout/success';
		} else {
			$error_message = "";
			switch ($error) {
				case "ER010" :
					$error_message = $this->language->get('error_busy') . '(' . $error . ')';
					break;
				case "ER012" :
					$error_message = $this->language->get('error_email_failed') . '(' . $error . ')';
					break;
				case "ER013" :
					$error_message = $this->language->get('error_card') . '(' . $error . ')';
					break;
				case "ER015" :
					$error_message = $this->language->get('error_card_brand') . '(' . $error . ')';
					break;
				case "ER016" :
					$error_message = $this->language->get('error_card_est') . '(' . $error . ')';
					break;
				case "ER017" :
				case "ER018" :
					$error_message = $this->language->get('error_card_config') . '(' . $error . ')';
					break;
				case "ER999" :
					$error_message = $this->language->get('error_failed_mente') . '(' . $error . ')';
					break;
				default :
					$error_message = $this->language->get('error_failed') . '(' . $error . ')';
					break;

			}
			$json['error'] = $error_message;
		}
		$this->load->library('json');

		$this->response->setOutput(Json :: encode($json));
	}
}
?>
