# This makefile has been automatically generated from the OpenSSL distribution.
# This single makefile will build the complete OpenSSL distribution and
# by default leave the 'intertesting' output files in .\out and the stuff
# that needs deleting in .\tmp.
# The file was generated by running 'make makefile.one', which
# does a 'make files', which writes all the environment variables from all
# the makefiles to the file call MINFO.  This file is used by
# util\mk1mf.pl to generate makefile.one.
# The 'makefile per directory' system suites me when developing this
# library and also so I can 'distribute' indervidual library sections.
# The one monster makefile better suits building in non-unix
# environments.

INSTALLTOP=\usr\local\ssl

# Set your compiler options
PLATFORM=Mingw32
CC=gcc
CFLAG=-DL_ENDIAN -DDSO_WIN32 -fomit-frame-pointer -O3 -march=i486 -Wall -DBN_ASM -DMD5_ASM -DSHA1_ASM -DOPENSSL_BN_ASM_PART_WORDS -DOPENSSL_NO_CAMELLIA -DOPENSSL_NO_SEED -DOPENSSL_NO_RC5 -DOPENSSL_NO_MDC2 -DOPENSSL_NO_TLSEXT -DOPENSSL_NO_KRB5 -DOPENSSL_NO_DYNAMIC_ENGINE    
APP_CFLAG=
LIB_CFLAG=
SHLIB_CFLAG=
APP_EX_OBJ=
SHLIB_EX_OBJ=
# add extra libraries to this define, for solaris -lsocket -lnsl would
# be added
EX_LIBS=-lwsock32 -lgdi32

# The OpenSSL directory
SRC_D=.

LINK=${CC}
LFLAGS=${CFLAGS}
RSC=

AES_ASM_OBJ=
AES_ASM_SRC=
BN_ASM_OBJ=$(OBJ_D)\bn-win32.o
BN_ASM_SRC=crypto/bn/asm/bn-win32.s
BNCO_ASM_OBJ=$(OBJ_D)\co-win32.o
BNCO_ASM_SRC=crypto/bn/asm/co-win32.s
DES_ENC_OBJ=$(OBJ_D)\d-win32.o $(OBJ_D)\y-win32.o
DES_ENC_SRC=crypto/des/asm/d-win32.s crypto/des/asm/y-win32.s
BF_ENC_OBJ=$(OBJ_D)\b-win32.o
BF_ENC_SRC=crypto/bf/asm/b-win32.s
CAST_ENC_OBJ=
CAST_ENC_SRC=
RC4_ENC_OBJ=$(OBJ_D)\r4-win32.o
RC4_ENC_SRC=crypto/rc4/asm/r4-win32.s
RC5_ENC_OBJ=$(OBJ_D)\r5-win32.o
RC5_ENC_SRC=crypto/rc5/asm/r5-win32.s
MD5_ASM_OBJ=$(OBJ_D)\m5-win32.o
MD5_ASM_SRC=crypto/md5/asm/m5-win32.s
SHA1_ASM_OBJ=$(OBJ_D)\s1-win32.o
SHA1_ASM_SRC=crypto/sha/asm/s1-win32.s
RMD160_ASM_OBJ=$(OBJ_D)\rm-win32.o
RMD160_ASM_SRC=crypto/ripemd/asm/rm-win32.s
CPUID_ASM_OBJ=$(OBJ_D)\cpu-win32.o
CPUID_ASM_SRC=crypto/cpu-win32.s

# The output directory for everything intersting
OUT_D=out
# The output directory for all the temporary muck
TMP_D=tmp
# The output directory for the header files
INC_D=outinc
INCO_D=outinc\openssl

PERL=perl
CP=copy
RM=del
RANLIB=ranlib
MKDIR=mkdir
MKLIB=ar r
MLFLAGS=
ASM=as

######################################################
# You should not need to touch anything below this point
######################################################

E_EXE=openssl
SSL=ssl
CRYPTO=crypto

# BIN_D  - Binary output directory
# TEST_D - Binary test file output directory
# LIB_D  - library output directory
# ENG_D  - dynamic engine output directory
# Note: if you change these point to different directories then uncomment out
# the lines around the 'NB' comment below.
# 
BIN_D=$(OUT_D)
TEST_D=$(OUT_D)
LIB_D=$(OUT_D)
ENG_D=$(OUT_D)

# INCL_D - local library directory
# OBJ_D  - temp object file directory
OBJ_D=$(TMP_D)
INCL_D=$(TMP_D)

O_SSL=     $(LIB_D)\lib$(SSL).a
O_CRYPTO=  $(LIB_D)\lib$(CRYPTO).a
SO_SSL=    lib$(SSL)
SO_CRYPTO= lib$(CRYPTO)
L_SSL=     $(LIB_D)\lib$(SSL).a
L_CRYPTO=  $(LIB_D)\lib$(CRYPTO).a

L_LIBS= $(L_SSL) $(L_CRYPTO)

######################################################
# Don't touch anything below this point
######################################################

INC=-I$(INC_D) -I$(INCL_D)
APP_CFLAGS=$(INC) $(CFLAG) $(APP_CFLAG)
LIB_CFLAGS=$(INC) $(CFLAG) $(LIB_CFLAG)
SHLIB_CFLAGS=$(INC) $(CFLAG) $(LIB_CFLAG) $(SHLIB_CFLAG)
LIBS_DEP=$(O_CRYPTO) $(O_SSL)

#############################################
HEADER=$(INCL_D)\e_os.h \
	$(INCL_D)\cryptlib.h $(INCL_D)\buildinf.h $(INCL_D)\md32_common.h \
	$(INCL_D)\o_time.h $(INCL_D)\o_str.h $(INCL_D)\o_dir.h \
	$(INCL_D)\md4_locl.h $(INCL_D)\md5_locl.h $(INCL_D)\sha_locl.h \
	$(INCL_D)\rmd_locl.h $(INCL_D)\rmdconst.h $(INCL_D)\des_locl.h \
	$(INCL_D)\rpc_des.h $(INCL_D)\spr.h $(INCL_D)\des_ver.h \
	$(INCL_D)\rc2_locl.h $(INCL_D)\rc4_locl.h $(INCL_D)\idea_lcl.h \
	$(INCL_D)\bf_pi.h $(INCL_D)\bf_locl.h $(INCL_D)\cast_s.h \
	$(INCL_D)\cast_lcl.h $(INCL_D)\aes_locl.h $(INCL_D)\bn_lcl.h \
	$(INCL_D)\bn_prime.h $(INCL_D)\ec_lcl.h $(INCL_D)\ech_locl.h \
	$(INCL_D)\ecs_locl.h $(INCL_D)\bio_lcl.h $(INCL_D)\obj_dat.h \
	$(INCL_D)\pcy_int.h $(INCL_D)\conf_def.h $(INCL_D)\ui_locl.h \
	$(INCL_D)\str_locl.h $(INCL_D)\ssl_locl.h $(INCL_D)\kssl_lcl.h \
	$(INCL_D)\apps.h $(INCL_D)\progs.h $(INCL_D)\s_apps.h \
	$(INCL_D)\testdsa.h $(INCL_D)\testrsa.h $(INCL_D)\e_4758cca_err.c \
	$(INCL_D)\e_4758cca_err.h $(INCL_D)\e_aep_err.c $(INCL_D)\e_aep_err.h \
	$(INCL_D)\e_atalla_err.c $(INCL_D)\e_atalla_err.h $(INCL_D)\e_cswift_err.c \
	$(INCL_D)\e_cswift_err.h $(INCL_D)\e_gmp_err.c $(INCL_D)\e_gmp_err.h \
	$(INCL_D)\e_chil_err.c $(INCL_D)\e_chil_err.h $(INCL_D)\e_nuron_err.c \
	$(INCL_D)\e_nuron_err.h $(INCL_D)\e_sureware_err.c $(INCL_D)\e_sureware_err.h \
	$(INCL_D)\e_ubsec_err.c $(INCL_D)\e_ubsec_err.h 

EXHEADER=$(INCO_D)\e_os2.h \
	$(INCO_D)\crypto.h $(INCO_D)\tmdiff.h $(INCO_D)\opensslv.h \
	$(INCO_D)\opensslconf.h $(INCO_D)\ebcdic.h $(INCO_D)\symhacks.h \
	$(INCO_D)\ossl_typ.h $(INCO_D)\md2.h $(INCO_D)\md4.h \
	$(INCO_D)\md5.h $(INCO_D)\sha.h $(INCO_D)\hmac.h \
	$(INCO_D)\ripemd.h $(INCO_D)\des.h $(INCO_D)\des_old.h \
	$(INCO_D)\rc2.h $(INCO_D)\rc4.h $(INCO_D)\idea.h \
	$(INCO_D)\blowfish.h $(INCO_D)\cast.h $(INCO_D)\aes.h \
	$(INCO_D)\bn.h $(INCO_D)\rsa.h $(INCO_D)\dsa.h \
	$(INCO_D)\dso.h $(INCO_D)\dh.h $(INCO_D)\ec.h \
	$(INCO_D)\ecdh.h $(INCO_D)\ecdsa.h $(INCO_D)\buffer.h \
	$(INCO_D)\bio.h $(INCO_D)\stack.h $(INCO_D)\safestack.h \
	$(INCO_D)\lhash.h $(INCO_D)\rand.h $(INCO_D)\err.h \
	$(INCO_D)\objects.h $(INCO_D)\obj_mac.h $(INCO_D)\evp.h \
	$(INCO_D)\asn1.h $(INCO_D)\asn1_mac.h $(INCO_D)\asn1t.h \
	$(INCO_D)\pem.h $(INCO_D)\pem2.h $(INCO_D)\x509.h \
	$(INCO_D)\x509_vfy.h $(INCO_D)\x509v3.h $(INCO_D)\conf.h \
	$(INCO_D)\conf_api.h $(INCO_D)\txt_db.h $(INCO_D)\pkcs7.h \
	$(INCO_D)\pkcs12.h $(INCO_D)\comp.h $(INCO_D)\engine.h \
	$(INCO_D)\ocsp.h $(INCO_D)\ui.h $(INCO_D)\ui_compat.h \
	$(INCO_D)\krb5_asn.h $(INCO_D)\store.h $(INCO_D)\pqueue.h \
	$(INCO_D)\pq_compat.h $(INCO_D)\ssl.h $(INCO_D)\ssl2.h \
	$(INCO_D)\ssl3.h $(INCO_D)\ssl23.h $(INCO_D)\tls1.h \
	$(INCO_D)\dtls1.h $(INCO_D)\kssl.h 

T_OBJ=$(OBJ_D)\md2test.o \
	$(OBJ_D)\md4test.o $(OBJ_D)\md5test.o $(OBJ_D)\shatest.o \
	$(OBJ_D)\sha1test.o $(OBJ_D)\sha256t.o $(OBJ_D)\sha512t.o \
	$(OBJ_D)\hmactest.o $(OBJ_D)\rmdtest.o $(OBJ_D)\destest.o \
	$(OBJ_D)\rc2test.o $(OBJ_D)\rc4test.o $(OBJ_D)\ideatest.o \
	$(OBJ_D)\bftest.o $(OBJ_D)\casttest.o $(OBJ_D)\bntest.o \
	$(OBJ_D)\exptest.o $(OBJ_D)\rsa_test.o $(OBJ_D)\dsatest.o \
	$(OBJ_D)\dhtest.o $(OBJ_D)\ectest.o $(OBJ_D)\ecdhtest.o \
	$(OBJ_D)\ecdsatest.o $(OBJ_D)\randtest.o $(OBJ_D)\evp_test.o \
	$(OBJ_D)\enginetest.o $(OBJ_D)\ssltest.o 

E_OBJ=$(OBJ_D)\verify.o \
	$(OBJ_D)\asn1pars.o $(OBJ_D)\req.o $(OBJ_D)\dgst.o \
	$(OBJ_D)\dh.o $(OBJ_D)\dhparam.o $(OBJ_D)\enc.o \
	$(OBJ_D)\passwd.o $(OBJ_D)\gendh.o $(OBJ_D)\errstr.o \
	$(OBJ_D)\ca.o $(OBJ_D)\pkcs7.o $(OBJ_D)\crl2p7.o \
	$(OBJ_D)\crl.o $(OBJ_D)\rsa.o $(OBJ_D)\rsautl.o \
	$(OBJ_D)\dsa.o $(OBJ_D)\dsaparam.o $(OBJ_D)\ec.o \
	$(OBJ_D)\ecparam.o $(OBJ_D)\x509.o $(OBJ_D)\genrsa.o \
	$(OBJ_D)\gendsa.o $(OBJ_D)\s_server.o $(OBJ_D)\s_client.o \
	$(OBJ_D)\speed.o $(OBJ_D)\s_time.o $(OBJ_D)\apps.o \
	$(OBJ_D)\s_cb.o $(OBJ_D)\s_socket.o $(OBJ_D)\app_rand.o \
	$(OBJ_D)\version.o $(OBJ_D)\sess_id.o $(OBJ_D)\ciphers.o \
	$(OBJ_D)\nseq.o $(OBJ_D)\pkcs12.o $(OBJ_D)\pkcs8.o \
	$(OBJ_D)\spkac.o $(OBJ_D)\smime.o $(OBJ_D)\rand.o \
	$(OBJ_D)\engine.o $(OBJ_D)\ocsp.o $(OBJ_D)\prime.o \
	$(OBJ_D)\openssl.o 

SSLOBJ=$(OBJ_D)\s2_meth.o \
	$(OBJ_D)\s2_srvr.o $(OBJ_D)\s2_clnt.o $(OBJ_D)\s2_lib.o \
	$(OBJ_D)\s2_enc.o $(OBJ_D)\s2_pkt.o $(OBJ_D)\s3_meth.o \
	$(OBJ_D)\s3_srvr.o $(OBJ_D)\s3_clnt.o $(OBJ_D)\s3_lib.o \
	$(OBJ_D)\s3_enc.o $(OBJ_D)\s3_pkt.o $(OBJ_D)\s3_both.o \
	$(OBJ_D)\s23_meth.o $(OBJ_D)\s23_srvr.o $(OBJ_D)\s23_clnt.o \
	$(OBJ_D)\s23_lib.o $(OBJ_D)\s23_pkt.o $(OBJ_D)\t1_meth.o \
	$(OBJ_D)\t1_srvr.o $(OBJ_D)\t1_clnt.o $(OBJ_D)\t1_lib.o \
	$(OBJ_D)\t1_enc.o $(OBJ_D)\d1_meth.o $(OBJ_D)\d1_srvr.o \
	$(OBJ_D)\d1_clnt.o $(OBJ_D)\d1_lib.o $(OBJ_D)\d1_pkt.o \
	$(OBJ_D)\d1_both.o $(OBJ_D)\d1_enc.o $(OBJ_D)\ssl_lib.o \
	$(OBJ_D)\ssl_err2.o $(OBJ_D)\ssl_cert.o $(OBJ_D)\ssl_sess.o \
	$(OBJ_D)\ssl_ciph.o $(OBJ_D)\ssl_stat.o $(OBJ_D)\ssl_rsa.o \
	$(OBJ_D)\ssl_asn1.o $(OBJ_D)\ssl_txt.o $(OBJ_D)\ssl_algs.o \
	$(OBJ_D)\bio_ssl.o $(OBJ_D)\ssl_err.o $(OBJ_D)\kssl.o 

CRYPTOOBJ=$(OBJ_D)\cryptlib.o \
	$(OBJ_D)\mem.o $(OBJ_D)\mem_clr.o $(OBJ_D)\mem_dbg.o \
	$(OBJ_D)\cversion.o $(CPUID_ASM_OBJ) $(OBJ_D)\ex_data.o \
	$(OBJ_D)\tmdiff.o $(OBJ_D)\cpt_err.o $(OBJ_D)\ebcdic.o \
	$(OBJ_D)\uid.o $(OBJ_D)\o_time.o $(OBJ_D)\o_str.o \
	$(OBJ_D)\o_dir.o $(OBJ_D)\md2_dgst.o $(OBJ_D)\md2_one.o \
	$(OBJ_D)\md4_dgst.o $(OBJ_D)\md4_one.o $(OBJ_D)\md5_dgst.o \
	$(MD5_ASM_OBJ) $(OBJ_D)\md5_one.o $(OBJ_D)\sha_dgst.o \
	$(OBJ_D)\sha1dgst.o $(SHA1_ASM_OBJ) $(OBJ_D)\sha_one.o \
	$(OBJ_D)\sha1_one.o $(OBJ_D)\sha256.o $(OBJ_D)\sha512.o \
	$(OBJ_D)\hmac.o $(OBJ_D)\rmd_dgst.o $(RMD160_ASM_OBJ) \
	$(OBJ_D)\rmd_one.o $(OBJ_D)\set_key.o $(OBJ_D)\ecb_enc.o \
	$(OBJ_D)\cbc_enc.o $(OBJ_D)\ecb3_enc.o $(OBJ_D)\cfb64enc.o \
	$(OBJ_D)\cfb64ede.o $(OBJ_D)\cfb_enc.o $(OBJ_D)\ofb64ede.o \
	$(OBJ_D)\enc_read.o $(OBJ_D)\enc_writ.o $(OBJ_D)\ofb64enc.o \
	$(OBJ_D)\ofb_enc.o $(OBJ_D)\str2key.o $(OBJ_D)\pcbc_enc.o \
	$(OBJ_D)\qud_cksm.o $(OBJ_D)\rand_key.o $(DES_ENC_OBJ) \
	$(OBJ_D)\fcrypt.o $(OBJ_D)\xcbc_enc.o $(OBJ_D)\rpc_enc.o \
	$(OBJ_D)\cbc_cksm.o $(OBJ_D)\ede_cbcm_enc.o $(OBJ_D)\des_old.o \
	$(OBJ_D)\des_old2.o $(OBJ_D)\read2pwd.o $(OBJ_D)\rc2_ecb.o \
	$(OBJ_D)\rc2_skey.o $(OBJ_D)\rc2_cbc.o $(OBJ_D)\rc2cfb64.o \
	$(OBJ_D)\rc2ofb64.o $(OBJ_D)\rc4_skey.o $(RC4_ENC_OBJ) \
	$(OBJ_D)\i_cbc.o $(OBJ_D)\i_cfb64.o $(OBJ_D)\i_ofb64.o \
	$(OBJ_D)\i_ecb.o $(OBJ_D)\i_skey.o $(OBJ_D)\bf_skey.o \
	$(OBJ_D)\bf_ecb.o $(BF_ENC_OBJ) $(OBJ_D)\bf_cfb64.o \
	$(OBJ_D)\bf_ofb64.o $(OBJ_D)\c_skey.o $(OBJ_D)\c_ecb.o \
	$(OBJ_D)\c_enc.o $(OBJ_D)\c_cfb64.o $(OBJ_D)\c_ofb64.o \
	$(OBJ_D)\aes_misc.o $(OBJ_D)\aes_ecb.o $(OBJ_D)\aes_cfb.o \
	$(OBJ_D)\aes_ofb.o $(OBJ_D)\aes_ctr.o $(OBJ_D)\aes_ige.o \
	$(OBJ_D)\aes_core.o $(OBJ_D)\aes_cbc.o $(OBJ_D)\bn_add.o \
	$(OBJ_D)\bn_div.o $(OBJ_D)\bn_exp.o $(OBJ_D)\bn_lib.o \
	$(OBJ_D)\bn_ctx.o $(OBJ_D)\bn_mul.o $(OBJ_D)\bn_mod.o \
	$(OBJ_D)\bn_print.o $(OBJ_D)\bn_rand.o $(OBJ_D)\bn_shift.o \
	$(OBJ_D)\bn_word.o $(OBJ_D)\bn_blind.o $(OBJ_D)\bn_kron.o \
	$(OBJ_D)\bn_sqrt.o $(OBJ_D)\bn_gcd.o $(OBJ_D)\bn_prime.o \
	$(OBJ_D)\bn_err.o $(OBJ_D)\bn_sqr.o $(BN_ASM_OBJ) \
	$(OBJ_D)\bn_recp.o $(OBJ_D)\bn_mont.o $(OBJ_D)\bn_mpi.o \
	$(OBJ_D)\bn_exp2.o $(OBJ_D)\bn_gf2m.o $(OBJ_D)\bn_nist.o \
	$(OBJ_D)\bn_depr.o $(OBJ_D)\bn_const.o $(OBJ_D)\rsa_eay.o \
	$(OBJ_D)\rsa_gen.o $(OBJ_D)\rsa_lib.o $(OBJ_D)\rsa_sign.o \
	$(OBJ_D)\rsa_saos.o $(OBJ_D)\rsa_err.o $(OBJ_D)\rsa_pk1.o \
	$(OBJ_D)\rsa_ssl.o $(OBJ_D)\rsa_none.o $(OBJ_D)\rsa_oaep.o \
	$(OBJ_D)\rsa_chk.o $(OBJ_D)\rsa_null.o $(OBJ_D)\rsa_pss.o \
	$(OBJ_D)\rsa_x931.o $(OBJ_D)\rsa_asn1.o $(OBJ_D)\rsa_depr.o \
	$(OBJ_D)\dsa_gen.o $(OBJ_D)\dsa_key.o $(OBJ_D)\dsa_lib.o \
	$(OBJ_D)\dsa_asn1.o $(OBJ_D)\dsa_vrf.o $(OBJ_D)\dsa_sign.o \
	$(OBJ_D)\dsa_err.o $(OBJ_D)\dsa_ossl.o $(OBJ_D)\dsa_depr.o \
	$(OBJ_D)\dso_dl.o $(OBJ_D)\dso_dlfcn.o $(OBJ_D)\dso_err.o \
	$(OBJ_D)\dso_lib.o $(OBJ_D)\dso_null.o $(OBJ_D)\dso_openssl.o \
	$(OBJ_D)\dso_win32.o $(OBJ_D)\dso_vms.o $(OBJ_D)\dh_asn1.o \
	$(OBJ_D)\dh_gen.o $(OBJ_D)\dh_key.o $(OBJ_D)\dh_lib.o \
	$(OBJ_D)\dh_check.o $(OBJ_D)\dh_err.o $(OBJ_D)\dh_depr.o \
	$(OBJ_D)\ec_lib.o $(OBJ_D)\ecp_smpl.o $(OBJ_D)\ecp_mont.o \
	$(OBJ_D)\ecp_nist.o $(OBJ_D)\ec_cvt.o $(OBJ_D)\ec_mult.o \
	$(OBJ_D)\ec_err.o $(OBJ_D)\ec_curve.o $(OBJ_D)\ec_check.o \
	$(OBJ_D)\ec_print.o $(OBJ_D)\ec_asn1.o $(OBJ_D)\ec_key.o \
	$(OBJ_D)\ec2_smpl.o $(OBJ_D)\ec2_mult.o $(OBJ_D)\ech_lib.o \
	$(OBJ_D)\ech_ossl.o $(OBJ_D)\ech_key.o $(OBJ_D)\ech_err.o \
	$(OBJ_D)\ecs_lib.o $(OBJ_D)\ecs_asn1.o $(OBJ_D)\ecs_ossl.o \
	$(OBJ_D)\ecs_sign.o $(OBJ_D)\ecs_vrf.o $(OBJ_D)\ecs_err.o \
	$(OBJ_D)\buffer.o $(OBJ_D)\buf_err.o $(OBJ_D)\bio_lib.o \
	$(OBJ_D)\bio_cb.o $(OBJ_D)\bio_err.o $(OBJ_D)\bss_mem.o \
	$(OBJ_D)\bss_null.o $(OBJ_D)\bss_fd.o $(OBJ_D)\bss_file.o \
	$(OBJ_D)\bss_sock.o $(OBJ_D)\bss_conn.o $(OBJ_D)\bf_null.o \
	$(OBJ_D)\bf_buff.o $(OBJ_D)\b_print.o $(OBJ_D)\b_dump.o \
	$(OBJ_D)\b_sock.o $(OBJ_D)\bss_acpt.o $(OBJ_D)\bf_nbio.o \
	$(OBJ_D)\bss_log.o $(OBJ_D)\bss_bio.o $(OBJ_D)\bss_dgram.o \
	$(OBJ_D)\stack.o $(OBJ_D)\lhash.o $(OBJ_D)\lh_stats.o \
	$(OBJ_D)\md_rand.o $(OBJ_D)\randfile.o $(OBJ_D)\rand_lib.o \
	$(OBJ_D)\rand_err.o $(OBJ_D)\rand_egd.o $(OBJ_D)\rand_win.o \
	$(OBJ_D)\rand_unix.o $(OBJ_D)\rand_os2.o $(OBJ_D)\rand_nw.o \
	$(OBJ_D)\err.o $(OBJ_D)\err_all.o $(OBJ_D)\err_prn.o \
	$(OBJ_D)\o_names.o $(OBJ_D)\obj_dat.o $(OBJ_D)\obj_lib.o \
	$(OBJ_D)\obj_err.o $(OBJ_D)\encode.o $(OBJ_D)\digest.o \
	$(OBJ_D)\evp_enc.o $(OBJ_D)\evp_key.o $(OBJ_D)\evp_acnf.o \
	$(OBJ_D)\e_des.o $(OBJ_D)\e_bf.o $(OBJ_D)\e_idea.o \
	$(OBJ_D)\e_des3.o $(OBJ_D)\e_rc4.o $(OBJ_D)\e_aes.o \
	$(OBJ_D)\names.o $(OBJ_D)\e_xcbc_d.o $(OBJ_D)\e_rc2.o \
	$(OBJ_D)\e_cast.o $(OBJ_D)\e_rc5.o $(OBJ_D)\m_null.o \
	$(OBJ_D)\m_md2.o $(OBJ_D)\m_md4.o $(OBJ_D)\m_md5.o \
	$(OBJ_D)\m_sha.o $(OBJ_D)\m_sha1.o $(OBJ_D)\m_dss.o \
	$(OBJ_D)\m_dss1.o $(OBJ_D)\m_ripemd.o $(OBJ_D)\m_ecdsa.o \
	$(OBJ_D)\p_open.o $(OBJ_D)\p_seal.o $(OBJ_D)\p_sign.o \
	$(OBJ_D)\p_verify.o $(OBJ_D)\p_lib.o $(OBJ_D)\p_enc.o \
	$(OBJ_D)\p_dec.o $(OBJ_D)\bio_md.o $(OBJ_D)\bio_b64.o \
	$(OBJ_D)\bio_enc.o $(OBJ_D)\evp_err.o $(OBJ_D)\e_null.o \
	$(OBJ_D)\c_all.o $(OBJ_D)\c_allc.o $(OBJ_D)\c_alld.o \
	$(OBJ_D)\evp_lib.o $(OBJ_D)\bio_ok.o $(OBJ_D)\evp_pkey.o \
	$(OBJ_D)\evp_pbe.o $(OBJ_D)\p5_crpt.o $(OBJ_D)\p5_crpt2.o \
	$(OBJ_D)\e_old.o $(OBJ_D)\a_object.o $(OBJ_D)\a_bitstr.o \
	$(OBJ_D)\a_utctm.o $(OBJ_D)\a_gentm.o $(OBJ_D)\a_time.o \
	$(OBJ_D)\a_int.o $(OBJ_D)\a_octet.o $(OBJ_D)\a_print.o \
	$(OBJ_D)\a_type.o $(OBJ_D)\a_set.o $(OBJ_D)\a_dup.o \
	$(OBJ_D)\a_d2i_fp.o $(OBJ_D)\a_i2d_fp.o $(OBJ_D)\a_enum.o \
	$(OBJ_D)\a_utf8.o $(OBJ_D)\a_sign.o $(OBJ_D)\a_digest.o \
	$(OBJ_D)\a_verify.o $(OBJ_D)\a_mbstr.o $(OBJ_D)\a_strex.o \
	$(OBJ_D)\x_algor.o $(OBJ_D)\x_val.o $(OBJ_D)\x_pubkey.o \
	$(OBJ_D)\x_sig.o $(OBJ_D)\x_req.o $(OBJ_D)\x_attrib.o \
	$(OBJ_D)\x_bignum.o $(OBJ_D)\x_long.o $(OBJ_D)\x_name.o \
	$(OBJ_D)\x_x509.o $(OBJ_D)\x_x509a.o $(OBJ_D)\x_crl.o \
	$(OBJ_D)\x_info.o $(OBJ_D)\x_spki.o $(OBJ_D)\nsseq.o \
	$(OBJ_D)\d2i_pu.o $(OBJ_D)\d2i_pr.o $(OBJ_D)\i2d_pu.o \
	$(OBJ_D)\i2d_pr.o $(OBJ_D)\t_req.o $(OBJ_D)\t_x509.o \
	$(OBJ_D)\t_x509a.o $(OBJ_D)\t_crl.o $(OBJ_D)\t_pkey.o \
	$(OBJ_D)\t_spki.o $(OBJ_D)\t_bitst.o $(OBJ_D)\tasn_new.o \
	$(OBJ_D)\tasn_fre.o $(OBJ_D)\tasn_enc.o $(OBJ_D)\tasn_dec.o \
	$(OBJ_D)\tasn_utl.o $(OBJ_D)\tasn_typ.o $(OBJ_D)\f_int.o \
	$(OBJ_D)\f_string.o $(OBJ_D)\n_pkey.o $(OBJ_D)\f_enum.o \
	$(OBJ_D)\a_hdr.o $(OBJ_D)\x_pkey.o $(OBJ_D)\a_bool.o \
	$(OBJ_D)\x_exten.o $(OBJ_D)\asn1_gen.o $(OBJ_D)\asn1_par.o \
	$(OBJ_D)\asn1_lib.o $(OBJ_D)\asn1_err.o $(OBJ_D)\a_meth.o \
	$(OBJ_D)\a_bytes.o $(OBJ_D)\a_strnid.o $(OBJ_D)\evp_asn1.o \
	$(OBJ_D)\asn_pack.o $(OBJ_D)\p5_pbe.o $(OBJ_D)\p5_pbev2.o \
	$(OBJ_D)\p8_pkey.o $(OBJ_D)\asn_moid.o $(OBJ_D)\pem_sign.o \
	$(OBJ_D)\pem_seal.o $(OBJ_D)\pem_info.o $(OBJ_D)\pem_lib.o \
	$(OBJ_D)\pem_all.o $(OBJ_D)\pem_err.o $(OBJ_D)\pem_x509.o \
	$(OBJ_D)\pem_xaux.o $(OBJ_D)\pem_oth.o $(OBJ_D)\pem_pk8.o \
	$(OBJ_D)\pem_pkey.o $(OBJ_D)\x509_def.o $(OBJ_D)\x509_d2.o \
	$(OBJ_D)\x509_r2x.o $(OBJ_D)\x509_cmp.o $(OBJ_D)\x509_obj.o \
	$(OBJ_D)\x509_req.o $(OBJ_D)\x509spki.o $(OBJ_D)\x509_vfy.o \
	$(OBJ_D)\x509_set.o $(OBJ_D)\x509cset.o $(OBJ_D)\x509rset.o \
	$(OBJ_D)\x509_err.o $(OBJ_D)\x509name.o $(OBJ_D)\x509_v3.o \
	$(OBJ_D)\x509_ext.o $(OBJ_D)\x509_att.o $(OBJ_D)\x509type.o \
	$(OBJ_D)\x509_lu.o $(OBJ_D)\x_all.o $(OBJ_D)\x509_txt.o \
	$(OBJ_D)\x509_trs.o $(OBJ_D)\by_file.o $(OBJ_D)\by_dir.o \
	$(OBJ_D)\x509_vpm.o $(OBJ_D)\v3_bcons.o $(OBJ_D)\v3_bitst.o \
	$(OBJ_D)\v3_conf.o $(OBJ_D)\v3_extku.o $(OBJ_D)\v3_ia5.o \
	$(OBJ_D)\v3_lib.o $(OBJ_D)\v3_prn.o $(OBJ_D)\v3_utl.o \
	$(OBJ_D)\v3err.o $(OBJ_D)\v3_genn.o $(OBJ_D)\v3_alt.o \
	$(OBJ_D)\v3_skey.o $(OBJ_D)\v3_akey.o $(OBJ_D)\v3_pku.o \
	$(OBJ_D)\v3_int.o $(OBJ_D)\v3_enum.o $(OBJ_D)\v3_sxnet.o \
	$(OBJ_D)\v3_cpols.o $(OBJ_D)\v3_crld.o $(OBJ_D)\v3_purp.o \
	$(OBJ_D)\v3_info.o $(OBJ_D)\v3_ocsp.o $(OBJ_D)\v3_akeya.o \
	$(OBJ_D)\v3_pmaps.o $(OBJ_D)\v3_pcons.o $(OBJ_D)\v3_ncons.o \
	$(OBJ_D)\v3_pcia.o $(OBJ_D)\v3_pci.o $(OBJ_D)\pcy_cache.o \
	$(OBJ_D)\pcy_node.o $(OBJ_D)\pcy_data.o $(OBJ_D)\pcy_map.o \
	$(OBJ_D)\pcy_tree.o $(OBJ_D)\pcy_lib.o $(OBJ_D)\v3_asid.o \
	$(OBJ_D)\v3_addr.o $(OBJ_D)\conf_err.o $(OBJ_D)\conf_lib.o \
	$(OBJ_D)\conf_api.o $(OBJ_D)\conf_def.o $(OBJ_D)\conf_mod.o \
	$(OBJ_D)\conf_mall.o $(OBJ_D)\conf_sap.o $(OBJ_D)\txt_db.o \
	$(OBJ_D)\pk7_asn1.o $(OBJ_D)\pk7_lib.o $(OBJ_D)\pkcs7err.o \
	$(OBJ_D)\pk7_doit.o $(OBJ_D)\pk7_smime.o $(OBJ_D)\pk7_attr.o \
	$(OBJ_D)\pk7_mime.o $(OBJ_D)\p12_add.o $(OBJ_D)\p12_asn.o \
	$(OBJ_D)\p12_attr.o $(OBJ_D)\p12_crpt.o $(OBJ_D)\p12_crt.o \
	$(OBJ_D)\p12_decr.o $(OBJ_D)\p12_init.o $(OBJ_D)\p12_key.o \
	$(OBJ_D)\p12_kiss.o $(OBJ_D)\p12_mutl.o $(OBJ_D)\p12_utl.o \
	$(OBJ_D)\p12_npas.o $(OBJ_D)\pk12err.o $(OBJ_D)\p12_p8d.o \
	$(OBJ_D)\p12_p8e.o $(OBJ_D)\comp_lib.o $(OBJ_D)\comp_err.o \
	$(OBJ_D)\c_rle.o $(OBJ_D)\c_zlib.o $(OBJ_D)\eng_err.o \
	$(OBJ_D)\eng_lib.o $(OBJ_D)\eng_list.o $(OBJ_D)\eng_init.o \
	$(OBJ_D)\eng_ctrl.o $(OBJ_D)\eng_table.o $(OBJ_D)\eng_pkey.o \
	$(OBJ_D)\eng_fat.o $(OBJ_D)\eng_all.o $(OBJ_D)\tb_rsa.o \
	$(OBJ_D)\tb_dsa.o $(OBJ_D)\tb_ecdsa.o $(OBJ_D)\tb_dh.o \
	$(OBJ_D)\tb_ecdh.o $(OBJ_D)\tb_rand.o $(OBJ_D)\tb_store.o \
	$(OBJ_D)\tb_cipher.o $(OBJ_D)\tb_digest.o $(OBJ_D)\eng_openssl.o \
	$(OBJ_D)\eng_cnf.o $(OBJ_D)\eng_dyn.o $(OBJ_D)\eng_cryptodev.o \
	$(OBJ_D)\eng_padlock.o $(OBJ_D)\ocsp_asn.o $(OBJ_D)\ocsp_ext.o \
	$(OBJ_D)\ocsp_ht.o $(OBJ_D)\ocsp_lib.o $(OBJ_D)\ocsp_cl.o \
	$(OBJ_D)\ocsp_srv.o $(OBJ_D)\ocsp_prn.o $(OBJ_D)\ocsp_vfy.o \
	$(OBJ_D)\ocsp_err.o $(OBJ_D)\ui_err.o $(OBJ_D)\ui_lib.o \
	$(OBJ_D)\ui_openssl.o $(OBJ_D)\ui_util.o $(OBJ_D)\ui_compat.o \
	$(OBJ_D)\krb5_asn.o $(OBJ_D)\str_err.o $(OBJ_D)\str_lib.o \
	$(OBJ_D)\str_meth.o $(OBJ_D)\str_mem.o $(OBJ_D)\pqueue.o \
	$(OBJ_D)\e_4758cca.o $(OBJ_D)\e_aep.o $(OBJ_D)\e_atalla.o \
	$(OBJ_D)\e_cswift.o $(OBJ_D)\e_gmp.o $(OBJ_D)\e_chil.o \
	$(OBJ_D)\e_nuron.o $(OBJ_D)\e_sureware.o $(OBJ_D)\e_ubsec.o \
	$(BNCO_ASM_OBJ) 

T_EXE=$(TEST_D)\md2test \
	$(TEST_D)\md4test $(TEST_D)\md5test $(TEST_D)\shatest \
	$(TEST_D)\sha1test $(TEST_D)\sha256t $(TEST_D)\sha512t \
	$(TEST_D)\hmactest $(TEST_D)\rmdtest $(TEST_D)\destest \
	$(TEST_D)\rc2test $(TEST_D)\rc4test $(TEST_D)\ideatest \
	$(TEST_D)\bftest $(TEST_D)\casttest $(TEST_D)\bntest \
	$(TEST_D)\exptest $(TEST_D)\rsa_test $(TEST_D)\dsatest \
	$(TEST_D)\dhtest $(TEST_D)\ectest $(TEST_D)\ecdhtest \
	$(TEST_D)\ecdsatest $(TEST_D)\randtest $(TEST_D)\evp_test \
	$(TEST_D)\enginetest $(TEST_D)\ssltest 

E_SHLIB=

###################################################################
all: banner $(TMP_D) $(BIN_D) $(TEST_D) $(LIB_D) $(INCO_D) headers lib exe

banner:
	@echo Building OpenSSL

$(TMP_D):
	$(MKDIR) $(TMP_D)
# NB: uncomment out these lines if BIN_D, TEST_D and LIB_D are different
#$(BIN_D):
#	$(MKDIR) $(BIN_D)
#
#$(TEST_D):
#	$(MKDIR) $(TEST_D)

$(LIB_D):
	$(MKDIR) $(LIB_D)

$(INCO_D): $(INC_D)
	$(MKDIR) $(INCO_D)

$(INC_D):
	$(MKDIR) $(INC_D)

headers: $(HEADER) $(EXHEADER)
	@

lib: $(LIBS_DEP) $(E_SHLIB)

exe: $(T_EXE) $(BIN_D)\$(E_EXE)

install: all
	$(MKDIR) $(INSTALLTOP)
	$(MKDIR) $(INSTALLTOP)\bin
	$(MKDIR) $(INSTALLTOP)\include
	$(MKDIR) $(INSTALLTOP)\include\openssl
	$(MKDIR) $(INSTALLTOP)\lib
	$(CP) $(INCO_D)\*.[ch] $(INSTALLTOP)\include\openssl
	$(CP) $(BIN_D)\$(E_EXE) $(INSTALLTOP)\bin
	$(CP) apps\openssl.cnf $(INSTALLTOP)
	$(CP) $(O_SSL) $(INSTALLTOP)\lib
	$(CP) $(O_CRYPTO) $(INSTALLTOP)\lib



test: $(T_EXE)
	cd $(BIN_D)
	..\ms\test

clean:
	$(RM) $(TMP_D)\*.*

vclean:
	$(RM) $(TMP_D)\*.*
	$(RM) $(OUT_D)\*.*

$(INCL_D)\e_os.h: $(SRC_D)\.\e_os.h
	$(CP) $(SRC_D)\.\e_os.h $(INCL_D)\e_os.h

$(INCL_D)\cryptlib.h: $(SRC_D)\crypto\cryptlib.h
	$(CP) $(SRC_D)\crypto\cryptlib.h $(INCL_D)\cryptlib.h

$(INCL_D)\buildinf.h: $(SRC_D)\crypto\buildinf.h
	$(CP) $(SRC_D)\crypto\buildinf.h $(INCL_D)\buildinf.h

$(INCL_D)\md32_common.h: $(SRC_D)\crypto\md32_common.h
	$(CP) $(SRC_D)\crypto\md32_common.h $(INCL_D)\md32_common.h

$(INCL_D)\o_time.h: $(SRC_D)\crypto\o_time.h
	$(CP) $(SRC_D)\crypto\o_time.h $(INCL_D)\o_time.h

$(INCL_D)\o_str.h: $(SRC_D)\crypto\o_str.h
	$(CP) $(SRC_D)\crypto\o_str.h $(INCL_D)\o_str.h

$(INCL_D)\o_dir.h: $(SRC_D)\crypto\o_dir.h
	$(CP) $(SRC_D)\crypto\o_dir.h $(INCL_D)\o_dir.h

$(INCL_D)\md4_locl.h: $(SRC_D)\crypto\md4\md4_locl.h
	$(CP) $(SRC_D)\crypto\md4\md4_locl.h $(INCL_D)\md4_locl.h

$(INCL_D)\md5_locl.h: $(SRC_D)\crypto\md5\md5_locl.h
	$(CP) $(SRC_D)\crypto\md5\md5_locl.h $(INCL_D)\md5_locl.h

$(INCL_D)\sha_locl.h: $(SRC_D)\crypto\sha\sha_locl.h
	$(CP) $(SRC_D)\crypto\sha\sha_locl.h $(INCL_D)\sha_locl.h

$(INCL_D)\rmd_locl.h: $(SRC_D)\crypto\ripemd\rmd_locl.h
	$(CP) $(SRC_D)\crypto\ripemd\rmd_locl.h $(INCL_D)\rmd_locl.h

$(INCL_D)\rmdconst.h: $(SRC_D)\crypto\ripemd\rmdconst.h
	$(CP) $(SRC_D)\crypto\ripemd\rmdconst.h $(INCL_D)\rmdconst.h

$(INCL_D)\des_locl.h: $(SRC_D)\crypto\des\des_locl.h
	$(CP) $(SRC_D)\crypto\des\des_locl.h $(INCL_D)\des_locl.h

$(INCL_D)\rpc_des.h: $(SRC_D)\crypto\des\rpc_des.h
	$(CP) $(SRC_D)\crypto\des\rpc_des.h $(INCL_D)\rpc_des.h

$(INCL_D)\spr.h: $(SRC_D)\crypto\des\spr.h
	$(CP) $(SRC_D)\crypto\des\spr.h $(INCL_D)\spr.h

$(INCL_D)\des_ver.h: $(SRC_D)\crypto\des\des_ver.h
	$(CP) $(SRC_D)\crypto\des\des_ver.h $(INCL_D)\des_ver.h

$(INCL_D)\rc2_locl.h: $(SRC_D)\crypto\rc2\rc2_locl.h
	$(CP) $(SRC_D)\crypto\rc2\rc2_locl.h $(INCL_D)\rc2_locl.h

$(INCL_D)\rc4_locl.h: $(SRC_D)\crypto\rc4\rc4_locl.h
	$(CP) $(SRC_D)\crypto\rc4\rc4_locl.h $(INCL_D)\rc4_locl.h

$(INCL_D)\idea_lcl.h: $(SRC_D)\crypto\idea\idea_lcl.h
	$(CP) $(SRC_D)\crypto\idea\idea_lcl.h $(INCL_D)\idea_lcl.h

$(INCL_D)\bf_pi.h: $(SRC_D)\crypto\bf\bf_pi.h
	$(CP) $(SRC_D)\crypto\bf\bf_pi.h $(INCL_D)\bf_pi.h

$(INCL_D)\bf_locl.h: $(SRC_D)\crypto\bf\bf_locl.h
	$(CP) $(SRC_D)\crypto\bf\bf_locl.h $(INCL_D)\bf_locl.h

$(INCL_D)\cast_s.h: $(SRC_D)\crypto\cast\cast_s.h
	$(CP) $(SRC_D)\crypto\cast\cast_s.h $(INCL_D)\cast_s.h

$(INCL_D)\cast_lcl.h: $(SRC_D)\crypto\cast\cast_lcl.h
	$(CP) $(SRC_D)\crypto\cast\cast_lcl.h $(INCL_D)\cast_lcl.h

$(INCL_D)\aes_locl.h: $(SRC_D)\crypto\aes\aes_locl.h
	$(CP) $(SRC_D)\crypto\aes\aes_locl.h $(INCL_D)\aes_locl.h

$(INCL_D)\bn_lcl.h: $(SRC_D)\crypto\bn\bn_lcl.h
	$(CP) $(SRC_D)\crypto\bn\bn_lcl.h $(INCL_D)\bn_lcl.h

$(INCL_D)\bn_prime.h: $(SRC_D)\crypto\bn\bn_prime.h
	$(CP) $(SRC_D)\crypto\bn\bn_prime.h $(INCL_D)\bn_prime.h

$(INCL_D)\ec_lcl.h: $(SRC_D)\crypto\ec\ec_lcl.h
	$(CP) $(SRC_D)\crypto\ec\ec_lcl.h $(INCL_D)\ec_lcl.h

$(INCL_D)\ech_locl.h: $(SRC_D)\crypto\ecdh\ech_locl.h
	$(CP) $(SRC_D)\crypto\ecdh\ech_locl.h $(INCL_D)\ech_locl.h

$(INCL_D)\ecs_locl.h: $(SRC_D)\crypto\ecdsa\ecs_locl.h
	$(CP) $(SRC_D)\crypto\ecdsa\ecs_locl.h $(INCL_D)\ecs_locl.h

$(INCL_D)\bio_lcl.h: $(SRC_D)\crypto\bio\bio_lcl.h
	$(CP) $(SRC_D)\crypto\bio\bio_lcl.h $(INCL_D)\bio_lcl.h

$(INCL_D)\obj_dat.h: $(SRC_D)\crypto\objects\obj_dat.h
	$(CP) $(SRC_D)\crypto\objects\obj_dat.h $(INCL_D)\obj_dat.h

$(INCL_D)\pcy_int.h: $(SRC_D)\crypto\x509v3\pcy_int.h
	$(CP) $(SRC_D)\crypto\x509v3\pcy_int.h $(INCL_D)\pcy_int.h

$(INCL_D)\conf_def.h: $(SRC_D)\crypto\conf\conf_def.h
	$(CP) $(SRC_D)\crypto\conf\conf_def.h $(INCL_D)\conf_def.h

$(INCL_D)\ui_locl.h: $(SRC_D)\crypto\ui\ui_locl.h
	$(CP) $(SRC_D)\crypto\ui\ui_locl.h $(INCL_D)\ui_locl.h

$(INCL_D)\str_locl.h: $(SRC_D)\crypto\store\str_locl.h
	$(CP) $(SRC_D)\crypto\store\str_locl.h $(INCL_D)\str_locl.h

$(INCL_D)\ssl_locl.h: $(SRC_D)\ssl\ssl_locl.h
	$(CP) $(SRC_D)\ssl\ssl_locl.h $(INCL_D)\ssl_locl.h

$(INCL_D)\kssl_lcl.h: $(SRC_D)\ssl\kssl_lcl.h
	$(CP) $(SRC_D)\ssl\kssl_lcl.h $(INCL_D)\kssl_lcl.h

$(INCL_D)\apps.h: $(SRC_D)\apps\apps.h
	$(CP) $(SRC_D)\apps\apps.h $(INCL_D)\apps.h

$(INCL_D)\progs.h: $(SRC_D)\apps\progs.h
	$(CP) $(SRC_D)\apps\progs.h $(INCL_D)\progs.h

$(INCL_D)\s_apps.h: $(SRC_D)\apps\s_apps.h
	$(CP) $(SRC_D)\apps\s_apps.h $(INCL_D)\s_apps.h

$(INCL_D)\testdsa.h: $(SRC_D)\apps\testdsa.h
	$(CP) $(SRC_D)\apps\testdsa.h $(INCL_D)\testdsa.h

$(INCL_D)\testrsa.h: $(SRC_D)\apps\testrsa.h
	$(CP) $(SRC_D)\apps\testrsa.h $(INCL_D)\testrsa.h

$(INCL_D)\e_4758cca_err.c: $(SRC_D)\engines\e_4758cca_err.c
	$(CP) $(SRC_D)\engines\e_4758cca_err.c $(INCL_D)\e_4758cca_err.c

$(INCL_D)\e_4758cca_err.h: $(SRC_D)\engines\e_4758cca_err.h
	$(CP) $(SRC_D)\engines\e_4758cca_err.h $(INCL_D)\e_4758cca_err.h

$(INCL_D)\e_aep_err.c: $(SRC_D)\engines\e_aep_err.c
	$(CP) $(SRC_D)\engines\e_aep_err.c $(INCL_D)\e_aep_err.c

$(INCL_D)\e_aep_err.h: $(SRC_D)\engines\e_aep_err.h
	$(CP) $(SRC_D)\engines\e_aep_err.h $(INCL_D)\e_aep_err.h

$(INCL_D)\e_atalla_err.c: $(SRC_D)\engines\e_atalla_err.c
	$(CP) $(SRC_D)\engines\e_atalla_err.c $(INCL_D)\e_atalla_err.c

$(INCL_D)\e_atalla_err.h: $(SRC_D)\engines\e_atalla_err.h
	$(CP) $(SRC_D)\engines\e_atalla_err.h $(INCL_D)\e_atalla_err.h

$(INCL_D)\e_cswift_err.c: $(SRC_D)\engines\e_cswift_err.c
	$(CP) $(SRC_D)\engines\e_cswift_err.c $(INCL_D)\e_cswift_err.c

$(INCL_D)\e_cswift_err.h: $(SRC_D)\engines\e_cswift_err.h
	$(CP) $(SRC_D)\engines\e_cswift_err.h $(INCL_D)\e_cswift_err.h

$(INCL_D)\e_gmp_err.c: $(SRC_D)\engines\e_gmp_err.c
	$(CP) $(SRC_D)\engines\e_gmp_err.c $(INCL_D)\e_gmp_err.c

$(INCL_D)\e_gmp_err.h: $(SRC_D)\engines\e_gmp_err.h
	$(CP) $(SRC_D)\engines\e_gmp_err.h $(INCL_D)\e_gmp_err.h

$(INCL_D)\e_chil_err.c: $(SRC_D)\engines\e_chil_err.c
	$(CP) $(SRC_D)\engines\e_chil_err.c $(INCL_D)\e_chil_err.c

$(INCL_D)\e_chil_err.h: $(SRC_D)\engines\e_chil_err.h
	$(CP) $(SRC_D)\engines\e_chil_err.h $(INCL_D)\e_chil_err.h

$(INCL_D)\e_nuron_err.c: $(SRC_D)\engines\e_nuron_err.c
	$(CP) $(SRC_D)\engines\e_nuron_err.c $(INCL_D)\e_nuron_err.c

$(INCL_D)\e_nuron_err.h: $(SRC_D)\engines\e_nuron_err.h
	$(CP) $(SRC_D)\engines\e_nuron_err.h $(INCL_D)\e_nuron_err.h

$(INCL_D)\e_sureware_err.c: $(SRC_D)\engines\e_sureware_err.c
	$(CP) $(SRC_D)\engines\e_sureware_err.c $(INCL_D)\e_sureware_err.c

$(INCL_D)\e_sureware_err.h: $(SRC_D)\engines\e_sureware_err.h
	$(CP) $(SRC_D)\engines\e_sureware_err.h $(INCL_D)\e_sureware_err.h

$(INCL_D)\e_ubsec_err.c: $(SRC_D)\engines\e_ubsec_err.c
	$(CP) $(SRC_D)\engines\e_ubsec_err.c $(INCL_D)\e_ubsec_err.c

$(INCL_D)\e_ubsec_err.h: $(SRC_D)\engines\e_ubsec_err.h
	$(CP) $(SRC_D)\engines\e_ubsec_err.h $(INCL_D)\e_ubsec_err.h

$(INCO_D)\e_os2.h: $(SRC_D)\.\e_os2.h
	$(CP) $(SRC_D)\.\e_os2.h $(INCO_D)\e_os2.h

$(INCO_D)\crypto.h: $(SRC_D)\crypto\crypto.h
	$(CP) $(SRC_D)\crypto\crypto.h $(INCO_D)\crypto.h

$(INCO_D)\tmdiff.h: $(SRC_D)\crypto\tmdiff.h
	$(CP) $(SRC_D)\crypto\tmdiff.h $(INCO_D)\tmdiff.h

$(INCO_D)\opensslv.h: $(SRC_D)\crypto\opensslv.h
	$(CP) $(SRC_D)\crypto\opensslv.h $(INCO_D)\opensslv.h

$(INCO_D)\opensslconf.h: $(SRC_D)\crypto\opensslconf.h
	$(CP) $(SRC_D)\crypto\opensslconf.h $(INCO_D)\opensslconf.h

$(INCO_D)\ebcdic.h: $(SRC_D)\crypto\ebcdic.h
	$(CP) $(SRC_D)\crypto\ebcdic.h $(INCO_D)\ebcdic.h

$(INCO_D)\symhacks.h: $(SRC_D)\crypto\symhacks.h
	$(CP) $(SRC_D)\crypto\symhacks.h $(INCO_D)\symhacks.h

$(INCO_D)\ossl_typ.h: $(SRC_D)\crypto\ossl_typ.h
	$(CP) $(SRC_D)\crypto\ossl_typ.h $(INCO_D)\ossl_typ.h

$(INCO_D)\md2.h: $(SRC_D)\crypto\md2\md2.h
	$(CP) $(SRC_D)\crypto\md2\md2.h $(INCO_D)\md2.h

$(INCO_D)\md4.h: $(SRC_D)\crypto\md4\md4.h
	$(CP) $(SRC_D)\crypto\md4\md4.h $(INCO_D)\md4.h

$(INCO_D)\md5.h: $(SRC_D)\crypto\md5\md5.h
	$(CP) $(SRC_D)\crypto\md5\md5.h $(INCO_D)\md5.h

$(INCO_D)\sha.h: $(SRC_D)\crypto\sha\sha.h
	$(CP) $(SRC_D)\crypto\sha\sha.h $(INCO_D)\sha.h

$(INCO_D)\hmac.h: $(SRC_D)\crypto\hmac\hmac.h
	$(CP) $(SRC_D)\crypto\hmac\hmac.h $(INCO_D)\hmac.h

$(INCO_D)\ripemd.h: $(SRC_D)\crypto\ripemd\ripemd.h
	$(CP) $(SRC_D)\crypto\ripemd\ripemd.h $(INCO_D)\ripemd.h

$(INCO_D)\des.h: $(SRC_D)\crypto\des\des.h
	$(CP) $(SRC_D)\crypto\des\des.h $(INCO_D)\des.h

$(INCO_D)\des_old.h: $(SRC_D)\crypto\des\des_old.h
	$(CP) $(SRC_D)\crypto\des\des_old.h $(INCO_D)\des_old.h

$(INCO_D)\rc2.h: $(SRC_D)\crypto\rc2\rc2.h
	$(CP) $(SRC_D)\crypto\rc2\rc2.h $(INCO_D)\rc2.h

$(INCO_D)\rc4.h: $(SRC_D)\crypto\rc4\rc4.h
	$(CP) $(SRC_D)\crypto\rc4\rc4.h $(INCO_D)\rc4.h

$(INCO_D)\idea.h: $(SRC_D)\crypto\idea\idea.h
	$(CP) $(SRC_D)\crypto\idea\idea.h $(INCO_D)\idea.h

$(INCO_D)\blowfish.h: $(SRC_D)\crypto\bf\blowfish.h
	$(CP) $(SRC_D)\crypto\bf\blowfish.h $(INCO_D)\blowfish.h

$(INCO_D)\cast.h: $(SRC_D)\crypto\cast\cast.h
	$(CP) $(SRC_D)\crypto\cast\cast.h $(INCO_D)\cast.h

$(INCO_D)\aes.h: $(SRC_D)\crypto\aes\aes.h
	$(CP) $(SRC_D)\crypto\aes\aes.h $(INCO_D)\aes.h

$(INCO_D)\bn.h: $(SRC_D)\crypto\bn\bn.h
	$(CP) $(SRC_D)\crypto\bn\bn.h $(INCO_D)\bn.h

$(INCO_D)\rsa.h: $(SRC_D)\crypto\rsa\rsa.h
	$(CP) $(SRC_D)\crypto\rsa\rsa.h $(INCO_D)\rsa.h

$(INCO_D)\dsa.h: $(SRC_D)\crypto\dsa\dsa.h
	$(CP) $(SRC_D)\crypto\dsa\dsa.h $(INCO_D)\dsa.h

$(INCO_D)\dso.h: $(SRC_D)\crypto\dso\dso.h
	$(CP) $(SRC_D)\crypto\dso\dso.h $(INCO_D)\dso.h

$(INCO_D)\dh.h: $(SRC_D)\crypto\dh\dh.h
	$(CP) $(SRC_D)\crypto\dh\dh.h $(INCO_D)\dh.h

$(INCO_D)\ec.h: $(SRC_D)\crypto\ec\ec.h
	$(CP) $(SRC_D)\crypto\ec\ec.h $(INCO_D)\ec.h

$(INCO_D)\ecdh.h: $(SRC_D)\crypto\ecdh\ecdh.h
	$(CP) $(SRC_D)\crypto\ecdh\ecdh.h $(INCO_D)\ecdh.h

$(INCO_D)\ecdsa.h: $(SRC_D)\crypto\ecdsa\ecdsa.h
	$(CP) $(SRC_D)\crypto\ecdsa\ecdsa.h $(INCO_D)\ecdsa.h

$(INCO_D)\buffer.h: $(SRC_D)\crypto\buffer\buffer.h
	$(CP) $(SRC_D)\crypto\buffer\buffer.h $(INCO_D)\buffer.h

$(INCO_D)\bio.h: $(SRC_D)\crypto\bio\bio.h
	$(CP) $(SRC_D)\crypto\bio\bio.h $(INCO_D)\bio.h

$(INCO_D)\stack.h: $(SRC_D)\crypto\stack\stack.h
	$(CP) $(SRC_D)\crypto\stack\stack.h $(INCO_D)\stack.h

$(INCO_D)\safestack.h: $(SRC_D)\crypto\stack\safestack.h
	$(CP) $(SRC_D)\crypto\stack\safestack.h $(INCO_D)\safestack.h

$(INCO_D)\lhash.h: $(SRC_D)\crypto\lhash\lhash.h
	$(CP) $(SRC_D)\crypto\lhash\lhash.h $(INCO_D)\lhash.h

$(INCO_D)\rand.h: $(SRC_D)\crypto\rand\rand.h
	$(CP) $(SRC_D)\crypto\rand\rand.h $(INCO_D)\rand.h

$(INCO_D)\err.h: $(SRC_D)\crypto\err\err.h
	$(CP) $(SRC_D)\crypto\err\err.h $(INCO_D)\err.h

$(INCO_D)\objects.h: $(SRC_D)\crypto\objects\objects.h
	$(CP) $(SRC_D)\crypto\objects\objects.h $(INCO_D)\objects.h

$(INCO_D)\obj_mac.h: $(SRC_D)\crypto\objects\obj_mac.h
	$(CP) $(SRC_D)\crypto\objects\obj_mac.h $(INCO_D)\obj_mac.h

$(INCO_D)\evp.h: $(SRC_D)\crypto\evp\evp.h
	$(CP) $(SRC_D)\crypto\evp\evp.h $(INCO_D)\evp.h

$(INCO_D)\asn1.h: $(SRC_D)\crypto\asn1\asn1.h
	$(CP) $(SRC_D)\crypto\asn1\asn1.h $(INCO_D)\asn1.h

$(INCO_D)\asn1_mac.h: $(SRC_D)\crypto\asn1\asn1_mac.h
	$(CP) $(SRC_D)\crypto\asn1\asn1_mac.h $(INCO_D)\asn1_mac.h

$(INCO_D)\asn1t.h: $(SRC_D)\crypto\asn1\asn1t.h
	$(CP) $(SRC_D)\crypto\asn1\asn1t.h $(INCO_D)\asn1t.h

$(INCO_D)\pem.h: $(SRC_D)\crypto\pem\pem.h
	$(CP) $(SRC_D)\crypto\pem\pem.h $(INCO_D)\pem.h

$(INCO_D)\pem2.h: $(SRC_D)\crypto\pem\pem2.h
	$(CP) $(SRC_D)\crypto\pem\pem2.h $(INCO_D)\pem2.h

$(INCO_D)\x509.h: $(SRC_D)\crypto\x509\x509.h
	$(CP) $(SRC_D)\crypto\x509\x509.h $(INCO_D)\x509.h

$(INCO_D)\x509_vfy.h: $(SRC_D)\crypto\x509\x509_vfy.h
	$(CP) $(SRC_D)\crypto\x509\x509_vfy.h $(INCO_D)\x509_vfy.h

$(INCO_D)\x509v3.h: $(SRC_D)\crypto\x509v3\x509v3.h
	$(CP) $(SRC_D)\crypto\x509v3\x509v3.h $(INCO_D)\x509v3.h

$(INCO_D)\conf.h: $(SRC_D)\crypto\conf\conf.h
	$(CP) $(SRC_D)\crypto\conf\conf.h $(INCO_D)\conf.h

$(INCO_D)\conf_api.h: $(SRC_D)\crypto\conf\conf_api.h
	$(CP) $(SRC_D)\crypto\conf\conf_api.h $(INCO_D)\conf_api.h

$(INCO_D)\txt_db.h: $(SRC_D)\crypto\txt_db\txt_db.h
	$(CP) $(SRC_D)\crypto\txt_db\txt_db.h $(INCO_D)\txt_db.h

$(INCO_D)\pkcs7.h: $(SRC_D)\crypto\pkcs7\pkcs7.h
	$(CP) $(SRC_D)\crypto\pkcs7\pkcs7.h $(INCO_D)\pkcs7.h

$(INCO_D)\pkcs12.h: $(SRC_D)\crypto\pkcs12\pkcs12.h
	$(CP) $(SRC_D)\crypto\pkcs12\pkcs12.h $(INCO_D)\pkcs12.h

$(INCO_D)\comp.h: $(SRC_D)\crypto\comp\comp.h
	$(CP) $(SRC_D)\crypto\comp\comp.h $(INCO_D)\comp.h

$(INCO_D)\engine.h: $(SRC_D)\crypto\engine\engine.h
	$(CP) $(SRC_D)\crypto\engine\engine.h $(INCO_D)\engine.h

$(INCO_D)\ocsp.h: $(SRC_D)\crypto\ocsp\ocsp.h
	$(CP) $(SRC_D)\crypto\ocsp\ocsp.h $(INCO_D)\ocsp.h

$(INCO_D)\ui.h: $(SRC_D)\crypto\ui\ui.h
	$(CP) $(SRC_D)\crypto\ui\ui.h $(INCO_D)\ui.h

$(INCO_D)\ui_compat.h: $(SRC_D)\crypto\ui\ui_compat.h
	$(CP) $(SRC_D)\crypto\ui\ui_compat.h $(INCO_D)\ui_compat.h

$(INCO_D)\krb5_asn.h: $(SRC_D)\crypto\krb5\krb5_asn.h
	$(CP) $(SRC_D)\crypto\krb5\krb5_asn.h $(INCO_D)\krb5_asn.h

$(INCO_D)\store.h: $(SRC_D)\crypto\store\store.h
	$(CP) $(SRC_D)\crypto\store\store.h $(INCO_D)\store.h

$(INCO_D)\pqueue.h: $(SRC_D)\crypto\pqueue\pqueue.h
	$(CP) $(SRC_D)\crypto\pqueue\pqueue.h $(INCO_D)\pqueue.h

$(INCO_D)\pq_compat.h: $(SRC_D)\crypto\pqueue\pq_compat.h
	$(CP) $(SRC_D)\crypto\pqueue\pq_compat.h $(INCO_D)\pq_compat.h

$(INCO_D)\ssl.h: $(SRC_D)\ssl\ssl.h
	$(CP) $(SRC_D)\ssl\ssl.h $(INCO_D)\ssl.h

$(INCO_D)\ssl2.h: $(SRC_D)\ssl\ssl2.h
	$(CP) $(SRC_D)\ssl\ssl2.h $(INCO_D)\ssl2.h

$(INCO_D)\ssl3.h: $(SRC_D)\ssl\ssl3.h
	$(CP) $(SRC_D)\ssl\ssl3.h $(INCO_D)\ssl3.h

$(INCO_D)\ssl23.h: $(SRC_D)\ssl\ssl23.h
	$(CP) $(SRC_D)\ssl\ssl23.h $(INCO_D)\ssl23.h

$(INCO_D)\tls1.h: $(SRC_D)\ssl\tls1.h
	$(CP) $(SRC_D)\ssl\tls1.h $(INCO_D)\tls1.h

$(INCO_D)\dtls1.h: $(SRC_D)\ssl\dtls1.h
	$(CP) $(SRC_D)\ssl\dtls1.h $(INCO_D)\dtls1.h

$(INCO_D)\kssl.h: $(SRC_D)\ssl\kssl.h
	$(CP) $(SRC_D)\ssl\kssl.h $(INCO_D)\kssl.h

$(OBJ_D)\md2test.o: $(SRC_D)\crypto\md2\md2test.c
	$(CC) -o $(OBJ_D)\md2test.o $(APP_CFLAGS) -c $(SRC_D)\crypto\md2\md2test.c

$(OBJ_D)\md4test.o: $(SRC_D)\crypto\md4\md4test.c
	$(CC) -o $(OBJ_D)\md4test.o $(APP_CFLAGS) -c $(SRC_D)\crypto\md4\md4test.c

$(OBJ_D)\md5test.o: $(SRC_D)\crypto\md5\md5test.c
	$(CC) -o $(OBJ_D)\md5test.o $(APP_CFLAGS) -c $(SRC_D)\crypto\md5\md5test.c

$(OBJ_D)\shatest.o: $(SRC_D)\crypto\sha\shatest.c
	$(CC) -o $(OBJ_D)\shatest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\sha\shatest.c

$(OBJ_D)\sha1test.o: $(SRC_D)\crypto\sha\sha1test.c
	$(CC) -o $(OBJ_D)\sha1test.o $(APP_CFLAGS) -c $(SRC_D)\crypto\sha\sha1test.c

$(OBJ_D)\sha256t.o: $(SRC_D)\crypto\sha\sha256t.c
	$(CC) -o $(OBJ_D)\sha256t.o $(APP_CFLAGS) -c $(SRC_D)\crypto\sha\sha256t.c

$(OBJ_D)\sha512t.o: $(SRC_D)\crypto\sha\sha512t.c
	$(CC) -o $(OBJ_D)\sha512t.o $(APP_CFLAGS) -c $(SRC_D)\crypto\sha\sha512t.c

$(OBJ_D)\hmactest.o: $(SRC_D)\crypto\hmac\hmactest.c
	$(CC) -o $(OBJ_D)\hmactest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\hmac\hmactest.c

$(OBJ_D)\rmdtest.o: $(SRC_D)\crypto\ripemd\rmdtest.c
	$(CC) -o $(OBJ_D)\rmdtest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\ripemd\rmdtest.c

$(OBJ_D)\destest.o: $(SRC_D)\crypto\des\destest.c
	$(CC) -o $(OBJ_D)\destest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\des\destest.c

$(OBJ_D)\rc2test.o: $(SRC_D)\crypto\rc2\rc2test.c
	$(CC) -o $(OBJ_D)\rc2test.o $(APP_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2test.c

$(OBJ_D)\rc4test.o: $(SRC_D)\crypto\rc4\rc4test.c
	$(CC) -o $(OBJ_D)\rc4test.o $(APP_CFLAGS) -c $(SRC_D)\crypto\rc4\rc4test.c

$(OBJ_D)\ideatest.o: $(SRC_D)\crypto\idea\ideatest.c
	$(CC) -o $(OBJ_D)\ideatest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\idea\ideatest.c

$(OBJ_D)\bftest.o: $(SRC_D)\crypto\bf\bftest.c
	$(CC) -o $(OBJ_D)\bftest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\bf\bftest.c

$(OBJ_D)\casttest.o: $(SRC_D)\crypto\cast\casttest.c
	$(CC) -o $(OBJ_D)\casttest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\cast\casttest.c

$(OBJ_D)\bntest.o: $(SRC_D)\crypto\bn\bntest.c
	$(CC) -o $(OBJ_D)\bntest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\bn\bntest.c

$(OBJ_D)\exptest.o: $(SRC_D)\crypto\bn\exptest.c
	$(CC) -o $(OBJ_D)\exptest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\bn\exptest.c

$(OBJ_D)\rsa_test.o: $(SRC_D)\crypto\rsa\rsa_test.c
	$(CC) -o $(OBJ_D)\rsa_test.o $(APP_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_test.c

$(OBJ_D)\dsatest.o: $(SRC_D)\crypto\dsa\dsatest.c
	$(CC) -o $(OBJ_D)\dsatest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\dsa\dsatest.c

$(OBJ_D)\dhtest.o: $(SRC_D)\crypto\dh\dhtest.c
	$(CC) -o $(OBJ_D)\dhtest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\dh\dhtest.c

$(OBJ_D)\ectest.o: $(SRC_D)\crypto\ec\ectest.c
	$(CC) -o $(OBJ_D)\ectest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\ec\ectest.c

$(OBJ_D)\ecdhtest.o: $(SRC_D)\crypto\ecdh\ecdhtest.c
	$(CC) -o $(OBJ_D)\ecdhtest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\ecdh\ecdhtest.c

$(OBJ_D)\ecdsatest.o: $(SRC_D)\crypto\ecdsa\ecdsatest.c
	$(CC) -o $(OBJ_D)\ecdsatest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\ecdsa\ecdsatest.c

$(OBJ_D)\randtest.o: $(SRC_D)\crypto\rand\randtest.c
	$(CC) -o $(OBJ_D)\randtest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\rand\randtest.c

$(OBJ_D)\evp_test.o: $(SRC_D)\crypto\evp\evp_test.c
	$(CC) -o $(OBJ_D)\evp_test.o $(APP_CFLAGS) -c $(SRC_D)\crypto\evp\evp_test.c

$(OBJ_D)\enginetest.o: $(SRC_D)\crypto\engine\enginetest.c
	$(CC) -o $(OBJ_D)\enginetest.o $(APP_CFLAGS) -c $(SRC_D)\crypto\engine\enginetest.c

$(OBJ_D)\ssltest.o: $(SRC_D)\ssl\ssltest.c
	$(CC) -o $(OBJ_D)\ssltest.o $(APP_CFLAGS) -c $(SRC_D)\ssl\ssltest.c

$(OBJ_D)\verify.o: $(SRC_D)\apps\verify.c
	$(CC) -o $(OBJ_D)\verify.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\verify.c

$(OBJ_D)\asn1pars.o: $(SRC_D)\apps\asn1pars.c
	$(CC) -o $(OBJ_D)\asn1pars.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\asn1pars.c

$(OBJ_D)\req.o: $(SRC_D)\apps\req.c
	$(CC) -o $(OBJ_D)\req.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\req.c

$(OBJ_D)\dgst.o: $(SRC_D)\apps\dgst.c
	$(CC) -o $(OBJ_D)\dgst.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\dgst.c

$(OBJ_D)\dh.o: $(SRC_D)\apps\dh.c
	$(CC) -o $(OBJ_D)\dh.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\dh.c

$(OBJ_D)\dhparam.o: $(SRC_D)\apps\dhparam.c
	$(CC) -o $(OBJ_D)\dhparam.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\dhparam.c

$(OBJ_D)\enc.o: $(SRC_D)\apps\enc.c
	$(CC) -o $(OBJ_D)\enc.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\enc.c

$(OBJ_D)\passwd.o: $(SRC_D)\apps\passwd.c
	$(CC) -o $(OBJ_D)\passwd.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\passwd.c

$(OBJ_D)\gendh.o: $(SRC_D)\apps\gendh.c
	$(CC) -o $(OBJ_D)\gendh.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\gendh.c

$(OBJ_D)\errstr.o: $(SRC_D)\apps\errstr.c
	$(CC) -o $(OBJ_D)\errstr.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\errstr.c

$(OBJ_D)\ca.o: $(SRC_D)\apps\ca.c
	$(CC) -o $(OBJ_D)\ca.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\ca.c

$(OBJ_D)\pkcs7.o: $(SRC_D)\apps\pkcs7.c
	$(CC) -o $(OBJ_D)\pkcs7.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\pkcs7.c

$(OBJ_D)\crl2p7.o: $(SRC_D)\apps\crl2p7.c
	$(CC) -o $(OBJ_D)\crl2p7.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\crl2p7.c

$(OBJ_D)\crl.o: $(SRC_D)\apps\crl.c
	$(CC) -o $(OBJ_D)\crl.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\crl.c

$(OBJ_D)\rsa.o: $(SRC_D)\apps\rsa.c
	$(CC) -o $(OBJ_D)\rsa.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\rsa.c

$(OBJ_D)\rsautl.o: $(SRC_D)\apps\rsautl.c
	$(CC) -o $(OBJ_D)\rsautl.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\rsautl.c

$(OBJ_D)\dsa.o: $(SRC_D)\apps\dsa.c
	$(CC) -o $(OBJ_D)\dsa.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\dsa.c

$(OBJ_D)\dsaparam.o: $(SRC_D)\apps\dsaparam.c
	$(CC) -o $(OBJ_D)\dsaparam.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\dsaparam.c

$(OBJ_D)\ec.o: $(SRC_D)\apps\ec.c
	$(CC) -o $(OBJ_D)\ec.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\ec.c

$(OBJ_D)\ecparam.o: $(SRC_D)\apps\ecparam.c
	$(CC) -o $(OBJ_D)\ecparam.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\ecparam.c

$(OBJ_D)\x509.o: $(SRC_D)\apps\x509.c
	$(CC) -o $(OBJ_D)\x509.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\x509.c

$(OBJ_D)\genrsa.o: $(SRC_D)\apps\genrsa.c
	$(CC) -o $(OBJ_D)\genrsa.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\genrsa.c

$(OBJ_D)\gendsa.o: $(SRC_D)\apps\gendsa.c
	$(CC) -o $(OBJ_D)\gendsa.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\gendsa.c

$(OBJ_D)\s_server.o: $(SRC_D)\apps\s_server.c
	$(CC) -o $(OBJ_D)\s_server.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\s_server.c

$(OBJ_D)\s_client.o: $(SRC_D)\apps\s_client.c
	$(CC) -o $(OBJ_D)\s_client.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\s_client.c

$(OBJ_D)\speed.o: $(SRC_D)\apps\speed.c
	$(CC) -o $(OBJ_D)\speed.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\speed.c

$(OBJ_D)\s_time.o: $(SRC_D)\apps\s_time.c
	$(CC) -o $(OBJ_D)\s_time.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\s_time.c

$(OBJ_D)\apps.o: $(SRC_D)\apps\apps.c
	$(CC) -o $(OBJ_D)\apps.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\apps.c

$(OBJ_D)\s_cb.o: $(SRC_D)\apps\s_cb.c
	$(CC) -o $(OBJ_D)\s_cb.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\s_cb.c

$(OBJ_D)\s_socket.o: $(SRC_D)\apps\s_socket.c
	$(CC) -o $(OBJ_D)\s_socket.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\s_socket.c

$(OBJ_D)\app_rand.o: $(SRC_D)\apps\app_rand.c
	$(CC) -o $(OBJ_D)\app_rand.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\app_rand.c

$(OBJ_D)\version.o: $(SRC_D)\apps\version.c
	$(CC) -o $(OBJ_D)\version.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\version.c

$(OBJ_D)\sess_id.o: $(SRC_D)\apps\sess_id.c
	$(CC) -o $(OBJ_D)\sess_id.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\sess_id.c

$(OBJ_D)\ciphers.o: $(SRC_D)\apps\ciphers.c
	$(CC) -o $(OBJ_D)\ciphers.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\ciphers.c

$(OBJ_D)\nseq.o: $(SRC_D)\apps\nseq.c
	$(CC) -o $(OBJ_D)\nseq.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\nseq.c

$(OBJ_D)\pkcs12.o: $(SRC_D)\apps\pkcs12.c
	$(CC) -o $(OBJ_D)\pkcs12.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\pkcs12.c

$(OBJ_D)\pkcs8.o: $(SRC_D)\apps\pkcs8.c
	$(CC) -o $(OBJ_D)\pkcs8.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\pkcs8.c

$(OBJ_D)\spkac.o: $(SRC_D)\apps\spkac.c
	$(CC) -o $(OBJ_D)\spkac.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\spkac.c

$(OBJ_D)\smime.o: $(SRC_D)\apps\smime.c
	$(CC) -o $(OBJ_D)\smime.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\smime.c

$(OBJ_D)\rand.o: $(SRC_D)\apps\rand.c
	$(CC) -o $(OBJ_D)\rand.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\rand.c

$(OBJ_D)\engine.o: $(SRC_D)\apps\engine.c
	$(CC) -o $(OBJ_D)\engine.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\engine.c

$(OBJ_D)\ocsp.o: $(SRC_D)\apps\ocsp.c
	$(CC) -o $(OBJ_D)\ocsp.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\ocsp.c

$(OBJ_D)\prime.o: $(SRC_D)\apps\prime.c
	$(CC) -o $(OBJ_D)\prime.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\prime.c

$(OBJ_D)\openssl.o: $(SRC_D)\apps\openssl.c
	$(CC) -o $(OBJ_D)\openssl.o -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\openssl.c

$(OBJ_D)\s2_meth.o: $(SRC_D)\ssl\s2_meth.c
	$(CC) -o $(OBJ_D)\s2_meth.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s2_meth.c

$(OBJ_D)\s2_srvr.o: $(SRC_D)\ssl\s2_srvr.c
	$(CC) -o $(OBJ_D)\s2_srvr.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s2_srvr.c

$(OBJ_D)\s2_clnt.o: $(SRC_D)\ssl\s2_clnt.c
	$(CC) -o $(OBJ_D)\s2_clnt.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s2_clnt.c

$(OBJ_D)\s2_lib.o: $(SRC_D)\ssl\s2_lib.c
	$(CC) -o $(OBJ_D)\s2_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s2_lib.c

$(OBJ_D)\s2_enc.o: $(SRC_D)\ssl\s2_enc.c
	$(CC) -o $(OBJ_D)\s2_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s2_enc.c

$(OBJ_D)\s2_pkt.o: $(SRC_D)\ssl\s2_pkt.c
	$(CC) -o $(OBJ_D)\s2_pkt.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s2_pkt.c

$(OBJ_D)\s3_meth.o: $(SRC_D)\ssl\s3_meth.c
	$(CC) -o $(OBJ_D)\s3_meth.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s3_meth.c

$(OBJ_D)\s3_srvr.o: $(SRC_D)\ssl\s3_srvr.c
	$(CC) -o $(OBJ_D)\s3_srvr.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s3_srvr.c

$(OBJ_D)\s3_clnt.o: $(SRC_D)\ssl\s3_clnt.c
	$(CC) -o $(OBJ_D)\s3_clnt.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s3_clnt.c

$(OBJ_D)\s3_lib.o: $(SRC_D)\ssl\s3_lib.c
	$(CC) -o $(OBJ_D)\s3_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s3_lib.c

$(OBJ_D)\s3_enc.o: $(SRC_D)\ssl\s3_enc.c
	$(CC) -o $(OBJ_D)\s3_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s3_enc.c

$(OBJ_D)\s3_pkt.o: $(SRC_D)\ssl\s3_pkt.c
	$(CC) -o $(OBJ_D)\s3_pkt.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s3_pkt.c

$(OBJ_D)\s3_both.o: $(SRC_D)\ssl\s3_both.c
	$(CC) -o $(OBJ_D)\s3_both.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s3_both.c

$(OBJ_D)\s23_meth.o: $(SRC_D)\ssl\s23_meth.c
	$(CC) -o $(OBJ_D)\s23_meth.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s23_meth.c

$(OBJ_D)\s23_srvr.o: $(SRC_D)\ssl\s23_srvr.c
	$(CC) -o $(OBJ_D)\s23_srvr.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s23_srvr.c

$(OBJ_D)\s23_clnt.o: $(SRC_D)\ssl\s23_clnt.c
	$(CC) -o $(OBJ_D)\s23_clnt.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s23_clnt.c

$(OBJ_D)\s23_lib.o: $(SRC_D)\ssl\s23_lib.c
	$(CC) -o $(OBJ_D)\s23_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s23_lib.c

$(OBJ_D)\s23_pkt.o: $(SRC_D)\ssl\s23_pkt.c
	$(CC) -o $(OBJ_D)\s23_pkt.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\s23_pkt.c

$(OBJ_D)\t1_meth.o: $(SRC_D)\ssl\t1_meth.c
	$(CC) -o $(OBJ_D)\t1_meth.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\t1_meth.c

$(OBJ_D)\t1_srvr.o: $(SRC_D)\ssl\t1_srvr.c
	$(CC) -o $(OBJ_D)\t1_srvr.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\t1_srvr.c

$(OBJ_D)\t1_clnt.o: $(SRC_D)\ssl\t1_clnt.c
	$(CC) -o $(OBJ_D)\t1_clnt.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\t1_clnt.c

$(OBJ_D)\t1_lib.o: $(SRC_D)\ssl\t1_lib.c
	$(CC) -o $(OBJ_D)\t1_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\t1_lib.c

$(OBJ_D)\t1_enc.o: $(SRC_D)\ssl\t1_enc.c
	$(CC) -o $(OBJ_D)\t1_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\t1_enc.c

$(OBJ_D)\d1_meth.o: $(SRC_D)\ssl\d1_meth.c
	$(CC) -o $(OBJ_D)\d1_meth.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\d1_meth.c

$(OBJ_D)\d1_srvr.o: $(SRC_D)\ssl\d1_srvr.c
	$(CC) -o $(OBJ_D)\d1_srvr.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\d1_srvr.c

$(OBJ_D)\d1_clnt.o: $(SRC_D)\ssl\d1_clnt.c
	$(CC) -o $(OBJ_D)\d1_clnt.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\d1_clnt.c

$(OBJ_D)\d1_lib.o: $(SRC_D)\ssl\d1_lib.c
	$(CC) -o $(OBJ_D)\d1_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\d1_lib.c

$(OBJ_D)\d1_pkt.o: $(SRC_D)\ssl\d1_pkt.c
	$(CC) -o $(OBJ_D)\d1_pkt.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\d1_pkt.c

$(OBJ_D)\d1_both.o: $(SRC_D)\ssl\d1_both.c
	$(CC) -o $(OBJ_D)\d1_both.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\d1_both.c

$(OBJ_D)\d1_enc.o: $(SRC_D)\ssl\d1_enc.c
	$(CC) -o $(OBJ_D)\d1_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\d1_enc.c

$(OBJ_D)\ssl_lib.o: $(SRC_D)\ssl\ssl_lib.c
	$(CC) -o $(OBJ_D)\ssl_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_lib.c

$(OBJ_D)\ssl_err2.o: $(SRC_D)\ssl\ssl_err2.c
	$(CC) -o $(OBJ_D)\ssl_err2.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_err2.c

$(OBJ_D)\ssl_cert.o: $(SRC_D)\ssl\ssl_cert.c
	$(CC) -o $(OBJ_D)\ssl_cert.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_cert.c

$(OBJ_D)\ssl_sess.o: $(SRC_D)\ssl\ssl_sess.c
	$(CC) -o $(OBJ_D)\ssl_sess.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_sess.c

$(OBJ_D)\ssl_ciph.o: $(SRC_D)\ssl\ssl_ciph.c
	$(CC) -o $(OBJ_D)\ssl_ciph.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_ciph.c

$(OBJ_D)\ssl_stat.o: $(SRC_D)\ssl\ssl_stat.c
	$(CC) -o $(OBJ_D)\ssl_stat.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_stat.c

$(OBJ_D)\ssl_rsa.o: $(SRC_D)\ssl\ssl_rsa.c
	$(CC) -o $(OBJ_D)\ssl_rsa.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_rsa.c

$(OBJ_D)\ssl_asn1.o: $(SRC_D)\ssl\ssl_asn1.c
	$(CC) -o $(OBJ_D)\ssl_asn1.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_asn1.c

$(OBJ_D)\ssl_txt.o: $(SRC_D)\ssl\ssl_txt.c
	$(CC) -o $(OBJ_D)\ssl_txt.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_txt.c

$(OBJ_D)\ssl_algs.o: $(SRC_D)\ssl\ssl_algs.c
	$(CC) -o $(OBJ_D)\ssl_algs.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_algs.c

$(OBJ_D)\bio_ssl.o: $(SRC_D)\ssl\bio_ssl.c
	$(CC) -o $(OBJ_D)\bio_ssl.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\bio_ssl.c

$(OBJ_D)\ssl_err.o: $(SRC_D)\ssl\ssl_err.c
	$(CC) -o $(OBJ_D)\ssl_err.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_err.c

$(OBJ_D)\kssl.o: $(SRC_D)\ssl\kssl.c
	$(CC) -o $(OBJ_D)\kssl.o  $(LIB_CFLAGS) -c $(SRC_D)\ssl\kssl.c

$(OBJ_D)\bn-win32.o: crypto\bn\asm\bn-win32.s
	$(ASM) -o $(OBJ_D)\bn-win32.o $(SRC_D)\crypto\bn\asm\bn-win32.s

$(OBJ_D)\co-win32.o: crypto\bn\asm\co-win32.s
	$(ASM) -o $(OBJ_D)\co-win32.o $(SRC_D)\crypto\bn\asm\co-win32.s

$(OBJ_D)\d-win32.o: crypto\des\asm\d-win32.s
	$(ASM) -o $(OBJ_D)\d-win32.o $(SRC_D)\crypto\des\asm\d-win32.s

$(OBJ_D)\y-win32.o: crypto\des\asm\y-win32.s
	$(ASM) -o $(OBJ_D)\y-win32.o $(SRC_D)\crypto\des\asm\y-win32.s

$(OBJ_D)\b-win32.o: crypto\bf\asm\b-win32.s
	$(ASM) -o $(OBJ_D)\b-win32.o $(SRC_D)\crypto\bf\asm\b-win32.s

$(OBJ_D)\r4-win32.o: crypto\rc4\asm\r4-win32.s
	$(ASM) -o $(OBJ_D)\r4-win32.o $(SRC_D)\crypto\rc4\asm\r4-win32.s

$(OBJ_D)\r5-win32.o: crypto\rc5\asm\r5-win32.s
	$(ASM) -o $(OBJ_D)\r5-win32.o $(SRC_D)\crypto\rc5\asm\r5-win32.s

$(OBJ_D)\m5-win32.o: crypto\md5\asm\m5-win32.s
	$(ASM) -o $(OBJ_D)\m5-win32.o $(SRC_D)\crypto\md5\asm\m5-win32.s

$(OBJ_D)\s1-win32.o: crypto\sha\asm\s1-win32.s
	$(ASM) -o $(OBJ_D)\s1-win32.o $(SRC_D)\crypto\sha\asm\s1-win32.s

$(OBJ_D)\rm-win32.o: crypto\ripemd\asm\rm-win32.s
	$(ASM) -o $(OBJ_D)\rm-win32.o $(SRC_D)\crypto\ripemd\asm\rm-win32.s

$(OBJ_D)\cpu-win32.o: crypto\cpu-win32.s
	$(ASM) -o $(OBJ_D)\cpu-win32.o $(SRC_D)\crypto\cpu-win32.s

$(OBJ_D)\cryptlib.o: $(SRC_D)\crypto\cryptlib.c
	$(CC) -o $(OBJ_D)\cryptlib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\cryptlib.c

$(OBJ_D)\mem.o: $(SRC_D)\crypto\mem.c
	$(CC) -o $(OBJ_D)\mem.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\mem.c

$(OBJ_D)\mem_clr.o: $(SRC_D)\crypto\mem_clr.c
	$(CC) -o $(OBJ_D)\mem_clr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\mem_clr.c

$(OBJ_D)\mem_dbg.o: $(SRC_D)\crypto\mem_dbg.c
	$(CC) -o $(OBJ_D)\mem_dbg.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\mem_dbg.c

$(OBJ_D)\cversion.o: $(SRC_D)\crypto\cversion.c
	$(CC) -o $(OBJ_D)\cversion.o  $(LIB_CFLAGS) -DMK1MF_BUILD -DMK1MF_PLATFORM_Mingw32 -c $(SRC_D)\crypto\cversion.c

$(OBJ_D)\ex_data.o: $(SRC_D)\crypto\ex_data.c
	$(CC) -o $(OBJ_D)\ex_data.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ex_data.c

$(OBJ_D)\tmdiff.o: $(SRC_D)\crypto\tmdiff.c
	$(CC) -o $(OBJ_D)\tmdiff.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\tmdiff.c

$(OBJ_D)\cpt_err.o: $(SRC_D)\crypto\cpt_err.c
	$(CC) -o $(OBJ_D)\cpt_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\cpt_err.c

$(OBJ_D)\ebcdic.o: $(SRC_D)\crypto\ebcdic.c
	$(CC) -o $(OBJ_D)\ebcdic.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ebcdic.c

$(OBJ_D)\uid.o: $(SRC_D)\crypto\uid.c
	$(CC) -o $(OBJ_D)\uid.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\uid.c

$(OBJ_D)\o_time.o: $(SRC_D)\crypto\o_time.c
	$(CC) -o $(OBJ_D)\o_time.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\o_time.c

$(OBJ_D)\o_str.o: $(SRC_D)\crypto\o_str.c
	$(CC) -o $(OBJ_D)\o_str.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\o_str.c

$(OBJ_D)\o_dir.o: $(SRC_D)\crypto\o_dir.c
	$(CC) -o $(OBJ_D)\o_dir.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\o_dir.c

$(OBJ_D)\md2_dgst.o: $(SRC_D)\crypto\md2\md2_dgst.c
	$(CC) -o $(OBJ_D)\md2_dgst.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\md2\md2_dgst.c

$(OBJ_D)\md2_one.o: $(SRC_D)\crypto\md2\md2_one.c
	$(CC) -o $(OBJ_D)\md2_one.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\md2\md2_one.c

$(OBJ_D)\md4_dgst.o: $(SRC_D)\crypto\md4\md4_dgst.c
	$(CC) -o $(OBJ_D)\md4_dgst.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\md4\md4_dgst.c

$(OBJ_D)\md4_one.o: $(SRC_D)\crypto\md4\md4_one.c
	$(CC) -o $(OBJ_D)\md4_one.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\md4\md4_one.c

$(OBJ_D)\md5_dgst.o: $(SRC_D)\crypto\md5\md5_dgst.c
	$(CC) -o $(OBJ_D)\md5_dgst.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\md5\md5_dgst.c

$(OBJ_D)\md5_one.o: $(SRC_D)\crypto\md5\md5_one.c
	$(CC) -o $(OBJ_D)\md5_one.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\md5\md5_one.c

$(OBJ_D)\sha_dgst.o: $(SRC_D)\crypto\sha\sha_dgst.c
	$(CC) -o $(OBJ_D)\sha_dgst.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha_dgst.c

$(OBJ_D)\sha1dgst.o: $(SRC_D)\crypto\sha\sha1dgst.c
	$(CC) -o $(OBJ_D)\sha1dgst.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha1dgst.c

$(OBJ_D)\sha_one.o: $(SRC_D)\crypto\sha\sha_one.c
	$(CC) -o $(OBJ_D)\sha_one.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha_one.c

$(OBJ_D)\sha1_one.o: $(SRC_D)\crypto\sha\sha1_one.c
	$(CC) -o $(OBJ_D)\sha1_one.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha1_one.c

$(OBJ_D)\sha256.o: $(SRC_D)\crypto\sha\sha256.c
	$(CC) -o $(OBJ_D)\sha256.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha256.c

$(OBJ_D)\sha512.o: $(SRC_D)\crypto\sha\sha512.c
	$(CC) -o $(OBJ_D)\sha512.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha512.c

$(OBJ_D)\hmac.o: $(SRC_D)\crypto\hmac\hmac.c
	$(CC) -o $(OBJ_D)\hmac.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\hmac\hmac.c

$(OBJ_D)\rmd_dgst.o: $(SRC_D)\crypto\ripemd\rmd_dgst.c
	$(CC) -o $(OBJ_D)\rmd_dgst.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ripemd\rmd_dgst.c

$(OBJ_D)\rmd_one.o: $(SRC_D)\crypto\ripemd\rmd_one.c
	$(CC) -o $(OBJ_D)\rmd_one.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ripemd\rmd_one.c

$(OBJ_D)\set_key.o: $(SRC_D)\crypto\des\set_key.c
	$(CC) -o $(OBJ_D)\set_key.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\set_key.c

$(OBJ_D)\ecb_enc.o: $(SRC_D)\crypto\des\ecb_enc.c
	$(CC) -o $(OBJ_D)\ecb_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ecb_enc.c

$(OBJ_D)\cbc_enc.o: $(SRC_D)\crypto\des\cbc_enc.c
	$(CC) -o $(OBJ_D)\cbc_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\cbc_enc.c

$(OBJ_D)\ecb3_enc.o: $(SRC_D)\crypto\des\ecb3_enc.c
	$(CC) -o $(OBJ_D)\ecb3_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ecb3_enc.c

$(OBJ_D)\cfb64enc.o: $(SRC_D)\crypto\des\cfb64enc.c
	$(CC) -o $(OBJ_D)\cfb64enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\cfb64enc.c

$(OBJ_D)\cfb64ede.o: $(SRC_D)\crypto\des\cfb64ede.c
	$(CC) -o $(OBJ_D)\cfb64ede.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\cfb64ede.c

$(OBJ_D)\cfb_enc.o: $(SRC_D)\crypto\des\cfb_enc.c
	$(CC) -o $(OBJ_D)\cfb_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\cfb_enc.c

$(OBJ_D)\ofb64ede.o: $(SRC_D)\crypto\des\ofb64ede.c
	$(CC) -o $(OBJ_D)\ofb64ede.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ofb64ede.c

$(OBJ_D)\enc_read.o: $(SRC_D)\crypto\des\enc_read.c
	$(CC) -o $(OBJ_D)\enc_read.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\enc_read.c

$(OBJ_D)\enc_writ.o: $(SRC_D)\crypto\des\enc_writ.c
	$(CC) -o $(OBJ_D)\enc_writ.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\enc_writ.c

$(OBJ_D)\ofb64enc.o: $(SRC_D)\crypto\des\ofb64enc.c
	$(CC) -o $(OBJ_D)\ofb64enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ofb64enc.c

$(OBJ_D)\ofb_enc.o: $(SRC_D)\crypto\des\ofb_enc.c
	$(CC) -o $(OBJ_D)\ofb_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ofb_enc.c

$(OBJ_D)\str2key.o: $(SRC_D)\crypto\des\str2key.c
	$(CC) -o $(OBJ_D)\str2key.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\str2key.c

$(OBJ_D)\pcbc_enc.o: $(SRC_D)\crypto\des\pcbc_enc.c
	$(CC) -o $(OBJ_D)\pcbc_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\pcbc_enc.c

$(OBJ_D)\qud_cksm.o: $(SRC_D)\crypto\des\qud_cksm.c
	$(CC) -o $(OBJ_D)\qud_cksm.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\qud_cksm.c

$(OBJ_D)\rand_key.o: $(SRC_D)\crypto\des\rand_key.c
	$(CC) -o $(OBJ_D)\rand_key.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\rand_key.c

$(OBJ_D)\des_enc.o: $(SRC_D)\crypto\des\des_enc.c
	$(CC) -o $(OBJ_D)\des_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\des_enc.c

$(OBJ_D)\fcrypt_b.o: $(SRC_D)\crypto\des\fcrypt_b.c
	$(CC) -o $(OBJ_D)\fcrypt_b.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\fcrypt_b.c

$(OBJ_D)\fcrypt.o: $(SRC_D)\crypto\des\fcrypt.c
	$(CC) -o $(OBJ_D)\fcrypt.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\fcrypt.c

$(OBJ_D)\xcbc_enc.o: $(SRC_D)\crypto\des\xcbc_enc.c
	$(CC) -o $(OBJ_D)\xcbc_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\xcbc_enc.c

$(OBJ_D)\rpc_enc.o: $(SRC_D)\crypto\des\rpc_enc.c
	$(CC) -o $(OBJ_D)\rpc_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\rpc_enc.c

$(OBJ_D)\cbc_cksm.o: $(SRC_D)\crypto\des\cbc_cksm.c
	$(CC) -o $(OBJ_D)\cbc_cksm.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\cbc_cksm.c

$(OBJ_D)\ede_cbcm_enc.o: $(SRC_D)\crypto\des\ede_cbcm_enc.c
	$(CC) -o $(OBJ_D)\ede_cbcm_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ede_cbcm_enc.c

$(OBJ_D)\des_old.o: $(SRC_D)\crypto\des\des_old.c
	$(CC) -o $(OBJ_D)\des_old.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\des_old.c

$(OBJ_D)\des_old2.o: $(SRC_D)\crypto\des\des_old2.c
	$(CC) -o $(OBJ_D)\des_old2.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\des_old2.c

$(OBJ_D)\read2pwd.o: $(SRC_D)\crypto\des\read2pwd.c
	$(CC) -o $(OBJ_D)\read2pwd.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\read2pwd.c

$(OBJ_D)\rc2_ecb.o: $(SRC_D)\crypto\rc2\rc2_ecb.c
	$(CC) -o $(OBJ_D)\rc2_ecb.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2_ecb.c

$(OBJ_D)\rc2_skey.o: $(SRC_D)\crypto\rc2\rc2_skey.c
	$(CC) -o $(OBJ_D)\rc2_skey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2_skey.c

$(OBJ_D)\rc2_cbc.o: $(SRC_D)\crypto\rc2\rc2_cbc.c
	$(CC) -o $(OBJ_D)\rc2_cbc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2_cbc.c

$(OBJ_D)\rc2cfb64.o: $(SRC_D)\crypto\rc2\rc2cfb64.c
	$(CC) -o $(OBJ_D)\rc2cfb64.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2cfb64.c

$(OBJ_D)\rc2ofb64.o: $(SRC_D)\crypto\rc2\rc2ofb64.c
	$(CC) -o $(OBJ_D)\rc2ofb64.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2ofb64.c

$(OBJ_D)\rc4_skey.o: $(SRC_D)\crypto\rc4\rc4_skey.c
	$(CC) -o $(OBJ_D)\rc4_skey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc4\rc4_skey.c

$(OBJ_D)\rc4_enc.o: $(SRC_D)\crypto\rc4\rc4_enc.c
	$(CC) -o $(OBJ_D)\rc4_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc4\rc4_enc.c

$(OBJ_D)\i_cbc.o: $(SRC_D)\crypto\idea\i_cbc.c
	$(CC) -o $(OBJ_D)\i_cbc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_cbc.c

$(OBJ_D)\i_cfb64.o: $(SRC_D)\crypto\idea\i_cfb64.c
	$(CC) -o $(OBJ_D)\i_cfb64.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_cfb64.c

$(OBJ_D)\i_ofb64.o: $(SRC_D)\crypto\idea\i_ofb64.c
	$(CC) -o $(OBJ_D)\i_ofb64.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_ofb64.c

$(OBJ_D)\i_ecb.o: $(SRC_D)\crypto\idea\i_ecb.c
	$(CC) -o $(OBJ_D)\i_ecb.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_ecb.c

$(OBJ_D)\i_skey.o: $(SRC_D)\crypto\idea\i_skey.c
	$(CC) -o $(OBJ_D)\i_skey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_skey.c

$(OBJ_D)\bf_skey.o: $(SRC_D)\crypto\bf\bf_skey.c
	$(CC) -o $(OBJ_D)\bf_skey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bf\bf_skey.c

$(OBJ_D)\bf_ecb.o: $(SRC_D)\crypto\bf\bf_ecb.c
	$(CC) -o $(OBJ_D)\bf_ecb.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bf\bf_ecb.c

$(OBJ_D)\bf_enc.o: $(SRC_D)\crypto\bf\bf_enc.c
	$(CC) -o $(OBJ_D)\bf_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bf\bf_enc.c

$(OBJ_D)\bf_cfb64.o: $(SRC_D)\crypto\bf\bf_cfb64.c
	$(CC) -o $(OBJ_D)\bf_cfb64.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bf\bf_cfb64.c

$(OBJ_D)\bf_ofb64.o: $(SRC_D)\crypto\bf\bf_ofb64.c
	$(CC) -o $(OBJ_D)\bf_ofb64.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bf\bf_ofb64.c

$(OBJ_D)\c_skey.o: $(SRC_D)\crypto\cast\c_skey.c
	$(CC) -o $(OBJ_D)\c_skey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\cast\c_skey.c

$(OBJ_D)\c_ecb.o: $(SRC_D)\crypto\cast\c_ecb.c
	$(CC) -o $(OBJ_D)\c_ecb.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\cast\c_ecb.c

$(OBJ_D)\c_enc.o: $(SRC_D)\crypto\cast\c_enc.c
	$(CC) -o $(OBJ_D)\c_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\cast\c_enc.c

$(OBJ_D)\c_cfb64.o: $(SRC_D)\crypto\cast\c_cfb64.c
	$(CC) -o $(OBJ_D)\c_cfb64.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\cast\c_cfb64.c

$(OBJ_D)\c_ofb64.o: $(SRC_D)\crypto\cast\c_ofb64.c
	$(CC) -o $(OBJ_D)\c_ofb64.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\cast\c_ofb64.c

$(OBJ_D)\aes_misc.o: $(SRC_D)\crypto\aes\aes_misc.c
	$(CC) -o $(OBJ_D)\aes_misc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\aes\aes_misc.c

$(OBJ_D)\aes_ecb.o: $(SRC_D)\crypto\aes\aes_ecb.c
	$(CC) -o $(OBJ_D)\aes_ecb.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\aes\aes_ecb.c

$(OBJ_D)\aes_cfb.o: $(SRC_D)\crypto\aes\aes_cfb.c
	$(CC) -o $(OBJ_D)\aes_cfb.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\aes\aes_cfb.c

$(OBJ_D)\aes_ofb.o: $(SRC_D)\crypto\aes\aes_ofb.c
	$(CC) -o $(OBJ_D)\aes_ofb.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\aes\aes_ofb.c

$(OBJ_D)\aes_ctr.o: $(SRC_D)\crypto\aes\aes_ctr.c
	$(CC) -o $(OBJ_D)\aes_ctr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\aes\aes_ctr.c

$(OBJ_D)\aes_ige.o: $(SRC_D)\crypto\aes\aes_ige.c
	$(CC) -o $(OBJ_D)\aes_ige.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\aes\aes_ige.c

$(OBJ_D)\aes_core.o: $(SRC_D)\crypto\aes\aes_core.c
	$(CC) -o $(OBJ_D)\aes_core.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\aes\aes_core.c

$(OBJ_D)\aes_cbc.o: $(SRC_D)\crypto\aes\aes_cbc.c
	$(CC) -o $(OBJ_D)\aes_cbc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\aes\aes_cbc.c

$(OBJ_D)\bn_add.o: $(SRC_D)\crypto\bn\bn_add.c
	$(CC) -o $(OBJ_D)\bn_add.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_add.c

$(OBJ_D)\bn_div.o: $(SRC_D)\crypto\bn\bn_div.c
	$(CC) -o $(OBJ_D)\bn_div.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_div.c

$(OBJ_D)\bn_exp.o: $(SRC_D)\crypto\bn\bn_exp.c
	$(CC) -o $(OBJ_D)\bn_exp.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_exp.c

$(OBJ_D)\bn_lib.o: $(SRC_D)\crypto\bn\bn_lib.c
	$(CC) -o $(OBJ_D)\bn_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_lib.c

$(OBJ_D)\bn_ctx.o: $(SRC_D)\crypto\bn\bn_ctx.c
	$(CC) -o $(OBJ_D)\bn_ctx.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_ctx.c

$(OBJ_D)\bn_mul.o: $(SRC_D)\crypto\bn\bn_mul.c
	$(CC) -o $(OBJ_D)\bn_mul.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_mul.c

$(OBJ_D)\bn_mod.o: $(SRC_D)\crypto\bn\bn_mod.c
	$(CC) -o $(OBJ_D)\bn_mod.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_mod.c

$(OBJ_D)\bn_print.o: $(SRC_D)\crypto\bn\bn_print.c
	$(CC) -o $(OBJ_D)\bn_print.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_print.c

$(OBJ_D)\bn_rand.o: $(SRC_D)\crypto\bn\bn_rand.c
	$(CC) -o $(OBJ_D)\bn_rand.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_rand.c

$(OBJ_D)\bn_shift.o: $(SRC_D)\crypto\bn\bn_shift.c
	$(CC) -o $(OBJ_D)\bn_shift.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_shift.c

$(OBJ_D)\bn_word.o: $(SRC_D)\crypto\bn\bn_word.c
	$(CC) -o $(OBJ_D)\bn_word.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_word.c

$(OBJ_D)\bn_blind.o: $(SRC_D)\crypto\bn\bn_blind.c
	$(CC) -o $(OBJ_D)\bn_blind.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_blind.c

$(OBJ_D)\bn_kron.o: $(SRC_D)\crypto\bn\bn_kron.c
	$(CC) -o $(OBJ_D)\bn_kron.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_kron.c

$(OBJ_D)\bn_sqrt.o: $(SRC_D)\crypto\bn\bn_sqrt.c
	$(CC) -o $(OBJ_D)\bn_sqrt.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_sqrt.c

$(OBJ_D)\bn_gcd.o: $(SRC_D)\crypto\bn\bn_gcd.c
	$(CC) -o $(OBJ_D)\bn_gcd.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_gcd.c

$(OBJ_D)\bn_prime.o: $(SRC_D)\crypto\bn\bn_prime.c
	$(CC) -o $(OBJ_D)\bn_prime.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_prime.c

$(OBJ_D)\bn_err.o: $(SRC_D)\crypto\bn\bn_err.c
	$(CC) -o $(OBJ_D)\bn_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_err.c

$(OBJ_D)\bn_sqr.o: $(SRC_D)\crypto\bn\bn_sqr.c
	$(CC) -o $(OBJ_D)\bn_sqr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_sqr.c

$(OBJ_D)\bn_asm.o: $(SRC_D)\crypto\bn\bn_asm.c
	$(CC) -o $(OBJ_D)\bn_asm.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_asm.c

$(OBJ_D)\bn_recp.o: $(SRC_D)\crypto\bn\bn_recp.c
	$(CC) -o $(OBJ_D)\bn_recp.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_recp.c

$(OBJ_D)\bn_mont.o: $(SRC_D)\crypto\bn\bn_mont.c
	$(CC) -o $(OBJ_D)\bn_mont.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_mont.c

$(OBJ_D)\bn_mpi.o: $(SRC_D)\crypto\bn\bn_mpi.c
	$(CC) -o $(OBJ_D)\bn_mpi.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_mpi.c

$(OBJ_D)\bn_exp2.o: $(SRC_D)\crypto\bn\bn_exp2.c
	$(CC) -o $(OBJ_D)\bn_exp2.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_exp2.c

$(OBJ_D)\bn_gf2m.o: $(SRC_D)\crypto\bn\bn_gf2m.c
	$(CC) -o $(OBJ_D)\bn_gf2m.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_gf2m.c

$(OBJ_D)\bn_nist.o: $(SRC_D)\crypto\bn\bn_nist.c
	$(CC) -o $(OBJ_D)\bn_nist.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_nist.c

$(OBJ_D)\bn_depr.o: $(SRC_D)\crypto\bn\bn_depr.c
	$(CC) -o $(OBJ_D)\bn_depr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_depr.c

$(OBJ_D)\bn_const.o: $(SRC_D)\crypto\bn\bn_const.c
	$(CC) -o $(OBJ_D)\bn_const.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_const.c

$(OBJ_D)\rsa_eay.o: $(SRC_D)\crypto\rsa\rsa_eay.c
	$(CC) -o $(OBJ_D)\rsa_eay.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_eay.c

$(OBJ_D)\rsa_gen.o: $(SRC_D)\crypto\rsa\rsa_gen.c
	$(CC) -o $(OBJ_D)\rsa_gen.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_gen.c

$(OBJ_D)\rsa_lib.o: $(SRC_D)\crypto\rsa\rsa_lib.c
	$(CC) -o $(OBJ_D)\rsa_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_lib.c

$(OBJ_D)\rsa_sign.o: $(SRC_D)\crypto\rsa\rsa_sign.c
	$(CC) -o $(OBJ_D)\rsa_sign.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_sign.c

$(OBJ_D)\rsa_saos.o: $(SRC_D)\crypto\rsa\rsa_saos.c
	$(CC) -o $(OBJ_D)\rsa_saos.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_saos.c

$(OBJ_D)\rsa_err.o: $(SRC_D)\crypto\rsa\rsa_err.c
	$(CC) -o $(OBJ_D)\rsa_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_err.c

$(OBJ_D)\rsa_pk1.o: $(SRC_D)\crypto\rsa\rsa_pk1.c
	$(CC) -o $(OBJ_D)\rsa_pk1.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_pk1.c

$(OBJ_D)\rsa_ssl.o: $(SRC_D)\crypto\rsa\rsa_ssl.c
	$(CC) -o $(OBJ_D)\rsa_ssl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_ssl.c

$(OBJ_D)\rsa_none.o: $(SRC_D)\crypto\rsa\rsa_none.c
	$(CC) -o $(OBJ_D)\rsa_none.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_none.c

$(OBJ_D)\rsa_oaep.o: $(SRC_D)\crypto\rsa\rsa_oaep.c
	$(CC) -o $(OBJ_D)\rsa_oaep.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_oaep.c

$(OBJ_D)\rsa_chk.o: $(SRC_D)\crypto\rsa\rsa_chk.c
	$(CC) -o $(OBJ_D)\rsa_chk.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_chk.c

$(OBJ_D)\rsa_null.o: $(SRC_D)\crypto\rsa\rsa_null.c
	$(CC) -o $(OBJ_D)\rsa_null.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_null.c

$(OBJ_D)\rsa_pss.o: $(SRC_D)\crypto\rsa\rsa_pss.c
	$(CC) -o $(OBJ_D)\rsa_pss.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_pss.c

$(OBJ_D)\rsa_x931.o: $(SRC_D)\crypto\rsa\rsa_x931.c
	$(CC) -o $(OBJ_D)\rsa_x931.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_x931.c

$(OBJ_D)\rsa_asn1.o: $(SRC_D)\crypto\rsa\rsa_asn1.c
	$(CC) -o $(OBJ_D)\rsa_asn1.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_asn1.c

$(OBJ_D)\rsa_depr.o: $(SRC_D)\crypto\rsa\rsa_depr.c
	$(CC) -o $(OBJ_D)\rsa_depr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_depr.c

$(OBJ_D)\dsa_gen.o: $(SRC_D)\crypto\dsa\dsa_gen.c
	$(CC) -o $(OBJ_D)\dsa_gen.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_gen.c

$(OBJ_D)\dsa_key.o: $(SRC_D)\crypto\dsa\dsa_key.c
	$(CC) -o $(OBJ_D)\dsa_key.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_key.c

$(OBJ_D)\dsa_lib.o: $(SRC_D)\crypto\dsa\dsa_lib.c
	$(CC) -o $(OBJ_D)\dsa_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_lib.c

$(OBJ_D)\dsa_asn1.o: $(SRC_D)\crypto\dsa\dsa_asn1.c
	$(CC) -o $(OBJ_D)\dsa_asn1.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_asn1.c

$(OBJ_D)\dsa_vrf.o: $(SRC_D)\crypto\dsa\dsa_vrf.c
	$(CC) -o $(OBJ_D)\dsa_vrf.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_vrf.c

$(OBJ_D)\dsa_sign.o: $(SRC_D)\crypto\dsa\dsa_sign.c
	$(CC) -o $(OBJ_D)\dsa_sign.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_sign.c

$(OBJ_D)\dsa_err.o: $(SRC_D)\crypto\dsa\dsa_err.c
	$(CC) -o $(OBJ_D)\dsa_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_err.c

$(OBJ_D)\dsa_ossl.o: $(SRC_D)\crypto\dsa\dsa_ossl.c
	$(CC) -o $(OBJ_D)\dsa_ossl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_ossl.c

$(OBJ_D)\dsa_depr.o: $(SRC_D)\crypto\dsa\dsa_depr.c
	$(CC) -o $(OBJ_D)\dsa_depr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_depr.c

$(OBJ_D)\dso_dl.o: $(SRC_D)\crypto\dso\dso_dl.c
	$(CC) -o $(OBJ_D)\dso_dl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dso\dso_dl.c

$(OBJ_D)\dso_dlfcn.o: $(SRC_D)\crypto\dso\dso_dlfcn.c
	$(CC) -o $(OBJ_D)\dso_dlfcn.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dso\dso_dlfcn.c

$(OBJ_D)\dso_err.o: $(SRC_D)\crypto\dso\dso_err.c
	$(CC) -o $(OBJ_D)\dso_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dso\dso_err.c

$(OBJ_D)\dso_lib.o: $(SRC_D)\crypto\dso\dso_lib.c
	$(CC) -o $(OBJ_D)\dso_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dso\dso_lib.c

$(OBJ_D)\dso_null.o: $(SRC_D)\crypto\dso\dso_null.c
	$(CC) -o $(OBJ_D)\dso_null.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dso\dso_null.c

$(OBJ_D)\dso_openssl.o: $(SRC_D)\crypto\dso\dso_openssl.c
	$(CC) -o $(OBJ_D)\dso_openssl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dso\dso_openssl.c

$(OBJ_D)\dso_win32.o: $(SRC_D)\crypto\dso\dso_win32.c
	$(CC) -o $(OBJ_D)\dso_win32.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dso\dso_win32.c

$(OBJ_D)\dso_vms.o: $(SRC_D)\crypto\dso\dso_vms.c
	$(CC) -o $(OBJ_D)\dso_vms.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dso\dso_vms.c

$(OBJ_D)\dh_asn1.o: $(SRC_D)\crypto\dh\dh_asn1.c
	$(CC) -o $(OBJ_D)\dh_asn1.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_asn1.c

$(OBJ_D)\dh_gen.o: $(SRC_D)\crypto\dh\dh_gen.c
	$(CC) -o $(OBJ_D)\dh_gen.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_gen.c

$(OBJ_D)\dh_key.o: $(SRC_D)\crypto\dh\dh_key.c
	$(CC) -o $(OBJ_D)\dh_key.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_key.c

$(OBJ_D)\dh_lib.o: $(SRC_D)\crypto\dh\dh_lib.c
	$(CC) -o $(OBJ_D)\dh_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_lib.c

$(OBJ_D)\dh_check.o: $(SRC_D)\crypto\dh\dh_check.c
	$(CC) -o $(OBJ_D)\dh_check.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_check.c

$(OBJ_D)\dh_err.o: $(SRC_D)\crypto\dh\dh_err.c
	$(CC) -o $(OBJ_D)\dh_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_err.c

$(OBJ_D)\dh_depr.o: $(SRC_D)\crypto\dh\dh_depr.c
	$(CC) -o $(OBJ_D)\dh_depr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_depr.c

$(OBJ_D)\ec_lib.o: $(SRC_D)\crypto\ec\ec_lib.c
	$(CC) -o $(OBJ_D)\ec_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ec_lib.c

$(OBJ_D)\ecp_smpl.o: $(SRC_D)\crypto\ec\ecp_smpl.c
	$(CC) -o $(OBJ_D)\ecp_smpl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ecp_smpl.c

$(OBJ_D)\ecp_mont.o: $(SRC_D)\crypto\ec\ecp_mont.c
	$(CC) -o $(OBJ_D)\ecp_mont.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ecp_mont.c

$(OBJ_D)\ecp_nist.o: $(SRC_D)\crypto\ec\ecp_nist.c
	$(CC) -o $(OBJ_D)\ecp_nist.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ecp_nist.c

$(OBJ_D)\ec_cvt.o: $(SRC_D)\crypto\ec\ec_cvt.c
	$(CC) -o $(OBJ_D)\ec_cvt.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ec_cvt.c

$(OBJ_D)\ec_mult.o: $(SRC_D)\crypto\ec\ec_mult.c
	$(CC) -o $(OBJ_D)\ec_mult.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ec_mult.c

$(OBJ_D)\ec_err.o: $(SRC_D)\crypto\ec\ec_err.c
	$(CC) -o $(OBJ_D)\ec_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ec_err.c

$(OBJ_D)\ec_curve.o: $(SRC_D)\crypto\ec\ec_curve.c
	$(CC) -o $(OBJ_D)\ec_curve.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ec_curve.c

$(OBJ_D)\ec_check.o: $(SRC_D)\crypto\ec\ec_check.c
	$(CC) -o $(OBJ_D)\ec_check.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ec_check.c

$(OBJ_D)\ec_print.o: $(SRC_D)\crypto\ec\ec_print.c
	$(CC) -o $(OBJ_D)\ec_print.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ec_print.c

$(OBJ_D)\ec_asn1.o: $(SRC_D)\crypto\ec\ec_asn1.c
	$(CC) -o $(OBJ_D)\ec_asn1.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ec_asn1.c

$(OBJ_D)\ec_key.o: $(SRC_D)\crypto\ec\ec_key.c
	$(CC) -o $(OBJ_D)\ec_key.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ec_key.c

$(OBJ_D)\ec2_smpl.o: $(SRC_D)\crypto\ec\ec2_smpl.c
	$(CC) -o $(OBJ_D)\ec2_smpl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ec2_smpl.c

$(OBJ_D)\ec2_mult.o: $(SRC_D)\crypto\ec\ec2_mult.c
	$(CC) -o $(OBJ_D)\ec2_mult.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ec\ec2_mult.c

$(OBJ_D)\ech_lib.o: $(SRC_D)\crypto\ecdh\ech_lib.c
	$(CC) -o $(OBJ_D)\ech_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ecdh\ech_lib.c

$(OBJ_D)\ech_ossl.o: $(SRC_D)\crypto\ecdh\ech_ossl.c
	$(CC) -o $(OBJ_D)\ech_ossl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ecdh\ech_ossl.c

$(OBJ_D)\ech_key.o: $(SRC_D)\crypto\ecdh\ech_key.c
	$(CC) -o $(OBJ_D)\ech_key.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ecdh\ech_key.c

$(OBJ_D)\ech_err.o: $(SRC_D)\crypto\ecdh\ech_err.c
	$(CC) -o $(OBJ_D)\ech_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ecdh\ech_err.c

$(OBJ_D)\ecs_lib.o: $(SRC_D)\crypto\ecdsa\ecs_lib.c
	$(CC) -o $(OBJ_D)\ecs_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ecdsa\ecs_lib.c

$(OBJ_D)\ecs_asn1.o: $(SRC_D)\crypto\ecdsa\ecs_asn1.c
	$(CC) -o $(OBJ_D)\ecs_asn1.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ecdsa\ecs_asn1.c

$(OBJ_D)\ecs_ossl.o: $(SRC_D)\crypto\ecdsa\ecs_ossl.c
	$(CC) -o $(OBJ_D)\ecs_ossl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ecdsa\ecs_ossl.c

$(OBJ_D)\ecs_sign.o: $(SRC_D)\crypto\ecdsa\ecs_sign.c
	$(CC) -o $(OBJ_D)\ecs_sign.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ecdsa\ecs_sign.c

$(OBJ_D)\ecs_vrf.o: $(SRC_D)\crypto\ecdsa\ecs_vrf.c
	$(CC) -o $(OBJ_D)\ecs_vrf.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ecdsa\ecs_vrf.c

$(OBJ_D)\ecs_err.o: $(SRC_D)\crypto\ecdsa\ecs_err.c
	$(CC) -o $(OBJ_D)\ecs_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ecdsa\ecs_err.c

$(OBJ_D)\buffer.o: $(SRC_D)\crypto\buffer\buffer.c
	$(CC) -o $(OBJ_D)\buffer.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\buffer.c

$(OBJ_D)\buf_err.o: $(SRC_D)\crypto\buffer\buf_err.c
	$(CC) -o $(OBJ_D)\buf_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\buf_err.c

$(OBJ_D)\bio_lib.o: $(SRC_D)\crypto\bio\bio_lib.c
	$(CC) -o $(OBJ_D)\bio_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bio_lib.c

$(OBJ_D)\bio_cb.o: $(SRC_D)\crypto\bio\bio_cb.c
	$(CC) -o $(OBJ_D)\bio_cb.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bio_cb.c

$(OBJ_D)\bio_err.o: $(SRC_D)\crypto\bio\bio_err.c
	$(CC) -o $(OBJ_D)\bio_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bio_err.c

$(OBJ_D)\bss_mem.o: $(SRC_D)\crypto\bio\bss_mem.c
	$(CC) -o $(OBJ_D)\bss_mem.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_mem.c

$(OBJ_D)\bss_null.o: $(SRC_D)\crypto\bio\bss_null.c
	$(CC) -o $(OBJ_D)\bss_null.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_null.c

$(OBJ_D)\bss_fd.o: $(SRC_D)\crypto\bio\bss_fd.c
	$(CC) -o $(OBJ_D)\bss_fd.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_fd.c

$(OBJ_D)\bss_file.o: $(SRC_D)\crypto\bio\bss_file.c
	$(CC) -o $(OBJ_D)\bss_file.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_file.c

$(OBJ_D)\bss_sock.o: $(SRC_D)\crypto\bio\bss_sock.c
	$(CC) -o $(OBJ_D)\bss_sock.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_sock.c

$(OBJ_D)\bss_conn.o: $(SRC_D)\crypto\bio\bss_conn.c
	$(CC) -o $(OBJ_D)\bss_conn.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_conn.c

$(OBJ_D)\bf_null.o: $(SRC_D)\crypto\bio\bf_null.c
	$(CC) -o $(OBJ_D)\bf_null.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bf_null.c

$(OBJ_D)\bf_buff.o: $(SRC_D)\crypto\bio\bf_buff.c
	$(CC) -o $(OBJ_D)\bf_buff.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bf_buff.c

$(OBJ_D)\b_print.o: $(SRC_D)\crypto\bio\b_print.c
	$(CC) -o $(OBJ_D)\b_print.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\b_print.c

$(OBJ_D)\b_dump.o: $(SRC_D)\crypto\bio\b_dump.c
	$(CC) -o $(OBJ_D)\b_dump.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\b_dump.c

$(OBJ_D)\b_sock.o: $(SRC_D)\crypto\bio\b_sock.c
	$(CC) -o $(OBJ_D)\b_sock.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\b_sock.c

$(OBJ_D)\bss_acpt.o: $(SRC_D)\crypto\bio\bss_acpt.c
	$(CC) -o $(OBJ_D)\bss_acpt.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_acpt.c

$(OBJ_D)\bf_nbio.o: $(SRC_D)\crypto\bio\bf_nbio.c
	$(CC) -o $(OBJ_D)\bf_nbio.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bf_nbio.c

$(OBJ_D)\bss_log.o: $(SRC_D)\crypto\bio\bss_log.c
	$(CC) -o $(OBJ_D)\bss_log.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_log.c

$(OBJ_D)\bss_bio.o: $(SRC_D)\crypto\bio\bss_bio.c
	$(CC) -o $(OBJ_D)\bss_bio.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_bio.c

$(OBJ_D)\bss_dgram.o: $(SRC_D)\crypto\bio\bss_dgram.c
	$(CC) -o $(OBJ_D)\bss_dgram.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\bio\bss_dgram.c

$(OBJ_D)\stack.o: $(SRC_D)\crypto\stack\stack.c
	$(CC) -o $(OBJ_D)\stack.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\stack\stack.c

$(OBJ_D)\lhash.o: $(SRC_D)\crypto\lhash\lhash.c
	$(CC) -o $(OBJ_D)\lhash.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\lhash\lhash.c

$(OBJ_D)\lh_stats.o: $(SRC_D)\crypto\lhash\lh_stats.c
	$(CC) -o $(OBJ_D)\lh_stats.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\lhash\lh_stats.c

$(OBJ_D)\md_rand.o: $(SRC_D)\crypto\rand\md_rand.c
	$(CC) -o $(OBJ_D)\md_rand.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rand\md_rand.c

$(OBJ_D)\randfile.o: $(SRC_D)\crypto\rand\randfile.c
	$(CC) -o $(OBJ_D)\randfile.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rand\randfile.c

$(OBJ_D)\rand_lib.o: $(SRC_D)\crypto\rand\rand_lib.c
	$(CC) -o $(OBJ_D)\rand_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rand\rand_lib.c

$(OBJ_D)\rand_err.o: $(SRC_D)\crypto\rand\rand_err.c
	$(CC) -o $(OBJ_D)\rand_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rand\rand_err.c

$(OBJ_D)\rand_egd.o: $(SRC_D)\crypto\rand\rand_egd.c
	$(CC) -o $(OBJ_D)\rand_egd.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rand\rand_egd.c

$(OBJ_D)\rand_win.o: $(SRC_D)\crypto\rand\rand_win.c
	$(CC) -o $(OBJ_D)\rand_win.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rand\rand_win.c

$(OBJ_D)\rand_unix.o: $(SRC_D)\crypto\rand\rand_unix.c
	$(CC) -o $(OBJ_D)\rand_unix.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rand\rand_unix.c

$(OBJ_D)\rand_os2.o: $(SRC_D)\crypto\rand\rand_os2.c
	$(CC) -o $(OBJ_D)\rand_os2.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rand\rand_os2.c

$(OBJ_D)\rand_nw.o: $(SRC_D)\crypto\rand\rand_nw.c
	$(CC) -o $(OBJ_D)\rand_nw.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\rand\rand_nw.c

$(OBJ_D)\err.o: $(SRC_D)\crypto\err\err.c
	$(CC) -o $(OBJ_D)\err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\err\err.c

$(OBJ_D)\err_all.o: $(SRC_D)\crypto\err\err_all.c
	$(CC) -o $(OBJ_D)\err_all.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\err\err_all.c

$(OBJ_D)\err_prn.o: $(SRC_D)\crypto\err\err_prn.c
	$(CC) -o $(OBJ_D)\err_prn.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\err\err_prn.c

$(OBJ_D)\o_names.o: $(SRC_D)\crypto\objects\o_names.c
	$(CC) -o $(OBJ_D)\o_names.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\objects\o_names.c

$(OBJ_D)\obj_dat.o: $(SRC_D)\crypto\objects\obj_dat.c
	$(CC) -o $(OBJ_D)\obj_dat.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\objects\obj_dat.c

$(OBJ_D)\obj_lib.o: $(SRC_D)\crypto\objects\obj_lib.c
	$(CC) -o $(OBJ_D)\obj_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\objects\obj_lib.c

$(OBJ_D)\obj_err.o: $(SRC_D)\crypto\objects\obj_err.c
	$(CC) -o $(OBJ_D)\obj_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\objects\obj_err.c

$(OBJ_D)\encode.o: $(SRC_D)\crypto\evp\encode.c
	$(CC) -o $(OBJ_D)\encode.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\encode.c

$(OBJ_D)\digest.o: $(SRC_D)\crypto\evp\digest.c
	$(CC) -o $(OBJ_D)\digest.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\digest.c

$(OBJ_D)\evp_enc.o: $(SRC_D)\crypto\evp\evp_enc.c
	$(CC) -o $(OBJ_D)\evp_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_enc.c

$(OBJ_D)\evp_key.o: $(SRC_D)\crypto\evp\evp_key.c
	$(CC) -o $(OBJ_D)\evp_key.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_key.c

$(OBJ_D)\evp_acnf.o: $(SRC_D)\crypto\evp\evp_acnf.c
	$(CC) -o $(OBJ_D)\evp_acnf.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_acnf.c

$(OBJ_D)\e_des.o: $(SRC_D)\crypto\evp\e_des.c
	$(CC) -o $(OBJ_D)\e_des.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_des.c

$(OBJ_D)\e_bf.o: $(SRC_D)\crypto\evp\e_bf.c
	$(CC) -o $(OBJ_D)\e_bf.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_bf.c

$(OBJ_D)\e_idea.o: $(SRC_D)\crypto\evp\e_idea.c
	$(CC) -o $(OBJ_D)\e_idea.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_idea.c

$(OBJ_D)\e_des3.o: $(SRC_D)\crypto\evp\e_des3.c
	$(CC) -o $(OBJ_D)\e_des3.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_des3.c

$(OBJ_D)\e_rc4.o: $(SRC_D)\crypto\evp\e_rc4.c
	$(CC) -o $(OBJ_D)\e_rc4.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_rc4.c

$(OBJ_D)\e_aes.o: $(SRC_D)\crypto\evp\e_aes.c
	$(CC) -o $(OBJ_D)\e_aes.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_aes.c

$(OBJ_D)\names.o: $(SRC_D)\crypto\evp\names.c
	$(CC) -o $(OBJ_D)\names.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\names.c

$(OBJ_D)\e_xcbc_d.o: $(SRC_D)\crypto\evp\e_xcbc_d.c
	$(CC) -o $(OBJ_D)\e_xcbc_d.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_xcbc_d.c

$(OBJ_D)\e_rc2.o: $(SRC_D)\crypto\evp\e_rc2.c
	$(CC) -o $(OBJ_D)\e_rc2.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_rc2.c

$(OBJ_D)\e_cast.o: $(SRC_D)\crypto\evp\e_cast.c
	$(CC) -o $(OBJ_D)\e_cast.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cast.c

$(OBJ_D)\e_rc5.o: $(SRC_D)\crypto\evp\e_rc5.c
	$(CC) -o $(OBJ_D)\e_rc5.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_rc5.c

$(OBJ_D)\m_null.o: $(SRC_D)\crypto\evp\m_null.c
	$(CC) -o $(OBJ_D)\m_null.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_null.c

$(OBJ_D)\m_md2.o: $(SRC_D)\crypto\evp\m_md2.c
	$(CC) -o $(OBJ_D)\m_md2.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_md2.c

$(OBJ_D)\m_md4.o: $(SRC_D)\crypto\evp\m_md4.c
	$(CC) -o $(OBJ_D)\m_md4.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_md4.c

$(OBJ_D)\m_md5.o: $(SRC_D)\crypto\evp\m_md5.c
	$(CC) -o $(OBJ_D)\m_md5.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_md5.c

$(OBJ_D)\m_sha.o: $(SRC_D)\crypto\evp\m_sha.c
	$(CC) -o $(OBJ_D)\m_sha.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_sha.c

$(OBJ_D)\m_sha1.o: $(SRC_D)\crypto\evp\m_sha1.c
	$(CC) -o $(OBJ_D)\m_sha1.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_sha1.c

$(OBJ_D)\m_dss.o: $(SRC_D)\crypto\evp\m_dss.c
	$(CC) -o $(OBJ_D)\m_dss.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_dss.c

$(OBJ_D)\m_dss1.o: $(SRC_D)\crypto\evp\m_dss1.c
	$(CC) -o $(OBJ_D)\m_dss1.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_dss1.c

$(OBJ_D)\m_ripemd.o: $(SRC_D)\crypto\evp\m_ripemd.c
	$(CC) -o $(OBJ_D)\m_ripemd.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_ripemd.c

$(OBJ_D)\m_ecdsa.o: $(SRC_D)\crypto\evp\m_ecdsa.c
	$(CC) -o $(OBJ_D)\m_ecdsa.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_ecdsa.c

$(OBJ_D)\p_open.o: $(SRC_D)\crypto\evp\p_open.c
	$(CC) -o $(OBJ_D)\p_open.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_open.c

$(OBJ_D)\p_seal.o: $(SRC_D)\crypto\evp\p_seal.c
	$(CC) -o $(OBJ_D)\p_seal.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_seal.c

$(OBJ_D)\p_sign.o: $(SRC_D)\crypto\evp\p_sign.c
	$(CC) -o $(OBJ_D)\p_sign.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_sign.c

$(OBJ_D)\p_verify.o: $(SRC_D)\crypto\evp\p_verify.c
	$(CC) -o $(OBJ_D)\p_verify.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_verify.c

$(OBJ_D)\p_lib.o: $(SRC_D)\crypto\evp\p_lib.c
	$(CC) -o $(OBJ_D)\p_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_lib.c

$(OBJ_D)\p_enc.o: $(SRC_D)\crypto\evp\p_enc.c
	$(CC) -o $(OBJ_D)\p_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_enc.c

$(OBJ_D)\p_dec.o: $(SRC_D)\crypto\evp\p_dec.c
	$(CC) -o $(OBJ_D)\p_dec.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_dec.c

$(OBJ_D)\bio_md.o: $(SRC_D)\crypto\evp\bio_md.c
	$(CC) -o $(OBJ_D)\bio_md.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\bio_md.c

$(OBJ_D)\bio_b64.o: $(SRC_D)\crypto\evp\bio_b64.c
	$(CC) -o $(OBJ_D)\bio_b64.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\bio_b64.c

$(OBJ_D)\bio_enc.o: $(SRC_D)\crypto\evp\bio_enc.c
	$(CC) -o $(OBJ_D)\bio_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\bio_enc.c

$(OBJ_D)\evp_err.o: $(SRC_D)\crypto\evp\evp_err.c
	$(CC) -o $(OBJ_D)\evp_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_err.c

$(OBJ_D)\e_null.o: $(SRC_D)\crypto\evp\e_null.c
	$(CC) -o $(OBJ_D)\e_null.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_null.c

$(OBJ_D)\c_all.o: $(SRC_D)\crypto\evp\c_all.c
	$(CC) -o $(OBJ_D)\c_all.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\c_all.c

$(OBJ_D)\c_allc.o: $(SRC_D)\crypto\evp\c_allc.c
	$(CC) -o $(OBJ_D)\c_allc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\c_allc.c

$(OBJ_D)\c_alld.o: $(SRC_D)\crypto\evp\c_alld.c
	$(CC) -o $(OBJ_D)\c_alld.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\c_alld.c

$(OBJ_D)\evp_lib.o: $(SRC_D)\crypto\evp\evp_lib.c
	$(CC) -o $(OBJ_D)\evp_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_lib.c

$(OBJ_D)\bio_ok.o: $(SRC_D)\crypto\evp\bio_ok.c
	$(CC) -o $(OBJ_D)\bio_ok.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\bio_ok.c

$(OBJ_D)\evp_pkey.o: $(SRC_D)\crypto\evp\evp_pkey.c
	$(CC) -o $(OBJ_D)\evp_pkey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_pkey.c

$(OBJ_D)\evp_pbe.o: $(SRC_D)\crypto\evp\evp_pbe.c
	$(CC) -o $(OBJ_D)\evp_pbe.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_pbe.c

$(OBJ_D)\p5_crpt.o: $(SRC_D)\crypto\evp\p5_crpt.c
	$(CC) -o $(OBJ_D)\p5_crpt.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p5_crpt.c

$(OBJ_D)\p5_crpt2.o: $(SRC_D)\crypto\evp\p5_crpt2.c
	$(CC) -o $(OBJ_D)\p5_crpt2.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p5_crpt2.c

$(OBJ_D)\e_old.o: $(SRC_D)\crypto\evp\e_old.c
	$(CC) -o $(OBJ_D)\e_old.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_old.c

$(OBJ_D)\a_object.o: $(SRC_D)\crypto\asn1\a_object.c
	$(CC) -o $(OBJ_D)\a_object.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_object.c

$(OBJ_D)\a_bitstr.o: $(SRC_D)\crypto\asn1\a_bitstr.c
	$(CC) -o $(OBJ_D)\a_bitstr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_bitstr.c

$(OBJ_D)\a_utctm.o: $(SRC_D)\crypto\asn1\a_utctm.c
	$(CC) -o $(OBJ_D)\a_utctm.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_utctm.c

$(OBJ_D)\a_gentm.o: $(SRC_D)\crypto\asn1\a_gentm.c
	$(CC) -o $(OBJ_D)\a_gentm.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_gentm.c

$(OBJ_D)\a_time.o: $(SRC_D)\crypto\asn1\a_time.c
	$(CC) -o $(OBJ_D)\a_time.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_time.c

$(OBJ_D)\a_int.o: $(SRC_D)\crypto\asn1\a_int.c
	$(CC) -o $(OBJ_D)\a_int.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_int.c

$(OBJ_D)\a_octet.o: $(SRC_D)\crypto\asn1\a_octet.c
	$(CC) -o $(OBJ_D)\a_octet.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_octet.c

$(OBJ_D)\a_print.o: $(SRC_D)\crypto\asn1\a_print.c
	$(CC) -o $(OBJ_D)\a_print.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_print.c

$(OBJ_D)\a_type.o: $(SRC_D)\crypto\asn1\a_type.c
	$(CC) -o $(OBJ_D)\a_type.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_type.c

$(OBJ_D)\a_set.o: $(SRC_D)\crypto\asn1\a_set.c
	$(CC) -o $(OBJ_D)\a_set.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_set.c

$(OBJ_D)\a_dup.o: $(SRC_D)\crypto\asn1\a_dup.c
	$(CC) -o $(OBJ_D)\a_dup.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_dup.c

$(OBJ_D)\a_d2i_fp.o: $(SRC_D)\crypto\asn1\a_d2i_fp.c
	$(CC) -o $(OBJ_D)\a_d2i_fp.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_d2i_fp.c

$(OBJ_D)\a_i2d_fp.o: $(SRC_D)\crypto\asn1\a_i2d_fp.c
	$(CC) -o $(OBJ_D)\a_i2d_fp.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_i2d_fp.c

$(OBJ_D)\a_enum.o: $(SRC_D)\crypto\asn1\a_enum.c
	$(CC) -o $(OBJ_D)\a_enum.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_enum.c

$(OBJ_D)\a_utf8.o: $(SRC_D)\crypto\asn1\a_utf8.c
	$(CC) -o $(OBJ_D)\a_utf8.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_utf8.c

$(OBJ_D)\a_sign.o: $(SRC_D)\crypto\asn1\a_sign.c
	$(CC) -o $(OBJ_D)\a_sign.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_sign.c

$(OBJ_D)\a_digest.o: $(SRC_D)\crypto\asn1\a_digest.c
	$(CC) -o $(OBJ_D)\a_digest.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_digest.c

$(OBJ_D)\a_verify.o: $(SRC_D)\crypto\asn1\a_verify.c
	$(CC) -o $(OBJ_D)\a_verify.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_verify.c

$(OBJ_D)\a_mbstr.o: $(SRC_D)\crypto\asn1\a_mbstr.c
	$(CC) -o $(OBJ_D)\a_mbstr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_mbstr.c

$(OBJ_D)\a_strex.o: $(SRC_D)\crypto\asn1\a_strex.c
	$(CC) -o $(OBJ_D)\a_strex.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_strex.c

$(OBJ_D)\x_algor.o: $(SRC_D)\crypto\asn1\x_algor.c
	$(CC) -o $(OBJ_D)\x_algor.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_algor.c

$(OBJ_D)\x_val.o: $(SRC_D)\crypto\asn1\x_val.c
	$(CC) -o $(OBJ_D)\x_val.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_val.c

$(OBJ_D)\x_pubkey.o: $(SRC_D)\crypto\asn1\x_pubkey.c
	$(CC) -o $(OBJ_D)\x_pubkey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_pubkey.c

$(OBJ_D)\x_sig.o: $(SRC_D)\crypto\asn1\x_sig.c
	$(CC) -o $(OBJ_D)\x_sig.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_sig.c

$(OBJ_D)\x_req.o: $(SRC_D)\crypto\asn1\x_req.c
	$(CC) -o $(OBJ_D)\x_req.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_req.c

$(OBJ_D)\x_attrib.o: $(SRC_D)\crypto\asn1\x_attrib.c
	$(CC) -o $(OBJ_D)\x_attrib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_attrib.c

$(OBJ_D)\x_bignum.o: $(SRC_D)\crypto\asn1\x_bignum.c
	$(CC) -o $(OBJ_D)\x_bignum.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_bignum.c

$(OBJ_D)\x_long.o: $(SRC_D)\crypto\asn1\x_long.c
	$(CC) -o $(OBJ_D)\x_long.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_long.c

$(OBJ_D)\x_name.o: $(SRC_D)\crypto\asn1\x_name.c
	$(CC) -o $(OBJ_D)\x_name.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_name.c

$(OBJ_D)\x_x509.o: $(SRC_D)\crypto\asn1\x_x509.c
	$(CC) -o $(OBJ_D)\x_x509.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_x509.c

$(OBJ_D)\x_x509a.o: $(SRC_D)\crypto\asn1\x_x509a.c
	$(CC) -o $(OBJ_D)\x_x509a.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_x509a.c

$(OBJ_D)\x_crl.o: $(SRC_D)\crypto\asn1\x_crl.c
	$(CC) -o $(OBJ_D)\x_crl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_crl.c

$(OBJ_D)\x_info.o: $(SRC_D)\crypto\asn1\x_info.c
	$(CC) -o $(OBJ_D)\x_info.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_info.c

$(OBJ_D)\x_spki.o: $(SRC_D)\crypto\asn1\x_spki.c
	$(CC) -o $(OBJ_D)\x_spki.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_spki.c

$(OBJ_D)\nsseq.o: $(SRC_D)\crypto\asn1\nsseq.c
	$(CC) -o $(OBJ_D)\nsseq.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\nsseq.c

$(OBJ_D)\d2i_pu.o: $(SRC_D)\crypto\asn1\d2i_pu.c
	$(CC) -o $(OBJ_D)\d2i_pu.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_pu.c

$(OBJ_D)\d2i_pr.o: $(SRC_D)\crypto\asn1\d2i_pr.c
	$(CC) -o $(OBJ_D)\d2i_pr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_pr.c

$(OBJ_D)\i2d_pu.o: $(SRC_D)\crypto\asn1\i2d_pu.c
	$(CC) -o $(OBJ_D)\i2d_pu.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_pu.c

$(OBJ_D)\i2d_pr.o: $(SRC_D)\crypto\asn1\i2d_pr.c
	$(CC) -o $(OBJ_D)\i2d_pr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_pr.c

$(OBJ_D)\t_req.o: $(SRC_D)\crypto\asn1\t_req.c
	$(CC) -o $(OBJ_D)\t_req.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_req.c

$(OBJ_D)\t_x509.o: $(SRC_D)\crypto\asn1\t_x509.c
	$(CC) -o $(OBJ_D)\t_x509.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_x509.c

$(OBJ_D)\t_x509a.o: $(SRC_D)\crypto\asn1\t_x509a.c
	$(CC) -o $(OBJ_D)\t_x509a.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_x509a.c

$(OBJ_D)\t_crl.o: $(SRC_D)\crypto\asn1\t_crl.c
	$(CC) -o $(OBJ_D)\t_crl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_crl.c

$(OBJ_D)\t_pkey.o: $(SRC_D)\crypto\asn1\t_pkey.c
	$(CC) -o $(OBJ_D)\t_pkey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_pkey.c

$(OBJ_D)\t_spki.o: $(SRC_D)\crypto\asn1\t_spki.c
	$(CC) -o $(OBJ_D)\t_spki.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_spki.c

$(OBJ_D)\t_bitst.o: $(SRC_D)\crypto\asn1\t_bitst.c
	$(CC) -o $(OBJ_D)\t_bitst.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_bitst.c

$(OBJ_D)\tasn_new.o: $(SRC_D)\crypto\asn1\tasn_new.c
	$(CC) -o $(OBJ_D)\tasn_new.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\tasn_new.c

$(OBJ_D)\tasn_fre.o: $(SRC_D)\crypto\asn1\tasn_fre.c
	$(CC) -o $(OBJ_D)\tasn_fre.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\tasn_fre.c

$(OBJ_D)\tasn_enc.o: $(SRC_D)\crypto\asn1\tasn_enc.c
	$(CC) -o $(OBJ_D)\tasn_enc.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\tasn_enc.c

$(OBJ_D)\tasn_dec.o: $(SRC_D)\crypto\asn1\tasn_dec.c
	$(CC) -o $(OBJ_D)\tasn_dec.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\tasn_dec.c

$(OBJ_D)\tasn_utl.o: $(SRC_D)\crypto\asn1\tasn_utl.c
	$(CC) -o $(OBJ_D)\tasn_utl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\tasn_utl.c

$(OBJ_D)\tasn_typ.o: $(SRC_D)\crypto\asn1\tasn_typ.c
	$(CC) -o $(OBJ_D)\tasn_typ.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\tasn_typ.c

$(OBJ_D)\f_int.o: $(SRC_D)\crypto\asn1\f_int.c
	$(CC) -o $(OBJ_D)\f_int.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\f_int.c

$(OBJ_D)\f_string.o: $(SRC_D)\crypto\asn1\f_string.c
	$(CC) -o $(OBJ_D)\f_string.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\f_string.c

$(OBJ_D)\n_pkey.o: $(SRC_D)\crypto\asn1\n_pkey.c
	$(CC) -o $(OBJ_D)\n_pkey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\n_pkey.c

$(OBJ_D)\f_enum.o: $(SRC_D)\crypto\asn1\f_enum.c
	$(CC) -o $(OBJ_D)\f_enum.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\f_enum.c

$(OBJ_D)\a_hdr.o: $(SRC_D)\crypto\asn1\a_hdr.c
	$(CC) -o $(OBJ_D)\a_hdr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_hdr.c

$(OBJ_D)\x_pkey.o: $(SRC_D)\crypto\asn1\x_pkey.c
	$(CC) -o $(OBJ_D)\x_pkey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_pkey.c

$(OBJ_D)\a_bool.o: $(SRC_D)\crypto\asn1\a_bool.c
	$(CC) -o $(OBJ_D)\a_bool.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_bool.c

$(OBJ_D)\x_exten.o: $(SRC_D)\crypto\asn1\x_exten.c
	$(CC) -o $(OBJ_D)\x_exten.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_exten.c

$(OBJ_D)\asn1_gen.o: $(SRC_D)\crypto\asn1\asn1_gen.c
	$(CC) -o $(OBJ_D)\asn1_gen.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn1_gen.c

$(OBJ_D)\asn1_par.o: $(SRC_D)\crypto\asn1\asn1_par.c
	$(CC) -o $(OBJ_D)\asn1_par.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn1_par.c

$(OBJ_D)\asn1_lib.o: $(SRC_D)\crypto\asn1\asn1_lib.c
	$(CC) -o $(OBJ_D)\asn1_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn1_lib.c

$(OBJ_D)\asn1_err.o: $(SRC_D)\crypto\asn1\asn1_err.c
	$(CC) -o $(OBJ_D)\asn1_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn1_err.c

$(OBJ_D)\a_meth.o: $(SRC_D)\crypto\asn1\a_meth.c
	$(CC) -o $(OBJ_D)\a_meth.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_meth.c

$(OBJ_D)\a_bytes.o: $(SRC_D)\crypto\asn1\a_bytes.c
	$(CC) -o $(OBJ_D)\a_bytes.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_bytes.c

$(OBJ_D)\a_strnid.o: $(SRC_D)\crypto\asn1\a_strnid.c
	$(CC) -o $(OBJ_D)\a_strnid.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_strnid.c

$(OBJ_D)\evp_asn1.o: $(SRC_D)\crypto\asn1\evp_asn1.c
	$(CC) -o $(OBJ_D)\evp_asn1.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\evp_asn1.c

$(OBJ_D)\asn_pack.o: $(SRC_D)\crypto\asn1\asn_pack.c
	$(CC) -o $(OBJ_D)\asn_pack.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn_pack.c

$(OBJ_D)\p5_pbe.o: $(SRC_D)\crypto\asn1\p5_pbe.c
	$(CC) -o $(OBJ_D)\p5_pbe.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p5_pbe.c

$(OBJ_D)\p5_pbev2.o: $(SRC_D)\crypto\asn1\p5_pbev2.c
	$(CC) -o $(OBJ_D)\p5_pbev2.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p5_pbev2.c

$(OBJ_D)\p8_pkey.o: $(SRC_D)\crypto\asn1\p8_pkey.c
	$(CC) -o $(OBJ_D)\p8_pkey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p8_pkey.c

$(OBJ_D)\asn_moid.o: $(SRC_D)\crypto\asn1\asn_moid.c
	$(CC) -o $(OBJ_D)\asn_moid.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn_moid.c

$(OBJ_D)\pem_sign.o: $(SRC_D)\crypto\pem\pem_sign.c
	$(CC) -o $(OBJ_D)\pem_sign.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_sign.c

$(OBJ_D)\pem_seal.o: $(SRC_D)\crypto\pem\pem_seal.c
	$(CC) -o $(OBJ_D)\pem_seal.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_seal.c

$(OBJ_D)\pem_info.o: $(SRC_D)\crypto\pem\pem_info.c
	$(CC) -o $(OBJ_D)\pem_info.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_info.c

$(OBJ_D)\pem_lib.o: $(SRC_D)\crypto\pem\pem_lib.c
	$(CC) -o $(OBJ_D)\pem_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_lib.c

$(OBJ_D)\pem_all.o: $(SRC_D)\crypto\pem\pem_all.c
	$(CC) -o $(OBJ_D)\pem_all.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_all.c

$(OBJ_D)\pem_err.o: $(SRC_D)\crypto\pem\pem_err.c
	$(CC) -o $(OBJ_D)\pem_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_err.c

$(OBJ_D)\pem_x509.o: $(SRC_D)\crypto\pem\pem_x509.c
	$(CC) -o $(OBJ_D)\pem_x509.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_x509.c

$(OBJ_D)\pem_xaux.o: $(SRC_D)\crypto\pem\pem_xaux.c
	$(CC) -o $(OBJ_D)\pem_xaux.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_xaux.c

$(OBJ_D)\pem_oth.o: $(SRC_D)\crypto\pem\pem_oth.c
	$(CC) -o $(OBJ_D)\pem_oth.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_oth.c

$(OBJ_D)\pem_pk8.o: $(SRC_D)\crypto\pem\pem_pk8.c
	$(CC) -o $(OBJ_D)\pem_pk8.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_pk8.c

$(OBJ_D)\pem_pkey.o: $(SRC_D)\crypto\pem\pem_pkey.c
	$(CC) -o $(OBJ_D)\pem_pkey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_pkey.c

$(OBJ_D)\x509_def.o: $(SRC_D)\crypto\x509\x509_def.c
	$(CC) -o $(OBJ_D)\x509_def.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_def.c

$(OBJ_D)\x509_d2.o: $(SRC_D)\crypto\x509\x509_d2.c
	$(CC) -o $(OBJ_D)\x509_d2.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_d2.c

$(OBJ_D)\x509_r2x.o: $(SRC_D)\crypto\x509\x509_r2x.c
	$(CC) -o $(OBJ_D)\x509_r2x.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_r2x.c

$(OBJ_D)\x509_cmp.o: $(SRC_D)\crypto\x509\x509_cmp.c
	$(CC) -o $(OBJ_D)\x509_cmp.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_cmp.c

$(OBJ_D)\x509_obj.o: $(SRC_D)\crypto\x509\x509_obj.c
	$(CC) -o $(OBJ_D)\x509_obj.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_obj.c

$(OBJ_D)\x509_req.o: $(SRC_D)\crypto\x509\x509_req.c
	$(CC) -o $(OBJ_D)\x509_req.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_req.c

$(OBJ_D)\x509spki.o: $(SRC_D)\crypto\x509\x509spki.c
	$(CC) -o $(OBJ_D)\x509spki.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509spki.c

$(OBJ_D)\x509_vfy.o: $(SRC_D)\crypto\x509\x509_vfy.c
	$(CC) -o $(OBJ_D)\x509_vfy.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_vfy.c

$(OBJ_D)\x509_set.o: $(SRC_D)\crypto\x509\x509_set.c
	$(CC) -o $(OBJ_D)\x509_set.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_set.c

$(OBJ_D)\x509cset.o: $(SRC_D)\crypto\x509\x509cset.c
	$(CC) -o $(OBJ_D)\x509cset.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509cset.c

$(OBJ_D)\x509rset.o: $(SRC_D)\crypto\x509\x509rset.c
	$(CC) -o $(OBJ_D)\x509rset.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509rset.c

$(OBJ_D)\x509_err.o: $(SRC_D)\crypto\x509\x509_err.c
	$(CC) -o $(OBJ_D)\x509_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_err.c

$(OBJ_D)\x509name.o: $(SRC_D)\crypto\x509\x509name.c
	$(CC) -o $(OBJ_D)\x509name.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509name.c

$(OBJ_D)\x509_v3.o: $(SRC_D)\crypto\x509\x509_v3.c
	$(CC) -o $(OBJ_D)\x509_v3.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_v3.c

$(OBJ_D)\x509_ext.o: $(SRC_D)\crypto\x509\x509_ext.c
	$(CC) -o $(OBJ_D)\x509_ext.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_ext.c

$(OBJ_D)\x509_att.o: $(SRC_D)\crypto\x509\x509_att.c
	$(CC) -o $(OBJ_D)\x509_att.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_att.c

$(OBJ_D)\x509type.o: $(SRC_D)\crypto\x509\x509type.c
	$(CC) -o $(OBJ_D)\x509type.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509type.c

$(OBJ_D)\x509_lu.o: $(SRC_D)\crypto\x509\x509_lu.c
	$(CC) -o $(OBJ_D)\x509_lu.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_lu.c

$(OBJ_D)\x_all.o: $(SRC_D)\crypto\x509\x_all.c
	$(CC) -o $(OBJ_D)\x_all.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x_all.c

$(OBJ_D)\x509_txt.o: $(SRC_D)\crypto\x509\x509_txt.c
	$(CC) -o $(OBJ_D)\x509_txt.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_txt.c

$(OBJ_D)\x509_trs.o: $(SRC_D)\crypto\x509\x509_trs.c
	$(CC) -o $(OBJ_D)\x509_trs.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_trs.c

$(OBJ_D)\by_file.o: $(SRC_D)\crypto\x509\by_file.c
	$(CC) -o $(OBJ_D)\by_file.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\by_file.c

$(OBJ_D)\by_dir.o: $(SRC_D)\crypto\x509\by_dir.c
	$(CC) -o $(OBJ_D)\by_dir.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\by_dir.c

$(OBJ_D)\x509_vpm.o: $(SRC_D)\crypto\x509\x509_vpm.c
	$(CC) -o $(OBJ_D)\x509_vpm.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_vpm.c

$(OBJ_D)\v3_bcons.o: $(SRC_D)\crypto\x509v3\v3_bcons.c
	$(CC) -o $(OBJ_D)\v3_bcons.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_bcons.c

$(OBJ_D)\v3_bitst.o: $(SRC_D)\crypto\x509v3\v3_bitst.c
	$(CC) -o $(OBJ_D)\v3_bitst.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_bitst.c

$(OBJ_D)\v3_conf.o: $(SRC_D)\crypto\x509v3\v3_conf.c
	$(CC) -o $(OBJ_D)\v3_conf.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_conf.c

$(OBJ_D)\v3_extku.o: $(SRC_D)\crypto\x509v3\v3_extku.c
	$(CC) -o $(OBJ_D)\v3_extku.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_extku.c

$(OBJ_D)\v3_ia5.o: $(SRC_D)\crypto\x509v3\v3_ia5.c
	$(CC) -o $(OBJ_D)\v3_ia5.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_ia5.c

$(OBJ_D)\v3_lib.o: $(SRC_D)\crypto\x509v3\v3_lib.c
	$(CC) -o $(OBJ_D)\v3_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_lib.c

$(OBJ_D)\v3_prn.o: $(SRC_D)\crypto\x509v3\v3_prn.c
	$(CC) -o $(OBJ_D)\v3_prn.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_prn.c

$(OBJ_D)\v3_utl.o: $(SRC_D)\crypto\x509v3\v3_utl.c
	$(CC) -o $(OBJ_D)\v3_utl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_utl.c

$(OBJ_D)\v3err.o: $(SRC_D)\crypto\x509v3\v3err.c
	$(CC) -o $(OBJ_D)\v3err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3err.c

$(OBJ_D)\v3_genn.o: $(SRC_D)\crypto\x509v3\v3_genn.c
	$(CC) -o $(OBJ_D)\v3_genn.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_genn.c

$(OBJ_D)\v3_alt.o: $(SRC_D)\crypto\x509v3\v3_alt.c
	$(CC) -o $(OBJ_D)\v3_alt.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_alt.c

$(OBJ_D)\v3_skey.o: $(SRC_D)\crypto\x509v3\v3_skey.c
	$(CC) -o $(OBJ_D)\v3_skey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_skey.c

$(OBJ_D)\v3_akey.o: $(SRC_D)\crypto\x509v3\v3_akey.c
	$(CC) -o $(OBJ_D)\v3_akey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_akey.c

$(OBJ_D)\v3_pku.o: $(SRC_D)\crypto\x509v3\v3_pku.c
	$(CC) -o $(OBJ_D)\v3_pku.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_pku.c

$(OBJ_D)\v3_int.o: $(SRC_D)\crypto\x509v3\v3_int.c
	$(CC) -o $(OBJ_D)\v3_int.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_int.c

$(OBJ_D)\v3_enum.o: $(SRC_D)\crypto\x509v3\v3_enum.c
	$(CC) -o $(OBJ_D)\v3_enum.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_enum.c

$(OBJ_D)\v3_sxnet.o: $(SRC_D)\crypto\x509v3\v3_sxnet.c
	$(CC) -o $(OBJ_D)\v3_sxnet.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_sxnet.c

$(OBJ_D)\v3_cpols.o: $(SRC_D)\crypto\x509v3\v3_cpols.c
	$(CC) -o $(OBJ_D)\v3_cpols.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_cpols.c

$(OBJ_D)\v3_crld.o: $(SRC_D)\crypto\x509v3\v3_crld.c
	$(CC) -o $(OBJ_D)\v3_crld.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_crld.c

$(OBJ_D)\v3_purp.o: $(SRC_D)\crypto\x509v3\v3_purp.c
	$(CC) -o $(OBJ_D)\v3_purp.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_purp.c

$(OBJ_D)\v3_info.o: $(SRC_D)\crypto\x509v3\v3_info.c
	$(CC) -o $(OBJ_D)\v3_info.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_info.c

$(OBJ_D)\v3_ocsp.o: $(SRC_D)\crypto\x509v3\v3_ocsp.c
	$(CC) -o $(OBJ_D)\v3_ocsp.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_ocsp.c

$(OBJ_D)\v3_akeya.o: $(SRC_D)\crypto\x509v3\v3_akeya.c
	$(CC) -o $(OBJ_D)\v3_akeya.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_akeya.c

$(OBJ_D)\v3_pmaps.o: $(SRC_D)\crypto\x509v3\v3_pmaps.c
	$(CC) -o $(OBJ_D)\v3_pmaps.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_pmaps.c

$(OBJ_D)\v3_pcons.o: $(SRC_D)\crypto\x509v3\v3_pcons.c
	$(CC) -o $(OBJ_D)\v3_pcons.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_pcons.c

$(OBJ_D)\v3_ncons.o: $(SRC_D)\crypto\x509v3\v3_ncons.c
	$(CC) -o $(OBJ_D)\v3_ncons.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_ncons.c

$(OBJ_D)\v3_pcia.o: $(SRC_D)\crypto\x509v3\v3_pcia.c
	$(CC) -o $(OBJ_D)\v3_pcia.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_pcia.c

$(OBJ_D)\v3_pci.o: $(SRC_D)\crypto\x509v3\v3_pci.c
	$(CC) -o $(OBJ_D)\v3_pci.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_pci.c

$(OBJ_D)\pcy_cache.o: $(SRC_D)\crypto\x509v3\pcy_cache.c
	$(CC) -o $(OBJ_D)\pcy_cache.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\pcy_cache.c

$(OBJ_D)\pcy_node.o: $(SRC_D)\crypto\x509v3\pcy_node.c
	$(CC) -o $(OBJ_D)\pcy_node.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\pcy_node.c

$(OBJ_D)\pcy_data.o: $(SRC_D)\crypto\x509v3\pcy_data.c
	$(CC) -o $(OBJ_D)\pcy_data.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\pcy_data.c

$(OBJ_D)\pcy_map.o: $(SRC_D)\crypto\x509v3\pcy_map.c
	$(CC) -o $(OBJ_D)\pcy_map.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\pcy_map.c

$(OBJ_D)\pcy_tree.o: $(SRC_D)\crypto\x509v3\pcy_tree.c
	$(CC) -o $(OBJ_D)\pcy_tree.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\pcy_tree.c

$(OBJ_D)\pcy_lib.o: $(SRC_D)\crypto\x509v3\pcy_lib.c
	$(CC) -o $(OBJ_D)\pcy_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\pcy_lib.c

$(OBJ_D)\v3_asid.o: $(SRC_D)\crypto\x509v3\v3_asid.c
	$(CC) -o $(OBJ_D)\v3_asid.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_asid.c

$(OBJ_D)\v3_addr.o: $(SRC_D)\crypto\x509v3\v3_addr.c
	$(CC) -o $(OBJ_D)\v3_addr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509v3\v3_addr.c

$(OBJ_D)\conf_err.o: $(SRC_D)\crypto\conf\conf_err.c
	$(CC) -o $(OBJ_D)\conf_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\conf\conf_err.c

$(OBJ_D)\conf_lib.o: $(SRC_D)\crypto\conf\conf_lib.c
	$(CC) -o $(OBJ_D)\conf_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\conf\conf_lib.c

$(OBJ_D)\conf_api.o: $(SRC_D)\crypto\conf\conf_api.c
	$(CC) -o $(OBJ_D)\conf_api.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\conf\conf_api.c

$(OBJ_D)\conf_def.o: $(SRC_D)\crypto\conf\conf_def.c
	$(CC) -o $(OBJ_D)\conf_def.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\conf\conf_def.c

$(OBJ_D)\conf_mod.o: $(SRC_D)\crypto\conf\conf_mod.c
	$(CC) -o $(OBJ_D)\conf_mod.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\conf\conf_mod.c

$(OBJ_D)\conf_mall.o: $(SRC_D)\crypto\conf\conf_mall.c
	$(CC) -o $(OBJ_D)\conf_mall.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\conf\conf_mall.c

$(OBJ_D)\conf_sap.o: $(SRC_D)\crypto\conf\conf_sap.c
	$(CC) -o $(OBJ_D)\conf_sap.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\conf\conf_sap.c

$(OBJ_D)\txt_db.o: $(SRC_D)\crypto\txt_db\txt_db.c
	$(CC) -o $(OBJ_D)\txt_db.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\txt_db\txt_db.c

$(OBJ_D)\pk7_asn1.o: $(SRC_D)\crypto\pkcs7\pk7_asn1.c
	$(CC) -o $(OBJ_D)\pk7_asn1.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs7\pk7_asn1.c

$(OBJ_D)\pk7_lib.o: $(SRC_D)\crypto\pkcs7\pk7_lib.c
	$(CC) -o $(OBJ_D)\pk7_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs7\pk7_lib.c

$(OBJ_D)\pkcs7err.o: $(SRC_D)\crypto\pkcs7\pkcs7err.c
	$(CC) -o $(OBJ_D)\pkcs7err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs7\pkcs7err.c

$(OBJ_D)\pk7_doit.o: $(SRC_D)\crypto\pkcs7\pk7_doit.c
	$(CC) -o $(OBJ_D)\pk7_doit.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs7\pk7_doit.c

$(OBJ_D)\pk7_smime.o: $(SRC_D)\crypto\pkcs7\pk7_smime.c
	$(CC) -o $(OBJ_D)\pk7_smime.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs7\pk7_smime.c

$(OBJ_D)\pk7_attr.o: $(SRC_D)\crypto\pkcs7\pk7_attr.c
	$(CC) -o $(OBJ_D)\pk7_attr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs7\pk7_attr.c

$(OBJ_D)\pk7_mime.o: $(SRC_D)\crypto\pkcs7\pk7_mime.c
	$(CC) -o $(OBJ_D)\pk7_mime.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs7\pk7_mime.c

$(OBJ_D)\p12_add.o: $(SRC_D)\crypto\pkcs12\p12_add.c
	$(CC) -o $(OBJ_D)\p12_add.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_add.c

$(OBJ_D)\p12_asn.o: $(SRC_D)\crypto\pkcs12\p12_asn.c
	$(CC) -o $(OBJ_D)\p12_asn.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_asn.c

$(OBJ_D)\p12_attr.o: $(SRC_D)\crypto\pkcs12\p12_attr.c
	$(CC) -o $(OBJ_D)\p12_attr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_attr.c

$(OBJ_D)\p12_crpt.o: $(SRC_D)\crypto\pkcs12\p12_crpt.c
	$(CC) -o $(OBJ_D)\p12_crpt.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_crpt.c

$(OBJ_D)\p12_crt.o: $(SRC_D)\crypto\pkcs12\p12_crt.c
	$(CC) -o $(OBJ_D)\p12_crt.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_crt.c

$(OBJ_D)\p12_decr.o: $(SRC_D)\crypto\pkcs12\p12_decr.c
	$(CC) -o $(OBJ_D)\p12_decr.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_decr.c

$(OBJ_D)\p12_init.o: $(SRC_D)\crypto\pkcs12\p12_init.c
	$(CC) -o $(OBJ_D)\p12_init.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_init.c

$(OBJ_D)\p12_key.o: $(SRC_D)\crypto\pkcs12\p12_key.c
	$(CC) -o $(OBJ_D)\p12_key.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_key.c

$(OBJ_D)\p12_kiss.o: $(SRC_D)\crypto\pkcs12\p12_kiss.c
	$(CC) -o $(OBJ_D)\p12_kiss.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_kiss.c

$(OBJ_D)\p12_mutl.o: $(SRC_D)\crypto\pkcs12\p12_mutl.c
	$(CC) -o $(OBJ_D)\p12_mutl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_mutl.c

$(OBJ_D)\p12_utl.o: $(SRC_D)\crypto\pkcs12\p12_utl.c
	$(CC) -o $(OBJ_D)\p12_utl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_utl.c

$(OBJ_D)\p12_npas.o: $(SRC_D)\crypto\pkcs12\p12_npas.c
	$(CC) -o $(OBJ_D)\p12_npas.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_npas.c

$(OBJ_D)\pk12err.o: $(SRC_D)\crypto\pkcs12\pk12err.c
	$(CC) -o $(OBJ_D)\pk12err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\pk12err.c

$(OBJ_D)\p12_p8d.o: $(SRC_D)\crypto\pkcs12\p12_p8d.c
	$(CC) -o $(OBJ_D)\p12_p8d.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_p8d.c

$(OBJ_D)\p12_p8e.o: $(SRC_D)\crypto\pkcs12\p12_p8e.c
	$(CC) -o $(OBJ_D)\p12_p8e.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pkcs12\p12_p8e.c

$(OBJ_D)\comp_lib.o: $(SRC_D)\crypto\comp\comp_lib.c
	$(CC) -o $(OBJ_D)\comp_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\comp\comp_lib.c

$(OBJ_D)\comp_err.o: $(SRC_D)\crypto\comp\comp_err.c
	$(CC) -o $(OBJ_D)\comp_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\comp\comp_err.c

$(OBJ_D)\c_rle.o: $(SRC_D)\crypto\comp\c_rle.c
	$(CC) -o $(OBJ_D)\c_rle.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\comp\c_rle.c

$(OBJ_D)\c_zlib.o: $(SRC_D)\crypto\comp\c_zlib.c
	$(CC) -o $(OBJ_D)\c_zlib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\comp\c_zlib.c

$(OBJ_D)\eng_err.o: $(SRC_D)\crypto\engine\eng_err.c
	$(CC) -o $(OBJ_D)\eng_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_err.c

$(OBJ_D)\eng_lib.o: $(SRC_D)\crypto\engine\eng_lib.c
	$(CC) -o $(OBJ_D)\eng_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_lib.c

$(OBJ_D)\eng_list.o: $(SRC_D)\crypto\engine\eng_list.c
	$(CC) -o $(OBJ_D)\eng_list.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_list.c

$(OBJ_D)\eng_init.o: $(SRC_D)\crypto\engine\eng_init.c
	$(CC) -o $(OBJ_D)\eng_init.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_init.c

$(OBJ_D)\eng_ctrl.o: $(SRC_D)\crypto\engine\eng_ctrl.c
	$(CC) -o $(OBJ_D)\eng_ctrl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_ctrl.c

$(OBJ_D)\eng_table.o: $(SRC_D)\crypto\engine\eng_table.c
	$(CC) -o $(OBJ_D)\eng_table.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_table.c

$(OBJ_D)\eng_pkey.o: $(SRC_D)\crypto\engine\eng_pkey.c
	$(CC) -o $(OBJ_D)\eng_pkey.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_pkey.c

$(OBJ_D)\eng_fat.o: $(SRC_D)\crypto\engine\eng_fat.c
	$(CC) -o $(OBJ_D)\eng_fat.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_fat.c

$(OBJ_D)\eng_all.o: $(SRC_D)\crypto\engine\eng_all.c
	$(CC) -o $(OBJ_D)\eng_all.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_all.c

$(OBJ_D)\tb_rsa.o: $(SRC_D)\crypto\engine\tb_rsa.c
	$(CC) -o $(OBJ_D)\tb_rsa.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\tb_rsa.c

$(OBJ_D)\tb_dsa.o: $(SRC_D)\crypto\engine\tb_dsa.c
	$(CC) -o $(OBJ_D)\tb_dsa.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\tb_dsa.c

$(OBJ_D)\tb_ecdsa.o: $(SRC_D)\crypto\engine\tb_ecdsa.c
	$(CC) -o $(OBJ_D)\tb_ecdsa.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\tb_ecdsa.c

$(OBJ_D)\tb_dh.o: $(SRC_D)\crypto\engine\tb_dh.c
	$(CC) -o $(OBJ_D)\tb_dh.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\tb_dh.c

$(OBJ_D)\tb_ecdh.o: $(SRC_D)\crypto\engine\tb_ecdh.c
	$(CC) -o $(OBJ_D)\tb_ecdh.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\tb_ecdh.c

$(OBJ_D)\tb_rand.o: $(SRC_D)\crypto\engine\tb_rand.c
	$(CC) -o $(OBJ_D)\tb_rand.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\tb_rand.c

$(OBJ_D)\tb_store.o: $(SRC_D)\crypto\engine\tb_store.c
	$(CC) -o $(OBJ_D)\tb_store.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\tb_store.c

$(OBJ_D)\tb_cipher.o: $(SRC_D)\crypto\engine\tb_cipher.c
	$(CC) -o $(OBJ_D)\tb_cipher.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\tb_cipher.c

$(OBJ_D)\tb_digest.o: $(SRC_D)\crypto\engine\tb_digest.c
	$(CC) -o $(OBJ_D)\tb_digest.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\tb_digest.c

$(OBJ_D)\eng_openssl.o: $(SRC_D)\crypto\engine\eng_openssl.c
	$(CC) -o $(OBJ_D)\eng_openssl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_openssl.c

$(OBJ_D)\eng_cnf.o: $(SRC_D)\crypto\engine\eng_cnf.c
	$(CC) -o $(OBJ_D)\eng_cnf.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_cnf.c

$(OBJ_D)\eng_dyn.o: $(SRC_D)\crypto\engine\eng_dyn.c
	$(CC) -o $(OBJ_D)\eng_dyn.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_dyn.c

$(OBJ_D)\eng_cryptodev.o: $(SRC_D)\crypto\engine\eng_cryptodev.c
	$(CC) -o $(OBJ_D)\eng_cryptodev.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_cryptodev.c

$(OBJ_D)\eng_padlock.o: $(SRC_D)\crypto\engine\eng_padlock.c
	$(CC) -o $(OBJ_D)\eng_padlock.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\engine\eng_padlock.c

$(OBJ_D)\ocsp_asn.o: $(SRC_D)\crypto\ocsp\ocsp_asn.c
	$(CC) -o $(OBJ_D)\ocsp_asn.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ocsp\ocsp_asn.c

$(OBJ_D)\ocsp_ext.o: $(SRC_D)\crypto\ocsp\ocsp_ext.c
	$(CC) -o $(OBJ_D)\ocsp_ext.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ocsp\ocsp_ext.c

$(OBJ_D)\ocsp_ht.o: $(SRC_D)\crypto\ocsp\ocsp_ht.c
	$(CC) -o $(OBJ_D)\ocsp_ht.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ocsp\ocsp_ht.c

$(OBJ_D)\ocsp_lib.o: $(SRC_D)\crypto\ocsp\ocsp_lib.c
	$(CC) -o $(OBJ_D)\ocsp_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ocsp\ocsp_lib.c

$(OBJ_D)\ocsp_cl.o: $(SRC_D)\crypto\ocsp\ocsp_cl.c
	$(CC) -o $(OBJ_D)\ocsp_cl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ocsp\ocsp_cl.c

$(OBJ_D)\ocsp_srv.o: $(SRC_D)\crypto\ocsp\ocsp_srv.c
	$(CC) -o $(OBJ_D)\ocsp_srv.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ocsp\ocsp_srv.c

$(OBJ_D)\ocsp_prn.o: $(SRC_D)\crypto\ocsp\ocsp_prn.c
	$(CC) -o $(OBJ_D)\ocsp_prn.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ocsp\ocsp_prn.c

$(OBJ_D)\ocsp_vfy.o: $(SRC_D)\crypto\ocsp\ocsp_vfy.c
	$(CC) -o $(OBJ_D)\ocsp_vfy.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ocsp\ocsp_vfy.c

$(OBJ_D)\ocsp_err.o: $(SRC_D)\crypto\ocsp\ocsp_err.c
	$(CC) -o $(OBJ_D)\ocsp_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ocsp\ocsp_err.c

$(OBJ_D)\ui_err.o: $(SRC_D)\crypto\ui\ui_err.c
	$(CC) -o $(OBJ_D)\ui_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ui\ui_err.c

$(OBJ_D)\ui_lib.o: $(SRC_D)\crypto\ui\ui_lib.c
	$(CC) -o $(OBJ_D)\ui_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ui\ui_lib.c

$(OBJ_D)\ui_openssl.o: $(SRC_D)\crypto\ui\ui_openssl.c
	$(CC) -o $(OBJ_D)\ui_openssl.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ui\ui_openssl.c

$(OBJ_D)\ui_util.o: $(SRC_D)\crypto\ui\ui_util.c
	$(CC) -o $(OBJ_D)\ui_util.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ui\ui_util.c

$(OBJ_D)\ui_compat.o: $(SRC_D)\crypto\ui\ui_compat.c
	$(CC) -o $(OBJ_D)\ui_compat.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\ui\ui_compat.c

$(OBJ_D)\krb5_asn.o: $(SRC_D)\crypto\krb5\krb5_asn.c
	$(CC) -o $(OBJ_D)\krb5_asn.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\krb5\krb5_asn.c

$(OBJ_D)\str_err.o: $(SRC_D)\crypto\store\str_err.c
	$(CC) -o $(OBJ_D)\str_err.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\store\str_err.c

$(OBJ_D)\str_lib.o: $(SRC_D)\crypto\store\str_lib.c
	$(CC) -o $(OBJ_D)\str_lib.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\store\str_lib.c

$(OBJ_D)\str_meth.o: $(SRC_D)\crypto\store\str_meth.c
	$(CC) -o $(OBJ_D)\str_meth.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\store\str_meth.c

$(OBJ_D)\str_mem.o: $(SRC_D)\crypto\store\str_mem.c
	$(CC) -o $(OBJ_D)\str_mem.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\store\str_mem.c

$(OBJ_D)\pqueue.o: $(SRC_D)\crypto\pqueue\pqueue.c
	$(CC) -o $(OBJ_D)\pqueue.o  $(LIB_CFLAGS) -c $(SRC_D)\crypto\pqueue\pqueue.c

$(OBJ_D)\e_4758cca.o: $(SRC_D)\engines\e_4758cca.c
	$(CC) -o $(OBJ_D)\e_4758cca.o  $(LIB_CFLAGS) -c $(SRC_D)\engines\e_4758cca.c

$(OBJ_D)\e_aep.o: $(SRC_D)\engines\e_aep.c
	$(CC) -o $(OBJ_D)\e_aep.o  $(LIB_CFLAGS) -c $(SRC_D)\engines\e_aep.c

$(OBJ_D)\e_atalla.o: $(SRC_D)\engines\e_atalla.c
	$(CC) -o $(OBJ_D)\e_atalla.o  $(LIB_CFLAGS) -c $(SRC_D)\engines\e_atalla.c

$(OBJ_D)\e_cswift.o: $(SRC_D)\engines\e_cswift.c
	$(CC) -o $(OBJ_D)\e_cswift.o  $(LIB_CFLAGS) -c $(SRC_D)\engines\e_cswift.c

$(OBJ_D)\e_gmp.o: $(SRC_D)\engines\e_gmp.c
	$(CC) -o $(OBJ_D)\e_gmp.o  $(LIB_CFLAGS) -c $(SRC_D)\engines\e_gmp.c

$(OBJ_D)\e_chil.o: $(SRC_D)\engines\e_chil.c
	$(CC) -o $(OBJ_D)\e_chil.o  $(LIB_CFLAGS) -c $(SRC_D)\engines\e_chil.c

$(OBJ_D)\e_nuron.o: $(SRC_D)\engines\e_nuron.c
	$(CC) -o $(OBJ_D)\e_nuron.o  $(LIB_CFLAGS) -c $(SRC_D)\engines\e_nuron.c

$(OBJ_D)\e_sureware.o: $(SRC_D)\engines\e_sureware.c
	$(CC) -o $(OBJ_D)\e_sureware.o  $(LIB_CFLAGS) -c $(SRC_D)\engines\e_sureware.c

$(OBJ_D)\e_ubsec.o: $(SRC_D)\engines\e_ubsec.c
	$(CC) -o $(OBJ_D)\e_ubsec.o  $(LIB_CFLAGS) -c $(SRC_D)\engines\e_ubsec.c

$(TEST_D)\md2test: $(OBJ_D)\md2test.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\md2test $(LFLAGS) $(OBJ_D)\md2test.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\md4test: $(OBJ_D)\md4test.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\md4test $(LFLAGS) $(OBJ_D)\md4test.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\md5test: $(OBJ_D)\md5test.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\md5test $(LFLAGS) $(OBJ_D)\md5test.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\shatest: $(OBJ_D)\shatest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\shatest $(LFLAGS) $(OBJ_D)\shatest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\sha1test: $(OBJ_D)\sha1test.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\sha1test $(LFLAGS) $(OBJ_D)\sha1test.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\sha256t: $(OBJ_D)\sha256t.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\sha256t $(LFLAGS) $(OBJ_D)\sha256t.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\sha512t: $(OBJ_D)\sha512t.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\sha512t $(LFLAGS) $(OBJ_D)\sha512t.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\hmactest: $(OBJ_D)\hmactest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\hmactest $(LFLAGS) $(OBJ_D)\hmactest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\rmdtest: $(OBJ_D)\rmdtest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\rmdtest $(LFLAGS) $(OBJ_D)\rmdtest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\destest: $(OBJ_D)\destest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\destest $(LFLAGS) $(OBJ_D)\destest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\rc2test: $(OBJ_D)\rc2test.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\rc2test $(LFLAGS) $(OBJ_D)\rc2test.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\rc4test: $(OBJ_D)\rc4test.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\rc4test $(LFLAGS) $(OBJ_D)\rc4test.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\ideatest: $(OBJ_D)\ideatest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\ideatest $(LFLAGS) $(OBJ_D)\ideatest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\bftest: $(OBJ_D)\bftest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\bftest $(LFLAGS) $(OBJ_D)\bftest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\casttest: $(OBJ_D)\casttest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\casttest $(LFLAGS) $(OBJ_D)\casttest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\bntest: $(OBJ_D)\bntest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\bntest $(LFLAGS) $(OBJ_D)\bntest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\exptest: $(OBJ_D)\exptest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\exptest $(LFLAGS) $(OBJ_D)\exptest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\rsa_test: $(OBJ_D)\rsa_test.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\rsa_test $(LFLAGS) $(OBJ_D)\rsa_test.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\dsatest: $(OBJ_D)\dsatest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\dsatest $(LFLAGS) $(OBJ_D)\dsatest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\dhtest: $(OBJ_D)\dhtest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\dhtest $(LFLAGS) $(OBJ_D)\dhtest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\ectest: $(OBJ_D)\ectest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\ectest $(LFLAGS) $(OBJ_D)\ectest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\ecdhtest: $(OBJ_D)\ecdhtest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\ecdhtest $(LFLAGS) $(OBJ_D)\ecdhtest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\ecdsatest: $(OBJ_D)\ecdsatest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\ecdsatest $(LFLAGS) $(OBJ_D)\ecdsatest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\randtest: $(OBJ_D)\randtest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\randtest $(LFLAGS) $(OBJ_D)\randtest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\evp_test: $(OBJ_D)\evp_test.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\evp_test $(LFLAGS) $(OBJ_D)\evp_test.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\enginetest: $(OBJ_D)\enginetest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\enginetest $(LFLAGS) $(OBJ_D)\enginetest.o $(L_LIBS) $(EX_LIBS)

$(TEST_D)\ssltest: $(OBJ_D)\ssltest.o $(LIBS_DEP)
	$(LINK) -o $(TEST_D)\ssltest $(LFLAGS) $(OBJ_D)\ssltest.o $(L_LIBS) $(EX_LIBS)

$(O_SSL): $(SSLOBJ)
	if exist $(O_SSL) $(RM) $(O_SSL)
	$(MKLIB) $(O_SSL) $(SSLOBJ)
	$(RANLIB) $(O_SSL)

$(O_CRYPTO): $(CRYPTOOBJ)
	if exist $(O_CRYPTO) $(RM) $(O_CRYPTO)
	$(MKLIB) $(O_CRYPTO) $(CRYPTOOBJ)
	$(RANLIB) $(O_CRYPTO)

$(BIN_D)\$(E_EXE): $(E_OBJ) $(LIBS_DEP)
	$(LINK) -o $(BIN_D)\$(E_EXE) $(LFLAGS) $(E_OBJ) $(L_LIBS) $(EX_LIBS)

