/****************************************************************************************
 * Copyright (c) 2010-2012, Takaya Kakizaki(kacky)
 * All rights reserved.

  \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏𖞂ꍇɌAĔЕzюgp܂B 

  E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 

  EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 

  Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔iɁAI[v̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB


  {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v񋟂ĂAَ킸A
  ƓIȎgp\Aѓ̖ړIɑ΂KɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂B
  쌠҂Rgr[^[AR̂킸A Q̌킸AӔC̍_ł邩iӔCł邩
  iߎ̑́js@sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂĂA{\tgEFA̎gpɂĔ
  i֕i܂͑pT[rX̒BAgp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳Ȃj
  ڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQɂāAؐӔC𕉂Ȃ̂Ƃ܂B 

****************************************************************************************/

#pragma once
#include <windows.h>
#include <float.h>
#include "MIPIface.h"

#define SIMULATECOUNT      (5000)

#define SCORE_KOUKEI_BIAS        (1.0)
#define SCORE_MENTSU_BIAS        (1.0)
#define SCORE_ANPAI              2 * (16)
#define SCORE_KIKENHAI           2 * (100)
#define SCORE_SUZI19             2 * (29)
#define SCORE_SUZI28             2 * (48)
#define SCORE_SUZI37             2 * (55)
#define SCORE_ZIHAI              2 * (34)
#define SCORE_19                 2 * (63)
#define SCORE_28                 2 * (70)
#define SCORE_37                 2 * (71)
#define SCORE_456                2 * (123)

#define SCORE_RIICHI_BIAS        (100.0) 
#define SCORE_IPPATSU_BIAS       (1000.0) 
#define SCORE_SUPAI_19           (0.079)
#define SCORE_SUPAI_28            (0.084)
#define SCORE_SUPAI_34567         (0.1)
#define SCORE_HANPAI_TRIPLE_BIAS (0.02)
#define SCORE_HANPAI_DOUBLE_BIAS (0.01)
#define SCORE_HANPAI_BIAS       (0.001)
#define SCORE_DORA_BIAS          (0.05)


typedef struct {
	double sc;
	int no;
} HAIPOINT;

typedef struct {
	MJITehai tehai;
	double nokori[34];
	double kikenhai[34];
	char anpai[34][4];
	char reach_flag[4];
	char ippatsu_flag[4];
	int te_cnt[34];
	int kyoku;
	int cha;
	int kaze;
	int tsumohai;
} MahjongAIState;

class MahjongScoreAI {
public:
	MahjongScoreAI(){}
	virtual ~MahjongScoreAI(){}
	static UINT (WINAPI *pMJSendMessage)(void*,UINT,UINT,UINT);
	static void *pObj;
	virtual double evalSutehai(MahjongAIState &param,HAIPOINT *result,int &size) {
		int i;
		double sc,sc_max = -DBL_MAX;

		size = 0;
		for(i=0;i<34;i++){
			if (param.te_cnt[i]){
				param.te_cnt[i]--;
				sc = evalSutehaiSub(param,i);
				result[size].sc = sc;
				result[size].no = i;
				
				if(sc > sc_max){
					sc_max = sc;
				}
				
				param.te_cnt[i]++;
				size++;
			}
			
		}

		return sc_max;
	}
	virtual double evalSutehaiSub(MahjongAIState &param,int hai){
		return 0.0;
	}

	virtual UINT getDebugInt(){
		return 0;
	}

	static UINT MJSendMessage(UINT p2,UINT p3,UINT p4){
		return (*pMJSendMessage)(pObj,p2,p3,p4);
	}
};

class MahjongAIType1 : public MahjongScoreAI {
public:
	double evalSutehaiSub(MahjongAIState &param,int hai);
};

class MahjongAIType2 : public MahjongScoreAI {
public:
	double evalSutehaiSub(MahjongAIState &param,int hai);
};

class MahjongAIType3 : public MahjongScoreAI {
public:
	double evalSutehaiSub(MahjongAIState &param,int hai);
};

class MahjongAIKikenhai : public MahjongScoreAI {
public:
	double evalSutehaiSub(MahjongAIState &param,int hai);
};

class MahjongAIType4 : public MahjongScoreAI {
public:
	double evalSutehaiSub(MahjongAIState &param,int hai);
	virtual UINT getDebugInt();
};
