# Copyright (c) 2010, Takaya Kakizaki(kacky)
# All rights reserved.
#
#  ソースコード形式かバイナリ形式か、変更するかしないかを問わず、以下の条件を満たす場合に限り、再頒布および使用が許可されます。 
#
#  ・ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、および下記免責条項を含めること。 
#
#  ・バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の資料に、上記の著作権表示、本条件一覧、および下記免責条項を含めること。 
#
#  ・書面による特別の許可なしに、本ソフトウェアから派生した製品の宣伝または販売促進に、オープン麻雀の名前またはコントリビューターの名前を使用してはならない。
#
#
#  本ソフトウェアは、著作権者およびコントリビューターによって「現状のまま」提供されており、明示黙示を問わず、
#  商業的な使用可能性、および特定の目的に対する適合性に関する暗黙の保証も含め、またそれに限定されない、いかなる保証もありません。
#  著作権者もコントリビューターも、事由のいかんを問わず、 損害発生の原因いかんを問わず、かつ責任の根拠が契約であるか厳格責任であるか
#  （過失その他の）不法行為であるかを問わず、仮にそのような損害が発生する可能性を知らされていたとしても、本ソフトウェアの使用によって発生した
#  （代替品または代用サービスの調達、使用の喪失、データの喪失、利益の喪失、業務の中断も含め、またそれに限定されない）
#  直接損害、間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害について、一切責任を負わないものとします。 
require "rexml/document"
require "rexml/encodings/ICONV"

module REXML::Encoding
  @encoding_methods.delete("ICONV")
end

# XMLをREXMLでもLibXMLでも使えるようにするラッパー(REXMLバージョン)
module CommonXML
  class Document
    def initialize(doc)
      @doc = doc
      @doc << REXML::XMLDecl.new("1.0","Shift-JIS")
    end
    
    def getRoot
      ele = Element.new(@doc.root)
      return ele
    end
    
    def add_element(str,attr_hash = nil)
      ele = Element.new(@doc.add_element(str,attr_hash))
      return ele
    end
    
    def toXML
      str = ""
      @doc.write(str)
      return str
    end
    
  end
  
  class Element
    
    def initialize(ele)
      @ele = ele
    end
    
    def Element.create(str)
      ele = Element.new(REXML::Element.new(str))
      return ele
    end
    
    def getTagName
      return @ele.name
    end
    
    def push(ele)
      @ele.push(ele.getObject)
    end
    
    def add_text(str)
      @ele.add_text(str)
    end
    
    def findFirstElement(xpath)
      if @ele.elements[xpath]
        ele = Element.new(@ele.elements[xpath])
      else
        ele = nil
      end
      
      return ele
    end
    
    def getNextSibling
      if @ele.next_sibling_node
        ele = Element.new(@ele.next_sibling_node)
      else
        ele = nil
      end
      
      return ele
    end
    
    def each_element(xpath)
      @ele.each_element(xpath) { |item|
        yield Element.new(item)
      }
    end
    
    def text
      return @ele.text
    end
    
    def text=(str)
      @ele.text = str
      return self
    end
    
    def copy
      ele = Element.new(@ele.clone)
      return ele
    end
    
    def add_element(str,attr_hash = nil)
      ele = Element.new(@ele.add_element(str,attr_hash))
      return ele
    end
    
    
    def add_attribute(key,val)
      @ele.add_attribute(key,val)
    end
    
    def get_attribute(key)
      return @ele.attribute(key)
    end
    
    protected
    def getObject
      return @ele
    end
    
  end
  
  def CommonXML.parseXML(str)
    doc = Document.new(REXML::Document.new(str))
    
    return doc
  end
  
  
  def CommonXML.createDocument
    doc = Document.new(REXML::Document.new)
    
    return doc
  end
end

