##
#	$Id: taku.rb 21 2008-11-16 18:27:54Z yatsuhashi $
#
module WxUI
  #
  class Taku < Wx::Panel
    WIDTH	= Hai::HEIGHT * 8 * 2
    TEHAI_TOP	= Vector[ -Hai::WIDTH * 7, Hai::HEIGHT * 7, 0 ]
    KAWA_TOP	= Vector[ -Hai::WIDTH * 3, Hai::HEIGHT * 3, 1 ]

    C		= WIDTH / 2
    MATRIX	= [ Matrix[ [ 1, 0, C ], [ 0, 1, C ], [ 0, 0, 1 ] ], 
                    Matrix[ [ 0, 1, C ], [ -1, 0, C ], [ 0, 0, 1 ] ], 
                    Matrix[ [ -1, 0, C ], [ 0, -1, C ], [ 0, 0, 1 ] ], 
                    Matrix[ [ 0, -1, C ], [ 1, 0, C ], [ 0, 0, 1 ] ] ]

    W		= Hai::WIDTH / 2
    H		= Hai::HEIGHT / 2
    OFFSET	= [ Vector[ -W, -H, 0 ], 
                    Vector[ -H, -W, 0 ], 
                    Vector[ -W, -H, 0 ], 
                    Vector[ -H, -W, 0 ] ]

    #
    def initialize(parent, main)
      @main = main
      super(parent, :size => Wx::Size.new(WIDTH, WIDTH))
      color = Wx::Colour.new(0, 128, 0)
      @pen = Wx::Pen.new(color)
      @brush = Wx::Brush.new(color)
      @buff = Wx::MemoryDC.new
      @buff.select_object(Wx::Bitmap.new(WIDTH, WIDTH))
      @dora = Array.new
      @select = nil

      evt_paint(:on_paint)
      evt_mouse_events { |event|
        index = nil
        if player = get_player(0)
          pos = Vector[ event.get_position.x, 
                        event.get_position.y, 1 ] - OFFSET[0]
          pos = MATRIX[0].inverse * pos - TEHAI_TOP
          if pos[0] >= 0 and pos[1] >= 0 and pos[1] < Hai::HEIGHT
            index = pos[0] / Hai::WIDTH
            unless player.hand[index]
              index = nil
            end
          end
        end
        if @select != index
          @select = index
          refresh
        end
        if event.right_down
          @main.pass
        elsif @select and event.left_down
          @main.select_hai(player.hand[@select], 
                           @select == player.hand.size - 1)
        end
      }
    end

    #
    def reset
      @dora.clear
    end

    #
    def append_dora(hai)
      @dora << hai
      update
    end

    #
    def update
      refresh(false)
    end

    private

    #
    def get_player(index)
      @main.client && @main.client.get_player(index)
    end

    #
    def on_paint
      @buff.set_pen(@pen)
      @buff.set_brush(@brush)
      @buff.draw_rectangle(0, 0, size.width, size.height)
      draw_dora
      4.times { |index|
        if player = get_player(index)
          draw_hand(@buff, index, player.hand)
        end
      }
      paint { |dc|
        dc.blit(0, 0, WIDTH, WIDTH, @buff, 0, 0)
      }
    end

    # ドラ表示
    def draw_dora
      x = WIDTH / 2 - (Hai::WIDTH * 2.5).to_i
      y = WIDTH / 2 - (Hai::HEIGHT * 1.5).to_i
      unless @dora.empty?
        @dora.each { |hai|
          Hai.draw(@buff, x, y, hai)
          x += Hai::WIDTH
        }
        (5 - @dora.size).times {
          Hai.draw(@buff, x, y, nil)
          x += Hai::WIDTH
        }
      end
    end

    # 手牌表示
    def draw_hand(dc, dir, hand)
      draw_kawa(dc, dir, hand)
      v = TEHAI_TOP.dup + Vector[0, 0, 1]
      a = Vector[ Hai::WIDTH, 0, 0 ]
      m = MATRIX[dir]
      i = 0
      hand.fusehai.times {
        pos = m * v + OFFSET[dir]
        Hai.draw(dc, pos[0], pos[1], nil, dir)
        v += a
        i += 1
      }
      hand.each_menzen { |hai|
        pos = m * v + OFFSET[dir]
        Hai.draw(dc, pos[0], 
                 pos[1] - (select?(dir, i) ? 1 : 0), 
                 hai, dir)
        v += a
        i += 1
      }
    end

    # 捨牌表示
    def draw_kawa(dc, dir, hand)
      v = KAWA_TOP.dup
      a = Vector[ Hai::WIDTH, 0, 0 ]
      m = MATRIX[dir]
      hand.kawa.each_with_index { |hai, i|
        pos = m * v + OFFSET[dir]
        Hai.draw(dc, pos[0], pos[1], hai, dir)
        v += a
        if i % 6 == 5
          v = Vector[ KAWA_TOP[0], v[1] + Hai::HEIGHT, 1 ]
        end
      }
    end

    #
    def select?(dir, i)
      dir == 0 and i == @select and @main.mode == :SUTEHAI
    end
  end
end
