##
#	$Id: umpsocket.rb 9 2008-10-07 19:11:28Z yatsuhashi $
#
require 'socket'
require 'uri'

module OpenMj
  class UMPSocket
    EOL		= "\r\n"

    #
    def initialize(socket)
      @socket = socket
    end

    #
    def self.open(host, port)
      self.new(TCPSocket.open(host, port))
    end

    #
    def send(*args)
      if @socket
        args.flatten!
        cmd = args.collect { |arg| URI.encode(arg.to_s) }.join(' ') + EOL
        begin
          while !cmd.empty?
            n = @socket.send(cmd, 0)
            cmd.slice!(0, n)
          end
        rescue Errno::EPIPE
          close
        end
      end
    end

    #
    def recv
      if @socket
        begin
          if buff = @socket.gets(EOL)
            buff.chomp!(EOL)
            buff.split.collect { |arg| URI.decode(arg) }
          end
        rescue Errno::ECONNRESET
          close
        end
      end
    end

    #
    def close
      if @socket
        @socket.close
        @socket = nil
      end
    end
  end
end
