/***********************************************************************//**
	@file
	$Revision$
	$Author$
	$Date::                           $
***************************************************************************/
#ifndef __LIBMAHJONG_HAI_H__
#define __LIBMAHJONG_HAI_H__

#include <bitset>
#include <string>

namespace mahjong {
/***********************************************************************//**
	牌.
***************************************************************************/
class Hai {
  public:
    /** 種別 */
    enum {
        COLOR_MANZU, 	/**< マンズ */
        COLOR_PINZU, 	/**< ピンズ */
        COLOR_SOUZU, 	/**< ソウズ */
        COLOR_ZIHAI, 	/**< 字牌 */
        COLOR_MAX
    };

    /** 比較関数オブジェクトクラス */
    struct CompareFunc {
        bool operator()(const Hai* a, const Hai* b) const;
    };

  private:
    enum {
        FLAG_DORA, 	/**< 赤ドラ */
        FLAG_MAX
    };

  public:
    int color;		/**< 種別 */
    int number;		/**< 数(1~9) */
  private:
    std::bitset<FLAG_MAX> flag_;
    char string_[3];

    static const char* COLORS;
    static bool isInitialized;
    static Hai instanceTable[COLOR_MAX][9][2];

  public:
    int compare(const Hai* hai) const;
    bool isSame(const Hai* hai) const;
    bool isEqual(const Hai* hai) const;

    bool isDora() const;
    bool isZihai() const;
    bool isYaochu() const;
    bool isSangenpai() const;
    bool isGreen() const;

    const char* toString() const;

    const Hai* succ(int add = 1) const;

    static const Hai* Get(const char* str);
    static const Hai* Get(const std::string& str);
    static const Hai* Get(int color, int number, bool isDora = false);
    static const Hai* Each(const Hai* hai);

  private:
    Hai() {}
    void set(int color, int number, bool isDora);
    static void Initialize();
};
/***********************************************************************//**
	$Id$
***************************************************************************/
}	/* namespace mahjong */
#endif	/* __LIBMAHJONG_HAI_H__ */
