/***********************************************************************//**
	@file
	$Revision: 73 $
	$Author: yatsuhashi $
	$Date:: 2009-03-20 03:07:24 +0900#$
***************************************************************************/
#ifndef __LIBMAHJONG_SUTEHAI_H__
#define __LIBMAHJONG_SUTEHAI_H__

#include <bitset>
#include "libmahjong/Hai.h"

namespace mahjong {
/***********************************************************************//**
	捨て牌.
***************************************************************************/
class Sutehai {
  private:
    enum {
        FLAG_TSUMOGIRI, 
        FLAG_NAKI, 
        FLAG_RICHI, 
        FLAG_MAX
    };

  private:
    const Hai* hai_;
    std::bitset<FLAG_MAX> flag_;

  public:
    Sutehai(const Hai* hai);

    const Hai* getHai() const;
    bool isTsumogiri() const;
    bool isNaki() const;
    bool isRichi() const;

    void setTsumogiri();
    void setNaki();
    void setRichi();
};
/***********************************************************************//**
	$Id: Sutehai.h 73 2009-03-19 18:07:24Z yatsuhashi $
***************************************************************************/
}	/* namespace mahjong */
#endif	/* __LIBMAHJONG_SUTEHAI_H__ */
