/***********************************************************************//**
	@file
	$Revision: 73 $
	$Author: yatsuhashi $
	$Date:: 2009-03-20 03:07:24 +0900#$
***************************************************************************/
#include <cppunit/BriefTestProgressListener.h>
#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestResultCollector.h>
#include <cppunit/TestRunner.h>
#include "HaiTest.h"
#include "HandTest.h"
#include "AgariTest.h"

CPPUNIT_TEST_SUITE_REGISTRATION(mahjong::HaiTest);
CPPUNIT_TEST_SUITE_REGISTRATION(mahjong::HandTest);
CPPUNIT_TEST_SUITE_REGISTRATION(mahjong::AgariTest);
/***********************************************************************//**
	
***************************************************************************/
int main(int argc, const char** argv) {
    CPPUNIT_NS::TestResult controller;
    CPPUNIT_NS::TestResultCollector result;
    controller.addListener(&result);

    CPPUNIT_NS::BriefTestProgressListener progress;
    controller.addListener(&progress);

    CPPUNIT_NS::TestRunner runner;
    runner.addTest(CPPUNIT_NS::TestFactoryRegistry::getRegistry().makeTest());
    runner.run(controller);

    CPPUNIT_NS::CompilerOutputter outputter(&result, CPPUNIT_NS::stdCOut());
    outputter.write();
  
    return result.wasSuccessful() ? 0 : 1;
}
/***********************************************************************//**
	$Id: test.cpp 73 2009-03-19 18:07:24Z yatsuhashi $
***************************************************************************/
