/***********************************************************************//**
	@file
	$Revision$
	$Author$
	$Date::                           $
***************************************************************************/
#ifndef __OPENMJ_GUI_MAINFRAME_H__
#define __OPENMJ_GUI_MAINFRAME_H__

#include "wxfbMain.h"
#include "Client.h"

namespace openmj {
namespace gui {
class Taku;
class ConsoleFrame;
class RecvCommand;
class Choice;
namespace preference {
class Dialog;
}
/***********************************************************************//**
	メインフレーム.
***************************************************************************/
class MainFrame : public wxfb::MainFrame {
    typedef wxfb::MainFrame super;

  public:
    enum {
        EVENT_UPDATE		= 1000, 
        EVENT_RECV_COMMAND, 
        EVENT_DISCONNECT
    };
    static const int BUTTON_MAX	= 5;
    enum {
        BUTTON_MODE_TSUMO, 
        BUTTON_MODE_NAKI
    };
    enum {
        BUTTON_KAN	= 1 << 0, 
        BUTTON_RICHI	= 1 << 2, 
        BUTTON_TSUMO	= 1 << 3, 
        BUTTON_OK	= 1 << 4, 

        //BUTTON_KAN	= 1 << 0, 
        BUTTON_PON	= 1 << 1, 
        BUTTON_CHI	= 1 << 2, 
        BUTTON_RON	= 1 << 3, 
        BUTTON_CANCEL	= 1 << 4
    };

  private:
    preference::Dialog* preferenceDialog;
    ConsoleFrame* consoleFrame;
    Client client;
    int buttonMode;
    wxString logBuff;
    mahjong::HaiArray canRichiHais;
    Choice* choice_;
    unsigned int serial_;

  public:
    MainFrame();
    virtual ~MainFrame();

    Client& getClient();

    void beginChoice(Choice* choice);

    void update();
    void log(const char* message);

    void recvCommand(const Command& command);

  protected:
    void enableButton(int mask, const wxChar** labelTable);
    void enableTsumoButton(int mask);
    void enableNakiButton(const Command* command);

    virtual void selectConnect(wxCommandEvent& event);
    virtual void selectPreference(wxCommandEvent& event);
    virtual void selectQuit(wxCommandEvent& event);
    virtual void showConsole(wxCommandEvent& event);

    virtual void onPaintTaku(wxPaintEvent& event);
    virtual void onMouseTaku(wxMouseEvent& event);

    virtual void onButton0(wxCommandEvent&);
    virtual void onButton1(wxCommandEvent&);
    virtual void onButton2(wxCommandEvent&);
    virtual void onButton3(wxCommandEvent&);
    virtual void onButton4(wxCommandEvent&);

    void onUpdate(wxEvent& event);
    void onRecvCommand(wxCommandEvent& event);
    void execKyokuStart();

    void endChoice();
};
/***********************************************************************//**
	$Id$
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
#endif	/* __OPENMJ_GUI_MAINFRAME_H__ */
