/***********************************************************************//**
	@file
	$Revision$
	$Author$
	$Date::                           $
***************************************************************************/
#include "Resource.h"
#include "Color.h"

namespace openmj {
namespace gui {

const Resource* Resource::instance = 0;
/***********************************************************************//**
	コンストラクタ.
***************************************************************************/
Resource::Resource()
    : image_(wxString::FromAscii("mjhai.png"))
{}
/***********************************************************************//**
	イメージを取得する
	@param	rect	範囲
	@param	rotate	向き
	@return		イメージ
***************************************************************************/
wxImage Resource::getImage(const wxRect& rect, int rotate) const {
    wxImage image = image_.GetSubImage(rect);
    for(int i = 0; i < rotate; i++) {
        image = image.Rotate90(false);
    }
    return image;
}
/***********************************************************************//**
	牌のイメージを取得する
	@param	hai	牌
	@param	rotate	向き
	@return		イメージ
***************************************************************************/
wxImage Resource::getHaiImage(const mahjong::Hai* hai, int rotate) const {
    wxRect rect((hai->number - 1) * HAI_WIDTH, 
                (hai->color + (hai->isDora() ? 4 : 0)) * HAI_HEIGHT, 
                HAI_WIDTH - 1, HAI_HEIGHT - 1);
    return getImage(rect, rotate);
}
/***********************************************************************//**
	ツモ切りマークのイメージを取得する
	@param	rotate	向き
	@return		イメージ
***************************************************************************/
wxImage Resource::getTsumogiriImage(int rotate) const {
    return getImage(wxRect(192, 304, 8, 8), rotate);
}
/***********************************************************************//**
	点棒のイメージを取得する
	@param	tenbou	点棒の種類
	@param	rotate	向き
	@return		点棒のイメージ
***************************************************************************/
wxImage Resource::getTenbouImage(int tenbou, int rotate) const {
    return getImage(wxRect(0, 304 + tenbou * 12, 96, 12), rotate);
}
/***********************************************************************//**
	インスタンス取得.
***************************************************************************/
const Resource* Resource::getInstance() {
    if(!instance) {
        instance = new Resource();
    }
    return instance;
}
/***********************************************************************//**
	$Id$
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
