
#include "G422.h"
#include "G422_MDL_DVC.h"
#include "G422_DVC.h"

//
// these are defined up front so we can automate their setup
//
VCSwitchDef VC_swDefs[VC_SWITCH_COUNT] = 
{
	{ MGID_SW3_GEAR,         SW3_MID,  _V(-0.100566, 2.24176, 38.9565),   _V(0.0, 2.23281, 38.9669), _V(1,0,0) }, 
	{ MGID_SW3_CANARD,       SW3_MID,  _V(-0.0795636, 2.24176, 38.9565),  _V(0.0, 2.23281, 38.9669), _V(1,0,0) },
	{ MGID_SW3_VISOR,        SW3_MID,  _V(-0.0607121, 2.24176, 38.9565),  _V(0.0, 2.23281, 38.9669), _V(1,0,0) },
	{ MGID_SW3_RCS,          SW3_MID,  _V(-0.0420616, 2.24176, 38.9565),  _V(0.0, 2.23281, 38.9669), _V(1,0,0) },
//	{ MGID_SW3_ANT,          SW3_MID,  _V(-0.0215225, 2.24176, 38.9565),  _V(0.0, 2.23281, 38.9669), _V(1,0,0) }, 
//	{ MGID_SW3_BAY,          SW3_MID,  _V(-0.00257892, 2.24176, 38.9565), _V(0.0, 2.23281, 38.9669), _V(1,0,0) },
//	{ MGID_SW3_RADIATOR,     SW3_MID,  _V( 0.0172208, 2.24176, 38.9565),  _V(0.0, 2.23281, 38.9669), _V(1,0,0) }, 
		
	{ MGID_SW3_EMAIN_IGN,     SW3_DOWN, _V(-0.0779257, 2.22507, 38.9223),  _V(-0.0883789, 2.21386, 38.9235),  _V(1,0,0) }, 
	{ MGID_SW3_EMAIN_MODE,    SW3_MID,  _V(-0.0779257, 2.21515, 38.866),   _V(-0.0786392, 2.20551, 38.8738),  _V(1,0,0) },
	{ MGID_SW3_EMAIN_REHEAT,  SW2_DOWN, _V(-0.0779257, 2.20629, 38.8118),  _V(-0.0786391, 2.19797, 38.818),   _V(1,0,0) }, 
	{ MGID_SW3_EMAIN_BRNRIGN, SW3_MID,  _V(-0.0779257, 2.20286, 38.7663),  _V(-0.0883789, 2.19042, 38.7696),  _V(1,0,0) }, 
	
	{ MGID_SW2_LGT_NAV,  SW2_DOWN, _V(-0.133736, 2.80125, 39.0016),      _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	{ MGID_SW2_LGT_STB,	 SW2_DOWN, _V(-0.112913, 2.80125, 39.0016),      _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  }, 
	{ MGID_SW2_LGT_BCN,  SW2_DOWN, _V(-0.0920897, 2.80125, 39.0016),     _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	{ MGID_SW2_LGT_LGR,	 SW2_DOWN, _V(-0.0712667, 2.80125, 39.0016),     _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	{ MGID_SW2_LGT_LND,  SW2_DOWN, _V(-0.0504438, 2.80125, 39.0016),     _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	{ MGID_SW2_LGT_TAX,  SW2_DOWN, _V(-0.0310962, 2.80125, 39.0016),     _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	{ MGID_SW2_LGT_DCK,  SW2_DOWN, _V(-0.0106556, 2.80125, 39.0016),     _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	{ MGID_SW2_LGT_BAY,  SW2_DOWN, _V(0.0101566, 2.80125, 39.0016),      _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	{ MGID_SW2_LGT_PNL,  SW2_DOWN, _V(0.0298633, 2.80125, 39.0016),      _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	{ MGID_SW2_LGT_FLD,  SW2_DOWN, _V(0.0492063, 2.80125, 39.0016),      _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	{ MGID_SW2_LGT_CSL,  SW2_DOWN, _V(0.069659, 2.80125, 39.0016),       _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	{ MGID_SW2_LGT_DOM,	 SW2_DOWN, _V(0.090846, 2.80125, 39.0016),       _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  }, 
	{ MGID_SW2_LGT_AMB,  SW2_DOWN, _V(0.11054, 2.80125, 39.0016),        _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	{ MGID_SW2_LGT_BRT,  SW2_DOWN, _V(0.131595, 2.80125, 39.0016),       _V(0.0, 2.80711, 39.0082), _V(-1,0,0)  },
	
	{ MGID_SW3_RAMX_DOOR,    SW3_MID,      _V(0.00537012, 2.19861, 38.714),   _V(0.0070939, 2.1843, 38.7142),   _X  }, 
	{ MGID_SW3_RAMX_IGN,	 SW3_DOWN,     _V(-0.0141052, 2.19861, 38.714),   _V(0.00817643, 2.1843, 38.7142),  _X  },
	{ MGID_SW3_RAMX_COOL,    SW3_DOWN,     _V(-0.0479365, 2.19632, 38.6961),  _V(-0.0543465, 2.18309, 38.6971), _X  }, 
	{ MGID_SW3_RAMX_MODE,    SW3_MID,      _V(0.037847, 2.19641, 38.6962),    _V(0.051995, 2.18318, 38.6972),   _X  }, 
	
	{ MGID_SW3_OXYFEED_L,    SW2_DOWN,     _V(-0.24636, 2.34541, 39.0663),   _V(-0.224714, 2.33551, 39.0747), _X  }, 
	{ MGID_SW3_OXYFEED_R,	 SW2_DOWN,     _V(-0.227356, 2.34541, 39.0663),  _V(-0.223978, 2.33551, 39.0747), _X  },
	
	{ MGID_SW3_STBYIGN_RCS,  SW2_DOWN,   _V(-0.243568, 2.37498, 39.0972),   _V(-0.223946, 2.36715, 39.1051), _X  }, 
	{ MGID_SW3_STBYIGN_OMS,  SW2_DOWN,   _V(-0.225541, 2.37498, 39.0972),   _V(-0.224312, 2.36715, 39.1051), _X  },  
	/*
	{ MGID_SW3_COOLDUMP_L,   SW3_MID,     _V(-0.243758, 2.37498, 39.0972),   _V(-0.221459, 2.36548, 39.1035),  _X  },
	{ MGID_SW3_COOLDUMP_R,   SW3_MID,     _V(-0.222301, 2.37498, 39.0972),   _V(-0.221825, 2.36548, 39.1035),  _X  },
	{ MGID_SW3_FCCOOL_INLT,  SW3_MID,     _V(-0.24317, 2.34541, 39.0663),    _V(-0.222228, 2.33485, 39.0739),    _X  },
	{ MGID_SW3_FCCOOL_AFRM,  SW3_MID,     _V(-0.221382, 2.34541, 39.0663),   _V(-0.221492, 2.33485, 39.0739),    _X  }, 
	*/
	{ MGID_SW2_MSFEED_L,	 SW2_DOWN,    _V(-0.190167, 2.3757, 39.0964),  _V(-0.167253, 2.36729, 39.1049),   _X  },
	{ MGID_SW2_MSFEED_C,     SW2_DOWN,    _V(-0.169738, 2.3757, 39.0964),  _V(-0.167613, 2.36729, 39.1049),   _X  },
	{ MGID_SW2_MSFEED_R,     SW2_DOWN,	  _V(-0.148361, 2.3757, 39.0964),  _V(-0.146685, 2.36729, 39.1049),   _X  },
	{ MGID_SW2_SYSFEED_OMS,  SW2_DOWN,	  _V(-0.188013, 2.34152, 39.0712),   _V(-0.167253, 2.33571, 39.0745),   _X  },
	{ MGID_SW2_SYSFEED_RCS,  SW2_DOWN,	  _V(-0.168275, 2.34152, 39.0712),   _V(-0.167613, 2.33571, 39.0745),  _X  },
	{ MGID_SW2_SYSFEED_APU,  SW2_DOWN,	  _V(-0.146898, 2.34152, 39.0712),   _V(-0.146685, 2.33571, 39.0745),  _X  },
	
	{ MGID_SW2_THR_AUTH,  SW2_UP,       _V(0.147331, 2.35039, 39.0752), _V(0.161479, 2.34303, 39.08),      _X  },
	{ MGID_SW2_BRKCOOL,   SW2_DOWN,     _V(0.473929, 2.35039, 39.0752), _V(0.488077, 2.34303, 39.08),      _X  }, 
		
	{ MGID_SW3_APU_CYCLE,  SW3_MID,    _V(-0.0427577, 2.18791, 38.6481),       _V(-0.0488396, 2.17608, 38.6452),     _X  }, 
	{ MGID_SW3_APU_COOL,  SW3_MID,    _V(-0.0230871, 2.18791, 38.6481),       _V(-0.0288296, 2.17608, 38.6452),     _X  },
	{ MGID_SW3_APU_EXHT,  SW3_MID,    _V(-0.00341636, 2.18791, 38.6481),     _V(-0.00912479, 2.17608, 38.6452),    _X  },
	{ MGID_SW2_APU_RAMX, SW2_DOWN,   _V(0.0377143, 2.18791, 38.6481),       _V(0.0312816, 2.17565, 38.6468),    _X  },
	{ MGID_SW3_APU_PACK_A, SW3_MID,    _V(-0.0440604, 2.18185, 38.6091),       _V(-0.0488121, 2.17154, 38.608),      _X  }, 
	{ MGID_SW3_APU_PACK_B, SW3_MID,    _V(-0.0243897, 2.18185, 38.6091),       _V(-0.0290738, 2.17154, 38.608),      _X  },
	{ MGID_SW3_APU_AC,    SW3_MID,    _V(-0.0235473, 2.18092, 38.5786),       _V(-0.031135, 2.16485, 38.576),       _X  }, 
	{ MGID_SW3_APU_BLEED, SW3_MID,	  _V(-0.00399457, 2.18092, 38.5786),     _V(-0.011125, 2.16485, 38.576),     _X	 },
	{ MGID_SW3_APU_HYD,   SW3_MID,	  _V(0.0145013, 2.18092, 38.5786),       _V(0.00857984, 2.16485, 38.576),    _X  },							
};



bool G422::clbkLoadVC(int id)
{

	SetCameraOffset (V3_VC_POV_PILOT);
	
	
	VECTOR3 vDir = _V(0.0, -.15, 1); normalise(vDir);
	SetCameraDefaultDirection(vDir);
	
	
	SetCameraRotationRange (RAD*80, RAD*80, RAD*80, RAD*55);
	SetCameraMovement( _V(0,-.05, 0.1), 0.0, -20*RAD,		_V(-0.20, -0.1, 0), 15*RAD, 45*RAD,		_V(0.15, -.02, 0), -35*RAD, 0);
	
	//
	//
	
	static VCHUDSPEC huds = {1, MGID_HUD, V3_HUD, 0.16};
	oapiVCRegisterHUD (&huds); // HUD parameters

	
	static VCMFDSPEC mfds_1 = {1,MGID_MFD_1};
	static VCMFDSPEC mfds_2 = {1,MGID_MFD_2};
	static VCMFDSPEC mfds_3 = {1,MGID_MFD_3};
	static VCMFDSPEC mfds_4 = {1,MGID_MFD_4};	
	oapiVCRegisterMFD (MFD_LEFT,  &mfds_1);
	oapiVCRegisterMFD (MFD_RIGHT, &mfds_2);
	oapiVCRegisterMFD (MFD_USER1, &mfds_3);
	oapiVCRegisterMFD (MFD_USER2, &mfds_4);	
	
	
	static VCMFDSPEC mfds_5 = {1,MGID_MFD_5};
	static VCMFDSPEC mfds_6 = {1,MGID_MFD_6};	
	oapiVCRegisterMFD (MFD_USER3, &mfds_5);
	oapiVCRegisterMFD (MFD_USER4, &mfds_6);	
	
	
	HBITMAP loadSurfBmp = LoadBitmap(thisDLL, MAKEINTRESOURCE(BMP_EICAS_SRC));
	
	if (loadSurfBmp == NULL) MessageBox(GetTopWindow(NULL), "Load EicasSrc Bitmap FAIL!", "FAIL!", MB_ICONERROR | MB_OK);
	vcRes_eicasSrc = oapiCreateSurface( loadSurfBmp );
	
	//
	
	
	
	//
	//
	/*
	oapiOpenMFD(MFD_HSI,     MFD_LEFT);
	oapiOpenMFD(MFD_ORBIT,   MFD_RIGHT);
	oapiOpenMFD(MFD_SURFACE, MFD_USER1);
	oapiOpenMFD(MFD_MAP,     MFD_USER2);	*/
	//
	//
	
	
//	vcRsc_rckt_tape = oapiCreateSurface(LOADBMP(IDB_ROCKETTAPE));
	
	
	
	
	

	//
	
	// start loading up our control sets...
	// 
	int i;

	static const VECTOR3 mfdKeyPositions[72] = {
		_V(0.135131, 2.50137, 39.1634), // VC_MFD1_KEY001
		_V(0.135145, 2.4859, 39.157),   // VC_MFD1_KEY002
		_V(0.13516, 2.47043, 39.1506),  // VC_MFD1_KEY003
		_V(0.135174, 2.45496, 39.1442), // VC_MFD1_KEY004
		_V(0.135189, 2.4395, 39.1377),  // VC_MFD1_KEY005
		_V(0.135203, 2.42403, 39.1313), // VC_MFD1_KEY006
		_V(0.261502, 2.50092, 39.1635), // VC_MFD1_KEY007
		_V(0.261517, 2.48545, 39.1571), // VC_MFD1_KEY008
		_V(0.261531, 2.46998, 39.1507), // VC_MFD1_KEY009
		_V(0.261546, 2.45452, 39.1442), // VC_MFD1_KEY010
		_V(0.26156, 2.43905, 39.1378),  // VC_MFD1_KEY011
		_V(0.261789, 2.42362, 39.1314), // VC_MFD1_KEY012

		_V(0.421107, 2.50137, 39.1634), // VC_MFD2_KEY001
		_V(0.421121, 2.4859, 39.157),   // VC_MFD2_KEY002
		_V(0.421135, 2.47043, 39.1506), // VC_MFD2_KEY003
		_V(0.42115, 2.45496, 39.1442),  // VC_MFD2_KEY004
		_V(0.421164, 2.4395, 39.1377),  // VC_MFD2_KEY005
		_V(0.421179, 2.42403, 39.1313), // VC_MFD2_KEY006
		_V(0.547478, 2.50137, 39.1637), // VC_MFD2_KEY007
		_V(0.547492, 2.4859, 39.1573),  // VC_MFD2_KEY008
		_V(0.547507, 2.47043, 39.1509), // VC_MFD2_KEY009
		_V(0.547521, 2.45496, 39.1444), // VC_MFD2_KEY010
		_V(0.547536, 2.4395, 39.138),   // VC_MFD2_KEY011
		_V(0.54755, 2.42403, 39.1316),  // VC_MFD2_KEY012

		_V(0.280804, 2.50137, 39.1634), // VC_MFD3_KEY001
		_V(0.280819, 2.4859, 39.157),   // VC_MFD3_KEY002
		_V(0.280833, 2.47043, 39.1506), // VC_MFD3_KEY003
		_V(0.280848, 2.45496, 39.1442), // VC_MFD3_KEY004
		_V(0.280862, 2.4395, 39.1377),  // VC_MFD3_KEY005
		_V(0.280877, 2.42403, 39.1313), // VC_MFD3_KEY006
		_V(0.404135, 2.50137, 39.1637), // VC_MFD3_KEY007
		_V(0.404149, 2.4859, 39.1573),  // VC_MFD3_KEY008
		_V(0.404164, 2.47043, 39.1509), // VC_MFD3_KEY009
		_V(0.404178, 2.45496, 39.1444), // VC_MFD3_KEY010
		_V(0.404193, 2.4395, 39.138),   // VC_MFD3_KEY011
		_V(0.404207, 2.42403, 39.1316), // VC_MFD3_KEY012

		_V(0.282001, 2.37975, 39.0916), // VC_MFD4_KEY001
		_V(0.282001, 2.36851, 39.0803), // VC_MFD4_KEY002
		_V(0.282001, 2.35776, 39.0672), // VC_MFD4_KEY003
		_V(0.282001, 2.34665, 39.0541), // VC_MFD4_KEY004
		_V(0.282001, 2.33596, 39.0412), // VC_MFD4_KEY005
		_V(0.282001, 2.32634, 39.0301), // VC_MFD4_KEY006
		_V(0.404227, 2.37954, 39.0914), // VC_MFD4_KEY007
		_V(0.404227, 2.3688, 39.0782),  // VC_MFD4_KEY008
		_V(0.404227, 2.35768, 39.0651), // VC_MFD4_KEY009
		_V(0.404227, 2.347, 39.0523),   // VC_MFD4_KEY010
		_V(0.404227, 2.33738, 39.0412), // VC_MFD4_KEY011
		_V(0.404227, 2.32583, 39.029),  // VC_MFD4_KEY012
		
		_V(-0.481395, 2.50291, 39.1634), /* VC_MFD5_KEY001 */
		_V(-0.481395, 2.48707, 39.156),  /* VC_MFD5_KEY002 */
		_V(-0.481395, 2.47236, 39.1504), /* VC_MFD5_KEY003 */
		_V(-0.481395, 2.45652, 39.1448), /* VC_MFD5_KEY004 */
		_V(-0.481395, 2.44035, 39.1384), /* VC_MFD5_KEY005 */
		_V(-0.481395, 2.42521, 39.1304), /* VC_MFD5_KEY006 */
		_V(-0.354229, 2.50283, 39.1648), /* VC_MFD5_KEY007 */
		_V(-0.354229, 2.48813, 39.1592), /* VC_MFD5_KEY008 */
		_V(-0.354229, 2.47229, 39.1536), /* VC_MFD5_KEY009 */
		_V(-0.354229, 2.45612, 39.1472), /* VC_MFD5_KEY010 */
		_V(-0.354229, 2.44098, 39.1391), /* VC_MFD5_KEY011 */
		_V(-0.354229, 2.42543, 39.1337), /* VC_MFD5_KEY012 */

		_V(-0.333415, 2.50291, 39.1634), /* VC_MFD6_KEY001 */
		_V(-0.333415, 2.4881, 39.1569),  /* VC_MFD6_KEY002 */
		_V(-0.333415, 2.4735, 39.1505),  /* VC_MFD6_KEY003 */
		_V(-0.333415, 2.45717, 39.1435), /* VC_MFD6_KEY004 */
		_V(-0.333415, 2.44076, 39.1368), /* VC_MFD6_KEY005 */
		_V(-0.333415, 2.42569, 39.1323), /* VC_MFD6_KEY006 */
		_V(-0.206249, 2.5023, 39.1657),  /* VC_MFD6_KEY007 */
		_V(-0.206249, 2.48712, 39.1592), /* VC_MFD6_KEY008 */
		_V(-0.206249, 2.47104, 39.1523), /* VC_MFD6_KEY009 */
		_V(-0.206249, 2.45517, 39.1455), /* VC_MFD6_KEY010 */
		_V(-0.206249, 2.44066, 39.141),  /* VC_MFD6_KEY011 */
		_V(-0.206249, 2.42543, 39.1337), /* VC_MFD6_KEY012 */

	};
	
	for (i = 0; i<72; ++i)
	{
		oapiVCRegisterArea((VC_CTRLSET_MFDK << 16) | (i & 0xFFFF), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN | PANEL_MOUSE_LBPRESSED | PANEL_MOUSE_LBUP, PANEL_MAP_NONE, NULL);
		oapiVCSetAreaClickmode_Spherical((VC_CTRLSET_MFDK << 16) | (i & 0xFFFF), mfdKeyPositions[i], .02);
	}
	
	
	

	static const VECTOR3 mfdCtrlPositions[18] = 
	{
		_V(0.159698, 2.40178, 39.1252), // VC_MFD1_SEL
		_V(0.197101, 2.40178, 39.1252), // VC_MFD1_PWR
		_V(0.234524, 2.40178, 39.1252), // VC_MFD1_MNU
		
		_V(0.450944, 2.40178, 39.1252), // VC_MFD2_SEL
		_V(0.488347, 2.40178, 39.1252), // VC_MFD2_PWR
		_V(0.52577, 2.40178, 39.1252),  // VC_MFD2_MNU
		
		_V(0.305624, 2.40178, 39.1252), // VC_MFD3_SEL
		_V(0.343027, 2.40178, 39.1252), // VC_MFD3_PWR
		_V(0.38045, 2.40178, 39.1252),  // VC_MFD3_MNU
		
		_V(0.305624, 2.30991, 39.0084), // VC_MFD4_SEL
		_V(0.343027, 2.30991, 39.0084), // VC_MFD4_PWR
		_V(0.3761, 2.30991, 39.0084),   // VC_MFD4_MNU
		
		_V(-0.454807, 2.40178, 39.1252), /* VC_MFD5_SEL */
		_V(-0.417757, 2.40178, 39.1252), /* VC_MFD5_PWR */
		_V(-0.380753, 2.40178, 39.1252), /* VC_MFD5_MNU */

		_V(-0.308079, 2.40178, 39.1252), /* VC_MFD6_SEL */
		_V(-0.271129, 2.40178, 39.1252), /* VC_MFD6_PWR */
		_V(-0.233325, 2.40178, 39.1252), /* VC_MFD6_MNU */
	};
	
	for (i = 0; i<18; ++i)
	{
		oapiVCRegisterArea((VC_CTRLSET_MFDC << 16) | (i & 0xFFFF), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
		oapiVCSetAreaClickmode_Spherical((VC_CTRLSET_MFDC << 16) | (i & 0xFFFF), mfdCtrlPositions[i], .02);
	};
	
	//
	//
	
	
	vcTex_mfds = oapiGetTextureHandle(mdl_dvc, TEX_MFDKEYS);
	oapiVCRegisterArea(VC_AREA_MFDKEYS, _R(0,0,512, 512), PANEL_REDRAW_USER, PANEL_MOUSE_IGNORE, PANEL_MAP_BACKGROUND, vcTex_mfds);

	vcTex_eicas = oapiGetTextureHandle(mdl_dvc, TEX_EICAS);
	oapiVCRegisterArea(VC_AREA_EICAS_ALL,   _R(0,0,1024, 1024), PANEL_REDRAW_ALWAYS, PANEL_MOUSE_IGNORE, PANEL_MAP_BACKGROUND, vcTex_eicas);
	
	
	//vcRsc_reht_tape = oapiCreateSurface(LOADBMP(BMP_RHTTAPE));
	
	
	//
	//
	

	// alright, let's rock - commence primary VC switch buildup (we've lots of those)
	//
	for (i = 0; i<VC_SWITCH_COUNT; ++i)
	{
		//
		oapiVCRegisterArea(( VC_CTRLSET_SWITCHES << 16) | (i & 0xFFFF), _R(0,0,0,0), 
			PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN | PANEL_MOUSE_RBDOWN | PANEL_MOUSE_LBUP | PANEL_MOUSE_RBUP, PANEL_MAP_NONE, NULL);
			
		oapiVCSetAreaClickmode_Spherical(( VC_CTRLSET_SWITCHES << 16) | (i & 0xFFFF), VC_swDefs[i].refPos, .03);
		
	};
	
	//
	//
	
	// we're not out of the woods yet... there's more stuff in there than just the switches....
	
	// clicking around the pilot or engineer's head acts same as the TAB key
	//
	oapiVCRegisterArea((VC_CTRLSET_MOVESEAT << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Spherical((VC_CTRLSET_MOVESEAT << 16), _V(-1, 2.25,  38.7), .6);


	// wing position lever
	//
	oapiVCRegisterArea((VC_CTRLSET_WPOSLVR << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN | PANEL_MOUSE_RBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Spherical((VC_CTRLSET_WPOSLVR << 16), V3_VC_WPOS_MID, .035);
	
	
	
	
	
	// eicas mode select keys
	//
	
	oapiVCRegisterArea((VC_CTRLSET_EICAS_C1 << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Quadrilateral((VC_CTRLSET_EICAS_C1 << 16), V3_VC_EICAS_SELECT_C1_A, V3_VC_EICAS_SELECT_C1_B, V3_VC_EICAS_SELECT_C1_C, V3_VC_EICAS_SELECT_C1_D);
	
	oapiVCRegisterArea((VC_CTRLSET_EICAS_C2 << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Quadrilateral((VC_CTRLSET_EICAS_C2 << 16), V3_VC_EICAS_SELECT_C2_A, V3_VC_EICAS_SELECT_C2_B, V3_VC_EICAS_SELECT_C2_C, V3_VC_EICAS_SELECT_C2_D);
	
	oapiVCRegisterArea((VC_CTRLSET_EICAS_P1L << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Quadrilateral((VC_CTRLSET_EICAS_P1L << 16), V3_VC_EICAS_SELECT_P1L_A, V3_VC_EICAS_SELECT_P1L_B, V3_VC_EICAS_SELECT_P1L_C, V3_VC_EICAS_SELECT_P1L_D);
	oapiVCRegisterArea((VC_CTRLSET_EICAS_P1R << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Quadrilateral((VC_CTRLSET_EICAS_P1R << 16), V3_VC_EICAS_SELECT_P1R_A, V3_VC_EICAS_SELECT_P1R_B, V3_VC_EICAS_SELECT_P1R_C, V3_VC_EICAS_SELECT_P1R_D);
	
	oapiVCRegisterArea((VC_CTRLSET_EICAS_P2L << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Quadrilateral((VC_CTRLSET_EICAS_P2L << 16), V3_VC_EICAS_SELECT_P2L_A, V3_VC_EICAS_SELECT_P2L_B, V3_VC_EICAS_SELECT_P2L_C, V3_VC_EICAS_SELECT_P2L_D);
	oapiVCRegisterArea((VC_CTRLSET_EICAS_P2R << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Quadrilateral((VC_CTRLSET_EICAS_P2R << 16), V3_VC_EICAS_SELECT_P2R_A, V3_VC_EICAS_SELECT_P2R_B, V3_VC_EICAS_SELECT_P2R_C, V3_VC_EICAS_SELECT_P2R_D);

	oapiVCRegisterArea((VC_CTRLSET_EICAS_E1L << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Quadrilateral((VC_CTRLSET_EICAS_E1L << 16), V3_VC_EICAS_SELECT_E1L_A, V3_VC_EICAS_SELECT_E1L_B, V3_VC_EICAS_SELECT_E1L_C, V3_VC_EICAS_SELECT_E1L_D);
	oapiVCRegisterArea((VC_CTRLSET_EICAS_E1R << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Quadrilateral((VC_CTRLSET_EICAS_E1R << 16), V3_VC_EICAS_SELECT_E1R_A, V3_VC_EICAS_SELECT_E1R_B, V3_VC_EICAS_SELECT_E1R_C, V3_VC_EICAS_SELECT_E1R_D);

	oapiVCRegisterArea((VC_CTRLSET_EICAS_E2L << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Quadrilateral((VC_CTRLSET_EICAS_E2L << 16), V3_VC_EICAS_SELECT_E2L_A, V3_VC_EICAS_SELECT_E2L_B, V3_VC_EICAS_SELECT_E2L_C, V3_VC_EICAS_SELECT_E2L_D);
	oapiVCRegisterArea((VC_CTRLSET_EICAS_E2R << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Quadrilateral((VC_CTRLSET_EICAS_E2R << 16), V3_VC_EICAS_SELECT_E2R_A, V3_VC_EICAS_SELECT_E2R_B, V3_VC_EICAS_SELECT_E2R_C, V3_VC_EICAS_SELECT_E2R_D);
	
	
	// eicas power/brt knobs
	//

	

	oapiVCRegisterArea(( VC_CTRLSET_EICAS_PWR << 16), _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN | PANEL_MOUSE_RBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Spherical(( VC_CTRLSET_EICAS_PWR << 16), V3_VC_EICAS_BTRPWR_C1, .018);
	oapiVCRegisterArea(( VC_CTRLSET_EICAS_PWR << 16) | 1, _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN | PANEL_MOUSE_RBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Spherical(( VC_CTRLSET_EICAS_PWR << 16) | 1, V3_VC_EICAS_BTRPWR_C2, .018);
	
	oapiVCRegisterArea(( VC_CTRLSET_EICAS_PWR << 16) | 2, _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN | PANEL_MOUSE_RBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Spherical(( VC_CTRLSET_EICAS_PWR << 16) | 2, V3_VC_EICAS_BTRPWR_P1, .018);
	oapiVCRegisterArea(( VC_CTRLSET_EICAS_PWR << 16) | 3, _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN | PANEL_MOUSE_RBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Spherical(( VC_CTRLSET_EICAS_PWR << 16) | 3 , V3_VC_EICAS_BTRPWR_P2, .018);
	
	oapiVCRegisterArea(( VC_CTRLSET_EICAS_PWR << 16) | 4,      _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN | PANEL_MOUSE_RBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Spherical(( VC_CTRLSET_EICAS_PWR << 16) | 4,     V3_VC_EICAS_BTRPWR_E1, .018);
	oapiVCRegisterArea(( VC_CTRLSET_EICAS_PWR << 16) | 5, _R(0,0,0,0), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN | PANEL_MOUSE_RBDOWN, PANEL_MAP_NONE, NULL);
	oapiVCSetAreaClickmode_Spherical(( VC_CTRLSET_EICAS_PWR << 16) | 5, V3_VC_EICAS_BTRPWR_E2, .018);


	
	
	//
	//
	return true;
}







