

struct EPVERTEX {                          
    float3 posL     : POSITION0;
    float2 tex0     : TEXCOORD0;
};

struct ParticleVS
{
    float4 posH     : POSITION0;
    float2 tex0     : TEXCOORD0;
    float3 nrmL     : TEXCOORD1;
};

ParticleVS ParticleDiffuseVS(NTVERTEX vrt)
{
	ParticleVS outVS = (ParticleVS)0;
	outVS.tex0    = vrt.tex0;
    outVS.nrmL    = vrt.nrmL;
	outVS.posH    = mul(float4(vrt.posL, 1.0f), gVP);
    return outVS;
}

ParticleVS ParticleEmissiveVS(EPVERTEX vrt)
{
	ParticleVS outVS = (ParticleVS)0;
	outVS.tex0   = vrt.tex0;
	outVS.posH   = mul(float4(vrt.posL, 1.0f), gVP);
    return outVS;
}

float4 ParticleDiffusePS(ParticleVS frg) : COLOR
{
	float d = max(dot(-gSun.direction, normalize(frg.nrmL)), 0.05f);
    float4 color = tex2D(WrapS, frg.tex0);
    return float4(color.rgb*gMat.diffuse.rgb*color.a, gMat.diffuse.a*color.a);  
}


float4 ParticleEmissivePS(ParticleVS frg) : COLOR
{
    float4 color = tex2D(WrapS, frg.tex0);
    return float4(color.rgb*gMat.emissive.rgb, gMat.diffuse.a*color.a);
}

float4 ParticleShadowPS(ParticleVS frg) : COLOR
{
    float4 color = tex2D(WrapS, frg.tex0);
    return float4(0,0,0,color.a*gMix);
}

technique ParticleDiffuseTech
{
    pass P0
    {
        vertexShader = compile VS_MOD ParticleDiffuseVS();
        pixelShader  = compile PS_MOD ParticleDiffusePS();

        AlphaBlendEnable = true;
        BlendOp = Add;
        ZEnable = true; 
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;    
        ZWriteEnable = false;
    }
}

technique ParticleEmissiveTech
{
    pass P0
    {
        vertexShader = compile VS_MOD ParticleEmissiveVS();
        pixelShader  = compile PS_MOD ParticleEmissivePS();

        AlphaBlendEnable = true;
        BlendOp = Add;
        ZEnable = true; 
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;    
        ZWriteEnable = false;
    }

    pass P1
    {
        vertexShader = compile VS_MOD ParticleEmissiveVS();
        pixelShader  = compile PS_MOD ParticleShadowPS();

        AlphaBlendEnable = true;
        BlendOp = Add;
        ZEnable = true; 
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;    
        ZWriteEnable = false;
    }
}