struct vsIN {
	float2 PosL : POSITION;
	float2 Texc : TEXCOORD;
};

struct vsOUT {
	float4 PosH : SV_POSITION;
	float2 Texc : TEXCOORD;
};

cbuffer cbTransform : register( b0 )
{
	matrix WVO;
};

cbuffer cbColorKey : register( b1 )
{
	float4 ckey;
};
/*
type:
0.0 fill color
1.0f render with color key
*/
Texture2D Diffuse : register( t0 );
SamplerState Linear : register( s0 );

vsOUT VSBlit( vsIN In ) {
	vsOUT Out;
	Out.PosH = mul( float4( In.PosL, 0.0f, 1.0f ), WVO );
	Out.Texc = In.Texc;
	return Out;
}

float4 PSBlit( vsOUT In ) : SV_Target
{
	float4 result = Diffuse.Sample( Linear, In.Texc );
	[branch]
	if( ckey.a < 1.5f ) {
		float res = result.r - ckey.r + result.g - ckey.g + result.b - ckey.b;
		clip( abs(res) - 0.05f );
		result.a = 0.0f;
	}
	[branch]
	if( ckey.a > 2.5f )
		result.a = 0.0f;
	return result;
}