struct CVERTEX {
	float3 PosL		: POSITION;
	float Color		: COLOR0;
};

struct VSOut {
	float4 PosH		: SV_POSITION;
	float Color		: COLOR0;
};

cbuffer cb_VS_Star_Line		: register( b0 )
{
	row_major matrix WVP;	//64
};

VSOut VS_Star_Line( CVERTEX In ) {
	VSOut Out;
	Out.PosH = mul( float4( In.PosL, 1.0f ), WVP );
	Out.Color = In.Color;
	return Out;
}

float4 PS_Star( VSOut In ) : SV_Target
{
	return float4( In.Color, In.Color, In.Color, 1.0f );
}

cbuffer cb_PS_Line	: register( b1 )
{
	float4 cColor;			//16
};

float4 PS_Line( VSOut In ) : SV_Target
{
	return cColor;
}