struct SPAD_VERTEX {
	float3 PosL		: POSITION;
};

struct VSOut {
	float4 PosH		: SV_POSITION;
	float TCrd		: TEXCOORD;
};

cbuffer cb_VS		: register( b0 )
{
	row_major matrix VP;	//64
	float4 cData;			//80
};

VSOut VS_Ellipse( SPAD_VERTEX In ) {
	VSOut Out;
	Out.PosH = mul( float4( cData.x + In.PosL.x*cData.z, cData.y + In.PosL.y*cData.w, 0.0f, 1.0f ), VP );
	Out.TCrd = In.PosL.z*0.13f;
	return Out;
}

VSOut VS_WideRect( SPAD_VERTEX In ) {
	VSOut Out;
	Out.PosH = mul( float4( cData.x + In.PosL.x*cData.z + In.PosL.z*In.PosL.x, cData.y + In.PosL.y*cData.w + In.PosL.z*In.PosL.y, 0.0f, 1.0f ), VP );
	Out.TCrd = 0.0f;
	return Out;
}

VSOut VS_Line( SPAD_VERTEX In ) {
	VSOut Out;
	Out.PosH = mul( float4( In.PosL.xy, 0.0f, 1.0f ), VP );
	Out.TCrd = In.PosL.z*0.13f;
	return Out;
}

VSOut VS_Fill( SPAD_VERTEX In ) {
	VSOut Out;
	Out.PosH = mul( float4( In.PosL.xy, 0.5f, 1.0f ), VP );
	Out.TCrd = 0.0f;
	return Out;
}

cbuffer cb_PS		: register( b0 )
{
	float4 cColor;
	uint cDash;
	float3 no_data;
};

float4 PS_Draw( VSOut In )		: SV_Target
{
	[branch]
	if( cDash == 1 ) {
		float q;
		[branch]
		if( modf( In.TCrd, q ) > 0.5f )
			return cColor;
		clip( -1 );
	}
	return float4( cColor.rgb, 1.0f );
}

float4 PS_Fill( VSOut In )		: SV_Target
{
	return float4( cColor.rgb, 1.0f );
}