struct TEXTVERTEX {
	float2 PosL		: POSITION;
	float2 TCrd		: TEXCOORD;
};

struct VSOut {
	float4 PosH		: SV_POSITION;
	float2 TCrd		: TEXCOORD;
};

cbuffer cb_VS_Font	: register( b0 )
{
	row_major matrix VP;
};

VSOut VS_Fill_Font( TEXTVERTEX In ) {
	VSOut Out;
	Out.PosH = mul( float4( In.PosL, 0.5f, 1.0f ), VP );
	Out.TCrd = In.TCrd;
	return Out;
}

cbuffer cb_PS_Box	: register( b1 )
{
	float4 cColor;
};

Texture2D		FontTex		: register( t0 );
SamplerState	FontSampler	: register( s0 );

float4 PS_Fill( VSOut In )	: SV_Target
{
	return cColor;
}

float4 PS_Font( VSOut In )	: SV_Target
{
	float4 color = FontTex.Sample( FontSampler, In.TCrd );
	return float4( cColor.rgb*color.rgb, color.r*1.0f );//color.r*cColor.a );
}