struct MESH_VERTEX {
	float3 PosL		: POSITION;
	float3 NormL	: NORMAL;
	float3 TangL	: TANGENT;
	float2 TCrd		: TEXCOORD;
};

struct VSOut {
	float4 PosH		: SV_POSITION;
	float3 CamW		: TEXCOORD0;
	half3 NormW		: TEXCOORD1;
	half2 TCrd		: TEXCOORD2;
	half4 atten		: COLOR0;
	half4 insca		: COLOR1;
};

//use constant buffer remained from SurfManager::Render()
cbuffer cb_VS_BaseTile_per_frame		: register( b0 )
{
	row_major matrix VP;	//64
	uint cHazeMode;
	float3 cFogColor;		//80

	float3 cSunDir;
	float cSunAppRad;		//96

	float cAmbient0;
	float cGlobalAmb;
	float cFogDensity;
	float cDispersion;		//112
};

cbuffer cb_VS_BaseTile		: register( b1 )
{
	row_major matrix W;
};

void LegacySunColor( out half4 diff, out float ambi, out float nigh, in float3 NormW ) {
	float h = dot( -cSunDir, NormW );
	float3 r0 = 1.0f - float3( 0.4f, 0.65f, 1.0f )*cDispersion;

	if( cDispersion != 0.0 ) {	// case 1: planet has atmosphere
		float3 di = (r0 + (1.0 - r0)*saturate( h*5.780 ))*saturate( (h + cSunAppRad)/(2.0*cSunAppRad) );
		float ni = (h + 0.242)*2.924;
		float am = saturate( max( cAmbient0*saturate( ni ) - 0.05, cGlobalAmb ) );

		diff = float4( di*(1.0 - am*0.5), 1 );
		ambi = am;
		nigh = saturate( -ni - 0.2 );
	}
	else {	// case 2: planet has no atmosphere
		diff = float4( r0*saturate( (h + cSunAppRad)/(2.0f*cSunAppRad) ), 1 );
		ambi = cGlobalAmb;
		nigh = 0;
	}
}

void AtmosphericHaze( out half4 att, out half4 ins, in float dp ) {
	[branch]
	if( cHazeMode == 0 ) {
		att = 1;
		ins = 0;
		return;
	}
	else {
		float fogFact = 1.0f / exp( dp*cFogDensity );
		att = fogFact;
		ins = half4( (1.0f - fogFact)*cFogColor.rgb, 0.0f );
		return;
	}
}

VSOut VS_BaseTile( MESH_VERTEX In ) {
	VSOut Out;
	float4 PosW = mul( float4( In.PosL, 1.0f ), W );
	Out.PosH = mul( PosW, VP );
	Out.CamW = -(PosW.xyz);
	Out.NormW = normalize( mul( float4( In.NormL, 0.0f ), W ) );
	Out.TCrd = In.TCrd;

	AtmosphericHaze( Out.atten, Out.insca, Out.PosH.z );

	half4 diffuse;
	float ambi, nigh;

	LegacySunColor( diffuse, ambi, nigh, Out.NormW );

	Out.insca *= (diffuse + ambi);
	Out.insca.a = nigh;

	return Out;
}

Texture2D TileTexture;
SamplerState TileSampler;

cbuffer cb_PS_per_frame		: register( b0 )
{
	float4 SunDir;
	float4 ambient;
	float4 diffuse;
	float4 specular;	//64
};

float4 PS_BaseTile( VSOut In )		: SV_Target
{
	In.NormW = normalize( In.NormW );
	In.CamW = normalize( In.CamW );

	float4 TexCol = TileTexture.Sample( TileSampler, In.TCrd );

	float dif = saturate( dot( -SunDir, In.NormW )*1.5f );
	float spec = 0.0f;
	if( dif >= 0.0f && TexCol.a < 0.99f )
		spec = pow( max( dot( reflect( -SunDir, In.NormW ), In.CamW ), 0.0f ), 20.0f )*(1.0 - TexCol.a);

	float3 Color = TexCol.rgb*( max( dif, 0.0f )*diffuse.rgb + spec*specular.rgb + ambient.rgb);
	return float4( Color*In.atten.rgb + In.insca.rgb, TexCol.a );
}