struct vsInp {
	float3 PosL : POSITION;
	float3 NormL : NORMAL;
	float2 Texc : TEXCOORD;
};

struct vsOUT {
	float4 PosH : SV_POSITION;
	float2 Texc : TEXCOORD;
};

cbuffer cbTransform : register( b0 )
{
	matrix WVO;
};

vsOUT VS_Overlay( vsInp In ) {
	vsOUT Out;
	Out.PosH = mul( float4( In.PosL.xy, 0.0f, 1.0f ), WVO );
	Out.Texc = In.Texc;
	return Out;
}

cbuffer cbParams : register( b1 )
{
	uint mfd;
	float opacity;
	float2 _align;
};

Texture2D Diffuse : register( t0 );
SamplerState Linear : register( s0 );

float4 PS_Overlay( vsOUT In ) : SV_Target
{
	float4 color = Diffuse.Sample( Linear, In.Texc );
	if( mfd == 1 )
		color.a = opacity;
	return color;
}

float4 PS_GDI( vsOUT In ) : SV_Target
{
	float4 buf = Diffuse.Sample( Linear, In.Texc );
	clip( buf.x + buf.y + buf.z + 1.0f - buf.a - 0.0005f );
//	clip( buf.x + buf.y + buf.z + buf.a - 0.0005f );
	if( buf.a == 0 )
		buf.a = 1.0f;
	else
		buf.a = max( buf.r, max( buf.b, buf.g ) );
	return buf;
}