struct TILEVERTEX {
	float3 PosL		: POSITION;
	float3 NormL	: NORMAL;
	float2 TCrd0	: TEXCOORD0;
	float2 TCrd1	: TEXCOORD1;
};

struct VSOut {
	float4 PosH		: SV_POSITION;	
	float2 TCrd0	: TEXCOORD0;
	float2 TCrd1	: TEXCOORD1;

	float4 aux		: TEXCOORD2;
	float4 insca	: TEXCOORD3;
	float4 diffuse	: TEXCOORD4;
	float4 atten	: TEXCOORD5;
};

cbuffer cb_VS_per_frame		: register( b0 )
{
	float3 cSunDir;			//16
	float zz;
	float4 cFogColor;		//32

	float cWMat_spower;
	float cAmbient0;
	float cGlobalAmb;
	float cFogDensity;		//48

	uint cHazeMode;
	float cSunAppRad;
	float cDispersion;
	float none;				//64
};

cbuffer cb_VS_per_tile		: register( b1 )
{
	row_major matrix WVP;	//64
	row_major matrix W;		//128
	float4 TexOff;			//144
};

void LegacySunColor( out half4 diff, out float ambi, out float nigh, in float3 NormW ) {
	float h = dot( -cSunDir, NormW );
	float3 r0 = 1.0f - float3( 0.4f, 0.65f, 1.0f )*cDispersion;

	if( cDispersion != 0 ) {	// case 1: planet has atmosphere
		float3 di = (r0 + (1.0 - r0)*saturate( h*5.780 ))*saturate( (h + cSunAppRad)/(2.0*cSunAppRad) );
		float ni = (h + 0.242)*2.924;
		float am = saturate( max( cAmbient0*saturate( ni ) - 0.05, cGlobalAmb ) );

		diff = float4( di*(1.0 - am*0.5), 1 );
		ambi = am;
		nigh = saturate( -ni - 0.2 );
	}
	else {	// case 2: planet has no atmosphere
		diff = float4( r0*saturate( (h + cSunAppRad)/(2.0f*cSunAppRad) ), 1 );
		ambi = cGlobalAmb;
		nigh = 0;
	}
}

void AtmosphericHaze( out half4 att, out half4 ins, in float dp ) {
	[branch]
	if( cHazeMode == 0 ) {
		att = 1;
		ins = 0;
		return;
	}
	else {
		float fogFact = 1.0f / exp( dp*cFogDensity );
		att = fogFact;
		ins = half4( (1.0f - fogFact)*cFogColor.rgb, 0.0f );
		return;
	}
}

VSOut VS_Planet( TILEVERTEX In ) {
	VSOut Out;
	Out.PosH = mul( float4( In.PosL, 1.0f ), WVP );

	float3 PosW = mul( float4( In.PosL, 1.0f ), W ).xyz;
	float3 toCamW = normalize( -PosW );
	float3 NormW = normalize( mul( float4( In.NormL, 0.0f ), W ).xyz );

	float diff = saturate( dot( -cSunDir, NormW )*1.5f );
	float dotr;
	float spec = 0.0f;

	[branch]
	if( diff > 0.01f ) {
		dotr = max( dot( reflect( cSunDir, NormW ), toCamW ), 0.0f );
		spec = pow( diff, 0.25f )*pow( dotr, cWMat_spower );
	}
	float nigh = 0.0f;
	float ambi = 0.0f;

	Out.TCrd0 = float2( In.TCrd0.x*TexOff.x + TexOff.y, In.TCrd0.y*TexOff.z + TexOff.w );
	Out.TCrd1 = In.TCrd1;

	LegacySunColor( Out.diffuse, ambi, nigh, NormW );

	Out.aux = float4( spec, diff, ambi, nigh );

	AtmosphericHaze( Out.atten, Out.insca, Out.PosH.z );
	
	Out.insca *= ( Out.diffuse + ambi );

	return Out;
}

Texture2D DiffuseTex;
Texture2D SpecularTex;
Texture2D MicroTex;

SamplerState MainSampler;
SamplerState MicroSampler;

cbuffer cb_PS_per_frame	: register( b0 )
{
	float4 cAmbient;		//16
	float4 cWaterSpec;		//32
};

cbuffer cb_PS_per_tile	: register( b1 )
{
	uint SpecMode;
	uint LTex;
	float Mix;
	float nodata;			//16
};
//======================================
//		no Specular, no microtexture
//======================================
float4 PS_Planet_0( VSOut In ) : SV_Target
{
	float4 diff = In.aux.g*In.diffuse + float4( 1.0f, 1.0f, 1.0f, 1.0f )*In.aux.b;

	float micro = 1.0f;

	float4 vSpec = In.aux.r*(float4( cWaterSpec.rgb, 1.0f )*In.diffuse)*micro;
	float4 vEff = float4( 0.0f, 0.0f, 0.0f, 0.0f );

	[branch]
	if( SpecMode == 2 )
		vSpec *= 1.0f - vEff.a;

	[branch]
	if( SpecMode == 0 )
		vSpec = 0;

	float3 color = diff.rgb * DiffuseTex.Sample( MainSampler, In.TCrd0 ).rgb + In.aux.a*vEff.rgb + vSpec.rgb;

	return float4( color*In.atten.rgb + cAmbient.rgb + In.insca.rgb, 1.0f );
}
//======================================
//		Specular, no microtexture
//======================================
float4 PS_Planet_1( VSOut In ) : SV_Target
{
	float4 diff = In.aux.g*In.diffuse + float4( 1.0f, 1.0f, 1.0f, 1.0f )*In.aux.b;

	float micro = 1.0f;

	float4 vSpec = In.aux.r*(float4( cWaterSpec.rgb, 1.0f )*In.diffuse)*micro;
	float4 vEff;

	[branch]
	if( LTex != 0 ) vEff = SpecularTex.Sample( MainSampler, In.TCrd0 );
	else			vEff = float4( 0.0f, 0.0f, 0.0f, 1.0f );

	[branch]
	if( SpecMode == 2 )
		vSpec *= 1.0f - vEff.a;

	[branch]
	if( SpecMode == 0 )
		vSpec = 0;

	float3 color = diff.rgb * DiffuseTex.Sample( MainSampler, In.TCrd0 ).rgb + In.aux.a*vEff.rgb + vSpec.rgb;

	return float4( color*In.atten.rgb + cAmbient.rgb + In.insca.rgb, 1.0f );
}
//======================================
//		Specular, + microtexture
//======================================
float4 PS_Planet_2( VSOut In ) : SV_Target
{
	float4 diff = In.aux.g*In.diffuse + float4( 1.0f, 1.0f, 1.0f, 1.0f )*In.aux.b;

	float micro = 1.0f;
	float micro_tex = MicroTex.Sample( MicroSampler, In.TCrd1 ).a;
	if( Mix > 0.1f )
		micro -= micro_tex;

	float4 vSpec = In.aux.r*(float4( cWaterSpec.rgb, 1.0f )*In.diffuse)*micro;
	float4 vEff;
	if( LTex != 0 ) vEff = SpecularTex.Sample( MainSampler, In.TCrd0 );
	else			vEff = float4( 0.0f, 0.0f, 0.0f, 0.0f );

	if( SpecMode == 2 )
		vSpec *= 1.0f - vEff.a;
	if( SpecMode == 0 )
		vSpec = 0;

	float3 color = diff.rgb * DiffuseTex.Sample( MainSampler, In.TCrd0 ).rgb + In.aux.a*vEff.rgb + vSpec.rgb;

//	return In.atten;
	return float4( color*In.atten.rgb + cAmbient.rgb + In.insca.rgb, 1.0f );
}

