#ifndef __CSPHMGR_H
#define __CSPHMGR_H

#if C2504
#pragma message("CelSphere.h");
#endif

#include "D3D11Client.h"
#include "D3D11Effect.h"
#include "TileManager.h"

#define MAXSTARVERTEX 32768
#define NSEG 64

class D3D11Effect;

struct StarRec {
	float lng, lat, mag;
};

struct STARVERTEX {
	D3DXVECTOR3 pos;
	float col;			//16
};

class CelSphere : public D3D11Effect {
public:
	CelSphere();
	~CelSphere();

	void RenderCelestialSphere( D3DXMATRIX *VP, float skybrt, const D3DXVECTOR3 *bgcol );	
private:
	void RenderStars( const D3DXVECTOR3 *bgcol );
	void RenderConstellations();
	void RenderGrid( bool eqline = true );
	void RenderGreatCircle();
	void RenderCelestialMarkers( D3DXMATRIX *VP );

	void LoadStars();
	void LoadConstLines();
	void CreateGrid();

	ID3D11Buffer **Stars, *ConstLines, *LatGrid, *LngGrid;
	DWORD nbuf, nsvtx, nmax, ncline;

	double sphere_r;
	int lvlid[256];
};

class CelBackground : public D3D11Effect {
public:
	CelBackground();
	~CelBackground();

	void SaveParams( int level, int bglvl );
	void Render( /*int level, int bglvl*/ );
private:
	void ProcessTile( int hemisphere, int lvl, int ilat, int nlat, int ilng, int nlng, TILEDESC *tile,
		const TEXCRDRANGE &range, ID3D11ShaderResourceView *tex );
	
	void RenderTile( int hemisphere, int lvl, int ilat, int nlat, int ilng, int nlng,
		TILEDESC *tile, const TEXCRDRANGE &range, ID3D11ShaderResourceView *tex );

	VECTOR3 GetTileCenter( int hemisphere, int ilat, int nlat, int ilng, int nlng );
	void SetWorldMatrix( int ilat, int nlat, int ilng, int nlng );
	bool IsTileInView( int lvl, int ilat );
	
	void LoadTextures();

	TILEMESH **TPL;
	int **NLNG, *NLAT, *patchidx;

	MATRIX3 ecl2gal;
	D3DXMATRIX trans, mWorld;
	struct RPARAM {
		D3DXMATRIX mWorld;
		int tgtlvl;
		VECTOR3 CamDir;
		double viewap;
	} RP;

	TILEDESC *tiledesc;
	ID3D11ShaderResourceView **texbuf;
	DWORD ntex;
	bool disabled;
	float Intensity;
	char texname[64];

	TileBuffer *tbuf;
	int maxlvl, maxbaselvl;
	const D3D11Config *cfg;

	//MT
	float intens;
};

#endif