#include "Scene.h"
#include "D3D11Effect.h"



D3D11Effect::D3D11Effect()
{
}

D3D11Effect::~D3D11Effect()
{
}

void V3toD3DXVec3( VECTOR3 *in, D3DXVECTOR3 *out ) {
	out->x = (float)in->x;
	out->y = (float)in->y;
	out->z = (float)in->z;
}

void V3toD3DXVec4( VECTOR3 *in, D3DXVECTOR4 *out ) {
	out->x = (float)in->x;
	out->y = (float)in->y;
	out->z = (float)in->z;
	out->w = 0.0f;
}

//===========================================================
//					DEVICE + DEVICE CONTEXT + DSS + RS + BS
//===========================================================

ID3D11Device *D3D11Effect::Dev = NULL;
ID3D11DeviceContext *D3D11Effect::dCtx = NULL;

char D3D11Effect::vs_ver[32];
char D3D11Effect::ps_ver[32];

ID3D11DepthStencilState 
	*D3D11Effect::DSS_Write0_Test0 = NULL,
	*D3D11Effect::DSS_Write1_Test1 = NULL;

ID3D11RasterizerState 
	*D3D11Effect::RS_Back_Solid = NULL,
	*D3D11Effect::RS_Back_Wire = NULL,
	*D3D11Effect::RS_Front_Solid = NULL,
	*D3D11Effect::RS_None_Solid = NULL,
	*D3D11Effect::RS_None_Wire = NULL;

ID3D11BlendState
	*D3D11Effect::BS_NoBlend,
	*D3D11Effect::BS_SrcAlpha_Blend_0;

void D3D11Effect::InitGlobal( ID3D11Device *dev, ID3D11DeviceContext *dctx ) {
	Dev = dev;
	dCtx = dctx;

	D3D_FEATURE_LEVEL feature = Dev->GetFeatureLevel();
	switch( feature ) {
	case D3D_FEATURE_LEVEL_9_1:
		strcpy( vs_ver, "vs_4_0_level_9_1" );
		strcpy( ps_ver, "ps_4_0_level_9_1" );
		break;
	case D3D_FEATURE_LEVEL_9_2:
		strcpy( vs_ver, "vs_4_0_level_9_1" );
		strcpy( ps_ver, "ps_4_0_level_9_1" );
		break;
	case D3D_FEATURE_LEVEL_9_3:
		strcpy( vs_ver, "vs_4_0_level_9_3" );
		strcpy( ps_ver, "ps_4_0_level_9_3" );
		break;
	case D3D_FEATURE_LEVEL_10_0:
		strcpy( vs_ver, "vs_4_0" );
		strcpy( ps_ver, "ps_4_0" );
		break;
	case D3D_FEATURE_LEVEL_10_1:
		strcpy( vs_ver, "vs_4_0" );
		strcpy( ps_ver, "ps_4_0" );
		break;
	case D3D_FEATURE_LEVEL_11_0:
		strcpy( vs_ver, "vs_5_0" );
		strcpy( ps_ver, "ps_5_0" );
		break;
	}

//DSS states:
	D3D11_DEPTH_STENCIL_DESC ddesc;
	ZeroMemory( &ddesc, sizeof( ddesc ) );
	ddesc.DepthFunc = D3D11_COMPARISON_ALWAYS;
	ddesc.DepthEnable = FALSE;
	ddesc.DepthWriteMask = D3D11_DEPTH_WRITE_MASK_ZERO;
	ddesc.StencilEnable = FALSE;
	HR( Dev->CreateDepthStencilState( &ddesc, &DSS_Write0_Test0 ) );

	ZeroMemory( &ddesc, sizeof( ddesc ) );
	ddesc.DepthFunc = D3D11_COMPARISON_ALWAYS;
	ddesc.DepthEnable = TRUE;
	ddesc.DepthWriteMask = D3D11_DEPTH_WRITE_MASK_ALL;
	ddesc.StencilEnable = FALSE;
	HR( Dev->CreateDepthStencilState( &ddesc, &DSS_Write1_Test1 ) );

//rasterizer states:
	D3D11_RASTERIZER_DESC rdesc;
	ZeroMemory( &rdesc, sizeof( rdesc ) );
	rdesc.CullMode = D3D11_CULL_BACK;
	rdesc.FillMode = D3D11_FILL_SOLID;
	rdesc.FrontCounterClockwise = FALSE;
	HR( Dev->CreateRasterizerState( &rdesc, &RS_Back_Solid ) );

	ZeroMemory( &rdesc, sizeof( rdesc ) );
	rdesc.CullMode = D3D11_CULL_BACK;
	rdesc.FillMode = D3D11_FILL_WIREFRAME;
	rdesc.FrontCounterClockwise = FALSE;
	HR( Dev->CreateRasterizerState( &rdesc, &RS_Back_Wire ) );

	ZeroMemory( &rdesc, sizeof( rdesc ) );
	rdesc.CullMode = D3D11_CULL_FRONT;
	rdesc.FillMode = D3D11_FILL_SOLID;
	rdesc.FrontCounterClockwise = FALSE;
	HR( Dev->CreateRasterizerState( &rdesc, &RS_Front_Solid ) );

	ZeroMemory( &rdesc, sizeof( rdesc ) );
	rdesc.CullMode = D3D11_CULL_NONE;
	rdesc.FillMode = D3D11_FILL_SOLID;
	rdesc.FrontCounterClockwise = FALSE;
	HR( Dev->CreateRasterizerState( &rdesc, &RS_None_Solid ) );

	ZeroMemory( &rdesc, sizeof( rdesc ) );
	rdesc.CullMode = D3D11_CULL_NONE;
	rdesc.FillMode = D3D11_FILL_WIREFRAME;
	rdesc.FrontCounterClockwise = FALSE;
	HR( Dev->CreateRasterizerState( &rdesc, &RS_None_Wire ) );

//blend states:
	D3D11_BLEND_DESC bdesc;
	ZeroMemory( &bdesc, sizeof(bdesc) );
	bdesc.AlphaToCoverageEnable = false;
	bdesc.IndependentBlendEnable = false;
	bdesc.RenderTarget[0].BlendEnable = false;
	bdesc.RenderTarget[0].SrcBlend = D3D11_BLEND_SRC_ALPHA;
	bdesc.RenderTarget[0].SrcBlendAlpha = D3D11_BLEND_ONE;
	bdesc.RenderTarget[0].DestBlend = D3D11_BLEND_INV_SRC_ALPHA;
	bdesc.RenderTarget[0].DestBlendAlpha = D3D11_BLEND_ZERO;
	bdesc.RenderTarget[0].BlendOp = D3D11_BLEND_OP_ADD;
	bdesc.RenderTarget[0].BlendOpAlpha = D3D11_BLEND_OP_ADD;
	bdesc.RenderTarget[0].RenderTargetWriteMask = D3D11_COLOR_WRITE_ENABLE_ALL;
	HR( Dev->CreateBlendState( &bdesc, &BS_NoBlend ) );

	ZeroMemory( &bdesc, sizeof(bdesc) );
	bdesc.AlphaToCoverageEnable = false;
	bdesc.IndependentBlendEnable = false;
	bdesc.RenderTarget[0].BlendEnable = true;
	bdesc.RenderTarget[0].SrcBlend = D3D11_BLEND_SRC_ALPHA;
	bdesc.RenderTarget[0].SrcBlendAlpha = D3D11_BLEND_ONE;
	bdesc.RenderTarget[0].DestBlend = D3D11_BLEND_INV_SRC_ALPHA;
	bdesc.RenderTarget[0].DestBlendAlpha = D3D11_BLEND_ZERO;
	bdesc.RenderTarget[0].BlendOp = D3D11_BLEND_OP_ADD;
	bdesc.RenderTarget[0].BlendOpAlpha = D3D11_BLEND_OP_ADD;
	bdesc.RenderTarget[0].RenderTargetWriteMask = D3D11_COLOR_WRITE_ENABLE_ALL;
	HR( Dev->CreateBlendState( &bdesc, &BS_SrcAlpha_Blend_0 ) );
}

//===========================================================
//					PLANET SURFACE
//===========================================================

ID3D11Buffer *D3D11Effect::cb_VS_Planet[2] = { NULL };
ID3D11Buffer *D3D11Effect::cb_PS_Planet[2] = { NULL };

cb_VS_Planet_0 D3D11Effect::VSCB_Planet_0;	//per frame
cb_VS_Planet_1 D3D11Effect::VSCB_Planet_1;	//per tile/sphere
cb_PS_Planet_0 D3D11Effect::PSCB_Planet_0;	//per frame
cb_PS_Planet_1 D3D11Effect::PSCB_Planet_1;	//per frame

ID3D11InputLayout *D3D11Effect::IL_TileVertex = NULL;
ID3D11VertexShader *D3D11Effect::VS_Planet = NULL;
ID3D11PixelShader *D3D11Effect::PS_Planet[3] = { NULL };
ID3D11SamplerState
	*D3D11Effect::SS_Planet = NULL,
	*D3D11Effect::SS_Planet_micro = NULL;

void D3D11Effect::InitPlanetEffect() {
//constant buffers:
	D3D11_BUFFER_DESC desc;
	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 64;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	Dev->CreateBuffer( &desc, NULL, &cb_VS_Planet[0] );

	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 144;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	Dev->CreateBuffer( &desc, NULL, &cb_VS_Planet[1] );

	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 32;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	Dev->CreateBuffer( &desc, NULL, &cb_PS_Planet[0] );

	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 16;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	Dev->CreateBuffer( &desc, NULL, &cb_PS_Planet[1] );

//layout, vertex and pixel shaders:
	HRESULT hr;
	ID3DBlob *SBlob = NULL, *EBlob = NULL;

	D3D11_INPUT_ELEMENT_DESC ldesc[ ] = {
		{ "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 0, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "NORMAL", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 12, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 0, DXGI_FORMAT_R32G32_FLOAT, 0, 24, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 1, DXGI_FORMAT_R32G32_FLOAT, 0, 32, D3D11_INPUT_PER_VERTEX_DATA, 0 }	};

	CompileFromFile( "Modules\\D3D11Shaders\\Planet.fx", NULL, NULL, "VS_Planet", vs_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreateInputLayout( ldesc, 4, SBlob->GetBufferPointer(), SBlob->GetBufferSize(), &IL_TileVertex ) );
	HR( Dev->CreateVertexShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &VS_Planet ) );
	REL( SBlob );
	REL( EBlob );
	
	CompileFromFile( "Modules\\D3D11Shaders\\Planet.fx", NULL, NULL, "PS_Planet_0", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_Planet[0] ) );
	REL( SBlob );
	REL( EBlob );
	
	CompileFromFile( "Modules\\D3D11Shaders\\Planet.fx", NULL, NULL, "PS_Planet_1", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_Planet[1] ) );
	REL( SBlob );
	REL( EBlob );
	
	CompileFromFile( "Modules\\D3D11Shaders\\Planet.fx", NULL, NULL, "PS_Planet_2", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_Planet[2] ) );
	REL( SBlob );
	REL( EBlob );
//sampler, depthstencil:
	D3D11_SAMPLER_DESC sdesc;
	ZeroMemory( &sdesc, sizeof( sdesc ) );
	sdesc.Filter = cfg->FILTER_PlanetTexture;
	sdesc.AddressU = D3D11_TEXTURE_ADDRESS_CLAMP;
	sdesc.AddressV = D3D11_TEXTURE_ADDRESS_CLAMP;
	sdesc.AddressW = D3D11_TEXTURE_ADDRESS_CLAMP;
	sdesc.ComparisonFunc = D3D11_COMPARISON_ALWAYS;
	sdesc.MaxAnisotropy = cfg->AF_FACTOR_PlanetTexture;
	sdesc.MipLODBias = 0;
	sdesc.MinLOD = 0;
	sdesc.MaxLOD = D3D11_FLOAT32_MAX;
	HR( Dev->CreateSamplerState( &sdesc, &SS_Planet ) );

	ZeroMemory( &sdesc, sizeof( sdesc ) );
	sdesc.Filter = D3D11_FILTER_MIN_MAG_MIP_LINEAR;
	sdesc.AddressU = D3D11_TEXTURE_ADDRESS_WRAP;
	sdesc.AddressV = D3D11_TEXTURE_ADDRESS_WRAP;
	sdesc.AddressW = D3D11_TEXTURE_ADDRESS_WRAP;
	sdesc.ComparisonFunc = D3D11_COMPARISON_ALWAYS;
	sdesc.MaxAnisotropy = 4;
	sdesc.MipLODBias = 0;
	sdesc.MinLOD = 0;
	sdesc.MaxLOD = D3D11_FLOAT32_MAX;
	HR( Dev->CreateSamplerState( &sdesc, &SS_Planet_micro ) );

	memset( &VSCB_Planet_0, 0, 64 );
	memset( &VSCB_Planet_1, 0, 144 );
	memset( &PSCB_Planet_0, 0, 32 );
	memset( &PSCB_Planet_1, 0, 16 );
}

void D3D11Effect::ExitPlanetEffect() {
	cb_VS_Planet[0]->Release();
	cb_VS_Planet[1]->Release();
	cb_PS_Planet[0]->Release();
	cb_PS_Planet[1]->Release();
	IL_TileVertex->Release();
	VS_Planet->Release();
	PS_Planet[0]->Release();
	PS_Planet[1]->Release();
	PS_Planet[2]->Release();
	SS_Planet->Release();
	SS_Planet_micro->Release();
}

//===========================================================
//					ATMOSPHERIC HAZE
//===========================================================

ID3D11Buffer *D3D11Effect::cb_VS_Haze_0 = NULL;
ID3D11InputLayout *D3D11Effect::IL_HazeVertex = NULL;
ID3D11VertexShader *D3D11Effect::VS_Haze = NULL;
ID3D11PixelShader *D3D11Effect::PS_Haze = NULL;

void D3D11Effect::InitHazeEffect() {
	D3D11_BUFFER_DESC desc;
	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 64;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	Dev->CreateBuffer( &desc, NULL, &cb_VS_Haze_0 );

//shaders:
	HRESULT hr;
	ID3DBlob *SBlob = NULL, *EBlob = NULL;

	D3D11_INPUT_ELEMENT_DESC ldesc[ ] = {
		{ "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 0, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 0, DXGI_FORMAT_R32G32B32A32_FLOAT, 0, 12, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 1, DXGI_FORMAT_R32_FLOAT, 0, 28, D3D11_INPUT_PER_VERTEX_DATA, 0 }	};

	CompileFromFile( "Modules\\D3D11Shaders\\Planet_Haze.fx", NULL, NULL, "VS_Haze", vs_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreateInputLayout( ldesc, 3, SBlob->GetBufferPointer(), SBlob->GetBufferSize(), &IL_HazeVertex ) );
	HR( Dev->CreateVertexShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &VS_Haze ) );
	REL( SBlob );
	REL( EBlob );
	
	CompileFromFile( "Modules\\D3D11Shaders\\Planet_Haze.fx", NULL, NULL, "PS_Haze", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_Haze ) );
	REL( SBlob );
	REL( EBlob );
}

void D3D11Effect::ExitHazeEffect() {
	cb_VS_Haze_0->Release();
	IL_HazeVertex->Release();
	VS_Haze->Release();
	PS_Haze->Release();
}

//===========================================================
//					CLOUD LAYER AND SHADOWS
//===========================================================

ID3D11VertexShader
	*D3D11Effect::VS_Clouds = NULL,
	*D3D11Effect::VS_CloudsShadow = NULL;
ID3D11PixelShader 
	*D3D11Effect::PS_Clouds[2] = { NULL },
	*D3D11Effect::PS_CloudsShadow[2] = { NULL };
ID3D11Buffer
	*D3D11Effect::cb_VS_Clouds[2] = { NULL },
	*D3D11Effect::cb_VS_CloudsShadow_0 = NULL,
	*D3D11Effect::cb_PS_Clouds = NULL;
ID3D11SamplerState
	*D3D11Effect::SS_Clouds = NULL,
	*D3D11Effect::SS_Clouds_micro = NULL;
cb_VS_Clouds_0 D3D11Effect::VSCB_Clouds_0;
cb_VS_CloudsShadows_0 D3D11Effect::VSCB_CloudsShadows_0;

void D3D11Effect::InitCloudsEffect() {
//shaders:
//clouds:
	HRESULT hr;
	ID3DBlob *SBlob = NULL, *EBlob = NULL;

	CompileFromFile( "Modules\\D3D11Shaders\\Planet_Clouds.fx", NULL, NULL, "VS_Clouds", vs_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreateVertexShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &VS_Clouds ) );
	REL( SBlob );
	REL( EBlob );

	CompileFromFile( "Modules\\D3D11Shaders\\Planet_Clouds.fx", NULL, NULL, "PS_Clouds_0", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_Clouds[0] ) );
	REL( SBlob );
	REL( EBlob );

	CompileFromFile( "Modules\\D3D11Shaders\\Planet_Clouds.fx", NULL, NULL, "PS_Clouds_1", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_Clouds[1] ) );
	REL( SBlob );
	REL( EBlob );

//buffers:
	D3D11_BUFFER_DESC desc;
	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 32;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	HR( Dev->CreateBuffer( &desc, NULL, &cb_VS_Clouds[0] ) );

	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 128;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	HR( Dev->CreateBuffer( &desc, NULL, &cb_VS_Clouds[1] ) );

	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 16;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	HR( Dev->CreateBuffer( &desc, NULL, &cb_PS_Clouds ) );

//===========================================================
//			Cloud Shadow
//===========================================================
//cloud shadows:
	CompileFromFile( "Modules\\D3D11Shaders\\Planet_CloudsShadow.fx", NULL, NULL, "VS_CloudsShadow", vs_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreateVertexShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &VS_CloudsShadow ) );
	REL( SBlob );
	REL( EBlob );

	CompileFromFile( "Modules\\D3D11Shaders\\Planet_CloudsShadow.fx", NULL, NULL, "PS_CloudsShadow_0", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_CloudsShadow[0] ) );
	REL( SBlob );
	REL( EBlob );

	CompileFromFile( "Modules\\D3D11Shaders\\Planet_CloudsShadow.fx", NULL, NULL, "PS_CloudsShadow_1", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_CloudsShadow[1] ) );
	REL( SBlob );
	REL( EBlob );

//buffers:
	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 16;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	HR( Dev->CreateBuffer( &desc, NULL, &cb_VS_CloudsShadow_0 ) );

//samplers:
	D3D11_SAMPLER_DESC sdesc;
	ZeroMemory( &sdesc, sizeof( sdesc ) );
	sdesc.Filter = D3D11_FILTER_MIN_MAG_MIP_LINEAR ;
	sdesc.AddressU = D3D11_TEXTURE_ADDRESS_CLAMP;
	sdesc.AddressV = D3D11_TEXTURE_ADDRESS_CLAMP;
	sdesc.AddressW = D3D11_TEXTURE_ADDRESS_CLAMP;
	sdesc.ComparisonFunc = D3D11_COMPARISON_ALWAYS;
	sdesc.MaxAnisotropy = 4;
	sdesc.MipLODBias = 0;
	sdesc.MinLOD = 0;
	sdesc.MaxLOD = D3D11_FLOAT32_MAX;
	HR( Dev->CreateSamplerState( &sdesc, &SS_Clouds ) );

	ZeroMemory( &sdesc, sizeof( sdesc ) );
	sdesc.Filter = D3D11_FILTER_MIN_MAG_MIP_LINEAR ;
	sdesc.AddressU = D3D11_TEXTURE_ADDRESS_WRAP;
	sdesc.AddressV = D3D11_TEXTURE_ADDRESS_WRAP;
	sdesc.AddressW = D3D11_TEXTURE_ADDRESS_WRAP;
	sdesc.ComparisonFunc = D3D11_COMPARISON_ALWAYS;
	sdesc.MaxAnisotropy = 4;
	sdesc.MipLODBias = 0;
	sdesc.MinLOD = 0;
	sdesc.MaxLOD = D3D11_FLOAT32_MAX;
	HR( Dev->CreateSamplerState( &sdesc, &SS_Clouds_micro ) );
}

void D3D11Effect::ExitCloudsEffect() {
	VS_Clouds->Release();
	VS_CloudsShadow->Release();
	PS_Clouds[0]->Release();
	PS_Clouds[1]->Release();
	PS_CloudsShadow[0]->Release();
	PS_CloudsShadow[1]->Release();
	cb_VS_Clouds[0]->Release();
	cb_VS_Clouds[1]->Release();
	cb_VS_CloudsShadow_0->Release();
	cb_PS_Clouds->Release();
	SS_Clouds->Release();
	SS_Clouds_micro->Release();
}

//===========================================================
//			PLANETARY RINGS
//===========================================================

ID3D11Buffer
	*D3D11Effect::cb_VS_Ring = NULL,
	*D3D11Effect::cb_PS_Ring = NULL;
ID3D11InputLayout *D3D11Effect::IL_RVertex = NULL;
ID3D11VertexShader *D3D11Effect::VS_Ring = NULL;
ID3D11PixelShader *D3D11Effect::PS_Ring = NULL;
ID3D11SamplerState *D3D11Effect::SS_Ring = NULL;

void D3D11Effect::InitRingEffect() {
//shaders:
	HRESULT hr;
	ID3DBlob *SBlob = NULL, *EBlob = NULL;

	D3D11_INPUT_ELEMENT_DESC ldesc[ ] = {
		{ "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 0, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 0, DXGI_FORMAT_R32G32_FLOAT, 0, 12, D3D11_INPUT_PER_VERTEX_DATA, 0 } };

	CompileFromFile( "Modules\\D3D11Shaders\\Planet_Ring.fx", NULL, NULL, "VS_Ring", vs_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreateInputLayout( ldesc, 2, SBlob->GetBufferPointer(), SBlob->GetBufferSize(), &IL_RVertex ) );
	HR( Dev->CreateVertexShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &VS_Ring ) );
	REL( SBlob );
	REL( EBlob );

	CompileFromFile( "Modules\\D3D11Shaders\\Planet_Ring.fx", NULL, NULL, "PS_Ring", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_Ring ) );
	REL( SBlob );
	REL( EBlob );

//buffers:
	D3D11_BUFFER_DESC desc;
	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 128;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	HR( Dev->CreateBuffer( &desc, NULL, &cb_VS_Ring ) );

	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 16;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	HR( Dev->CreateBuffer( &desc, NULL, &cb_PS_Ring ) );

//sampler:
	D3D11_SAMPLER_DESC sdesc;
	ZeroMemory( &sdesc, sizeof( sdesc ) );
	sdesc.Filter = D3D11_FILTER_MIN_MAG_MIP_LINEAR ;
	sdesc.AddressU = D3D11_TEXTURE_ADDRESS_WRAP;
	sdesc.AddressV = D3D11_TEXTURE_ADDRESS_WRAP;
	sdesc.AddressW = D3D11_TEXTURE_ADDRESS_WRAP;
	sdesc.ComparisonFunc = D3D11_COMPARISON_ALWAYS;
	sdesc.MaxAnisotropy = 4;
	sdesc.MipLODBias = 0;
	sdesc.MinLOD = 0;
	sdesc.MaxLOD = D3D11_FLOAT32_MAX;
	HR( Dev->CreateSamplerState( &sdesc, &SS_Ring ) );
}

void D3D11Effect::ExitRingEffect() {
	cb_VS_Ring->Release();
	cb_PS_Ring->Release();
	IL_RVertex->Release();
	VS_Ring->Release();
	PS_Ring->Release();
	SS_Ring->Release();
}

//===========================================================
//			CELESTIAL SPHERE
//===========================================================

ID3D11Buffer
	*D3D11Effect::cb_VS_Star_Line = NULL,
	*D3D11Effect::cb_PS_Line = NULL;
ID3D11InputLayout *D3D11Effect::IL_CVertex = NULL;
ID3D11VertexShader *D3D11Effect::VS_Star_Line = NULL;
ID3D11PixelShader
	*D3D11Effect::PS_Star = NULL,
	*D3D11Effect::PS_Line = NULL;

void D3D11Effect::InitCelSphereEffect() {
//shaders:
	HRESULT hr;
	ID3DBlob *SBlob = NULL, *EBlob = NULL;

	D3D11_INPUT_ELEMENT_DESC ldesc[ ] = {
		{ "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 0, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "COLOR", 0, DXGI_FORMAT_R32_FLOAT, 0, 12, D3D11_INPUT_PER_VERTEX_DATA, 0 } };

	CompileFromFile( "Modules\\D3D11Shaders\\CelSphere.fx", NULL, NULL, "VS_Star_Line", vs_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreateInputLayout( ldesc, 2, SBlob->GetBufferPointer(), SBlob->GetBufferSize(), &IL_CVertex ) );
	HR( Dev->CreateVertexShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &VS_Star_Line ) );
	REL( SBlob );
	REL( EBlob );

	CompileFromFile( "Modules\\D3D11Shaders\\CelSphere.fx", NULL, NULL, "PS_Star", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_Star ) );
	REL( SBlob );
	REL( EBlob );

	CompileFromFile( "Modules\\D3D11Shaders\\CelSphere.fx", NULL, NULL, "PS_Line", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_Line ) );
	REL( SBlob );
	REL( EBlob );
//buffers:
	D3D11_BUFFER_DESC desc;
	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 64;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	HR( Dev->CreateBuffer( &desc, NULL, &cb_VS_Star_Line ) );

	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 16;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	HR( Dev->CreateBuffer( &desc, NULL, &cb_PS_Line ) );
}

void D3D11Effect::ExitCelSphereEffect() {
	cb_VS_Star_Line->Release();
	cb_PS_Line->Release();
	IL_CVertex->Release();
	VS_Star_Line->Release();
	PS_Star->Release();
	PS_Line->Release();
}

//===========================================================
//			CELESTIAL BACKGROUND
//===========================================================

ID3D11Buffer
	*D3D11Effect::cb_VS_CelBackground = NULL,
	*D3D11Effect::cb_PS_CelBackground = NULL;
ID3D11VertexShader *D3D11Effect::VS_CelBackground = NULL;
ID3D11PixelShader *D3D11Effect::PS_CelBackground = NULL;
ID3D11SamplerState *D3D11Effect::SS_CelBackground = NULL;

void D3D11Effect::InitCelBackgroundEffect() {
//shaders:
	HRESULT hr;
	ID3DBlob *SBlob = NULL, *EBlob = NULL;

	CompileFromFile( "Modules\\D3D11Shaders\\CelBackground.fx", NULL, NULL, "VS_CelBackground", vs_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreateVertexShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &VS_CelBackground ) );
	REL( SBlob );
	REL( EBlob );

	CompileFromFile( "Modules\\D3D11Shaders\\CelBackground.fx", NULL, NULL, "PS_CelBackground", ps_ver, ShaderCompileFlag, 0, NULL, &SBlob, &EBlob, &hr );
	ShowShaderCompilationError( hr, EBlob );
	HR( Dev->CreatePixelShader( SBlob->GetBufferPointer(), SBlob->GetBufferSize(), NULL, &PS_CelBackground ) );
	REL( SBlob );
	REL( EBlob );

//buffers:
	D3D11_BUFFER_DESC desc;
	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 64;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	HR( Dev->CreateBuffer( &desc, NULL, &cb_VS_CelBackground ) );

	ZeroMemory( &desc, sizeof(desc) );
	desc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc.ByteWidth = 16;
	desc.CPUAccessFlags = 0;
	desc.MiscFlags = 0;
	desc.StructureByteStride = 0;
	desc.Usage = D3D11_USAGE_DEFAULT;
	HR( Dev->CreateBuffer( &desc, NULL, &cb_PS_CelBackground ) );

//samplers:
	D3D11_SAMPLER_DESC sdesc;
	ZeroMemory( &sdesc, sizeof( sdesc ) );
	sdesc.Filter = D3D11_FILTER_MIN_MAG_MIP_LINEAR ;
	sdesc.AddressU = D3D11_TEXTURE_ADDRESS_CLAMP;
	sdesc.AddressV = D3D11_TEXTURE_ADDRESS_CLAMP;
	sdesc.AddressW = D3D11_TEXTURE_ADDRESS_CLAMP;
	sdesc.ComparisonFunc = D3D11_COMPARISON_ALWAYS;
	sdesc.MaxAnisotropy = 4;
	sdesc.MipLODBias = 0;
	sdesc.MinLOD = 0;
	sdesc.MaxLOD = D3D11_FLOAT32_MAX;
	HR( Dev->CreateSamplerState( &sdesc, &SS_CelBackground ) );
}

void D3D11Effect::ExitCelBackgroundEffect() {
	cb_VS_CelBackground->Release();
	cb_PS_CelBackground->Release();
	VS_CelBackground->Release();
	PS_CelBackground->Release();
	SS_CelBackground->Release();
}

void D3D11Effect::ExitGlobal() {
	DSS_Write0_Test0->Release();
	DSS_Write1_Test1->Release();

	RS_Back_Solid->Release();
	RS_Back_Wire->Release();
	RS_Front_Solid->Release();
	RS_None_Solid->Release();
	RS_None_Wire->Release();

	BS_NoBlend->Release();
	BS_SrcAlpha_Blend_0->Release();
}