#ifndef __D3D11EFFECT_H
#define __D3D11EFFECT_H

#if C2504
#pragma message("D3D11Effect.h")
#endif

#include "D3D11Client.h"
//#include "Scene.h"
//#include "vObject.h"

void V3toD3DXVec3( VECTOR3 *in, D3DXVECTOR3 *out );
void V3toD3DXVec4( VECTOR3 *in, D3DXVECTOR4 *out );

//constant buffers;
struct cb_VS_Planet_0 {
	D3DXVECTOR4 SunDir;		//*		16
	D3DXCOLOR FogColor;		//*		32

	float WMat_spower;		//*
	float Ambient0;			//*
	float GlobalAmb;		//*
	float FogDensity;		//*		48

	UINT32 HazeMode;		//*
	float SunAppRad;		//*
	float Dispersion;		//*
	float nodata;			//**	64
};

struct cb_VS_Planet_1 {
	D3DXMATRIX WVP;			//*		64
	D3DXMATRIX W;			//*		128
	D3DXVECTOR4 TexOff;		//*		144
};

struct cb_PS_Planet_0 {
	D3DXCOLOR cAmbient;		//*		16
	D3DXCOLOR cWaterSpec;			//*		32
};

struct cb_PS_Planet_1 {
	UINT32 SpecMode;
	UINT32 LTex;
	float Mix;
	float nodata;		//*		16
};

struct cb_VS_Haze {
	D3DXMATRIX WVP;			//64
	D3DXMATRIX W;			//128
};

struct cb_VS_Clouds_0 {
	D3DXVECTOR4 SunDir;
	float Dispersion;
	float SunAppRad;
	float Ambient0;
	float GlobalAmb;
};

struct cb_VS_CloudsShadows_0 {
	UINT32 HazeMode;
	float FogDensity;
	float nodata[2];
};

class D3D11Effect {
public:
	D3D11Effect();
	~D3D11Effect();
	//==================================================================
	//			D3D11
	//==================================================================
//general:
	static void InitGlobal( ID3D11Device *dev, ID3D11DeviceContext *dctx );
//	static void ShowShaderCompilationError( HRESULT hr, ID3DBlob *EBlob );
	static void ExitGlobal();
	
	static ID3D11Device *Dev;
	static ID3D11DeviceContext *dCtx;
	static char vs_ver[32], ps_ver[32];

	static ID3D11DepthStencilState *DSS_Write0_Test0, *DSS_Write1_Test1;
	static ID3D11RasterizerState *RS_Back_Solid, *RS_Back_Wire, *RS_Front_Solid, *RS_None_Solid, *RS_None_Wire;
	static ID3D11BlendState *BS_NoBlend, *BS_SrcAlpha_Blend_0;
//Planets:
	static void InitPlanetEffect();//compiles shaders, creates layouts, cbuffers, samplers etc.
	static void ExitPlanetEffect();

	static ID3D11Buffer *cb_VS_Planet[2];
	static ID3D11Buffer *cb_PS_Planet[2];

	static cb_VS_Planet_0 VSCB_Planet_0;
	static cb_VS_Planet_1 VSCB_Planet_1;
	static cb_PS_Planet_0 PSCB_Planet_0;
	static cb_PS_Planet_1 PSCB_Planet_1;

	static ID3D11InputLayout *IL_TileVertex;
	static ID3D11VertexShader *VS_Planet;
	static ID3D11PixelShader *PS_Planet[3];
	static ID3D11SamplerState *SS_Planet, *SS_Planet_micro;

//Haze:	
	static void InitHazeEffect();
	static void ExitHazeEffect();

	static ID3D11Buffer *cb_VS_Haze_0;
	static ID3D11InputLayout *IL_HazeVertex;
	static ID3D11VertexShader *VS_Haze;
	static ID3D11PixelShader *PS_Haze;

//Clouds:
	static void InitCloudsEffect();
	static void ExitCloudsEffect();

	static ID3D11VertexShader *VS_Clouds, *VS_CloudsShadow;
	static ID3D11PixelShader *PS_Clouds[2], *PS_CloudsShadow[2];
	static ID3D11Buffer *cb_VS_Clouds[2], *cb_VS_CloudsShadow_0, *cb_PS_Clouds;
	static ID3D11SamplerState *SS_Clouds, *SS_Clouds_micro;

	static cb_VS_Clouds_0 VSCB_Clouds_0;
	static cb_VS_CloudsShadows_0 VSCB_CloudsShadows_0;
//Rings:
	static void InitRingEffect();
	static void ExitRingEffect();

	static ID3D11Buffer *cb_VS_Ring, *cb_PS_Ring;
	static ID3D11InputLayout *IL_RVertex;
	static ID3D11VertexShader *VS_Ring;
	static ID3D11PixelShader *PS_Ring;
	static ID3D11SamplerState *SS_Ring;

//CelSphere:
	static void InitCelSphereEffect();
	static void ExitCelSphereEffect();

	static ID3D11Buffer *cb_VS_Star_Line, *cb_PS_Line;
	static ID3D11InputLayout *IL_CVertex;
	static ID3D11VertexShader *VS_Star_Line;
	static ID3D11PixelShader *PS_Star, *PS_Line;

//CelBackground:
	static void InitCelBackgroundEffect();
	static void ExitCelBackgroundEffect();

	static ID3D11Buffer *cb_VS_CelBackground, *cb_PS_CelBackground;
	static ID3D11VertexShader *VS_CelBackground;
	static ID3D11PixelShader *PS_CelBackground;
	static ID3D11SamplerState *SS_CelBackground;

//Global
	static ID3D11SamplerState *SS_Wrap_Linear, *SS_Clamp_Linear;
};

#endif