#ifndef _OVRL_H
#define _OVRL_H

#if C2504
#pragma message("Overlay.h")
#endif

#include "D3D11Client.h"
#include "Scene.h"

// ======================================================================
//		Renders 2D Panels, HUD or info boxes at the top of the screen
// ======================================================================

class Scene;
class D3D11Client;

struct GroupType {
	ID3D11Buffer *VB;
	DWORD nVtx;
	ID3D11Buffer *IB;
	DWORD nIdx;
	DWORD texIdx;
	DWORD grpIdx;
	DWORD Unused;
};

struct OverlayCB {
	D3DXMATRIX Orth;
	D3DXVECTOR4 Params;
};

class Overlay {
	friend class D3D11Mesh;
public:
	Overlay();
	~Overlay();

	void Render2DOverlay( SURFHANDLE *Surf, MESHHANDLE Mesh, MATRIX3 *T, bool transparent );
	void RenderPBuffer();
private:
	void InitOverlay();		//creates effect vars

	static ID3D11Buffer
		*VB,		//vertex buffer
		*IB,		//index buffer
		*QuadVB,	//full-screen quad vertex buffer
		*QuadIB;	//full-screen quad index buffer
	UINT
		nVB,	//current max vertex buffer size
		nIB;	//current max index buffer size

	void ExtendVertexBuffer( UINT nVtx );
	void ExtendIndexBuffer( UINT nIdx );

	static const
		UINT NTVertexStride,
		VBOffset;

	struct PSBUF {
		UINT32 mode;
		float r, g, b;
	} PSCB;			//PS cbuffer

	D3DXMATRIX M, Orth;

	ID3D11InputLayout *IL_NTVertex;
	ID3D11VertexShader *VS_2DOverlay;
	ID3D11PixelShader
		*PS_2DOverlay,
		*PS_PBuffer;
	ID3D11DepthStencilState
		*DS_NoDepth_NoStencil;
};

extern Overlay *OV;

#endif