#ifndef __RINGMGR_H
#define __RINGMGR_H

#if C2504
#pragma message("RingManager.h")
#endif

#include "D3D11Effect.h"

class vPlanet;
class D3D11Effect;

struct MSH {
	ID3D11Buffer *VB;
	ID3D11Buffer *IB;
	DWORD nidx;
};

struct RVERTEX {
	D3DXVECTOR3 pos;
	D3DXVECTOR2 tex;
};

class RingManager : public D3D11Effect {
public:
	RingManager( vPlanet *_planet, double inner_rad, double outer_rad );
	~RingManager();

	void SaveParams();		//used when rendering thread stopped
	void Render( D3DXMATRIX *mWorld, DWORD res, bool front );
private:
	MSH CreateRing( DWORD nsect );
	DWORD LoadTextures();

	vPlanet *planet;
	MSH mesh[3];
	ID3D11ShaderResourceView *tex[3];
	DWORD rres, tres, ntex;
	double irad, orad;

	//MT
	MATRIX3 grot;		//"buffer".used to avoid oapi call from rendering thread
};

#endif