require 'osdn/cli/command/frs_base'

module OSDN; module CLI; module Command
  class Release < FrsBase
    def help
      puts "#{$0} release [opts] [list]"
      puts "#{$0} release [opts] create <new-release-name>"
      puts "#{$0} release [opts] update [numeric-release-id] [name]"
      puts "#{$0} release [opts] delete [numeric-release-id]"
      puts "Options:"
      puts "  -f --format=<pretty|json>  Set output format"
      puts "  -p --project=<project>     Target project (numeric id or name)"
      puts "     --package=<package-id>  Target package (numeric id)"
      puts "  -v --visibility=<public|private|hidden>"
    end

    def self.description
      "Manipulate frs releases of project"
    end

    def process_options
      opts = GetoptLong.new(
        [ '--format', '-f', GetoptLong::REQUIRED_ARGUMENT ],
        [ '--project', '-p', GetoptLong::REQUIRED_ARGUMENT ],
        [ '--package', GetoptLong::REQUIRED_ARGUMENT ],
        [ '--visibility', '-v', GetoptLong::REQUIRED_ARGUMENT ],
      )
      opts.each do |opt, arg|
        case opt
        when '--format'
          arg == 'json' and
            self.format = arg
        when '--project'
          arg.empty? or
            @target_proj = arg
        when '--package'
          arg.empty? or
            @target_package = arg
        when '--visibility'
          unless %w(public private hidden).member?(arg)
            logger.fatal "Invalid visibility status: #{arg}"
            exit
          end
          @visibility = arg
        end
      end
    end

    def list
      package = api.get_package target_proj, target_package
      list = package.releases
      if format == 'json'
        puts list.map{|i| i.to_hash}.to_json
      else
        list.each do |r|
          puts format_release(r)
        end
      end
    end

    def create
      name = ARGV.shift
      if !name
        logger.fatal "Release name is missing."
        help
        return
      end
      r = api.create_release target_proj, target_package, name, visibility: @visibility
      logger.info "New release has been created."
      puts format_release(r)
    end

    def update
      _set_release_id
      args = {}
      if ARGV[1].to_s != ""
        args[:name] = ARGV.shift
      end
      if @visibility
        args[:visibility] = @visibility
      end
      logger.debug "Updating release #{target_release} as #{args.inspect}"
      r = api.update_release target_proj, target_package, target_release, args
      logger.info "Release #{target_release} has been updated."
      puts format_release(r)
    end

    def delete
      _set_release_id
      r = api.delete_release target_proj, target_package, target_release
      logger.info "Release #{target_release} has been deleted."
    end

    def _set_release_id
      return if ARGV[0].to_i == 0
      @target_release = ARGV[0].to_i
    end
  end
end; end; end
