<?php
namespace sfjp\Wiki\Storage;
class File extends Base {
	protected $datadir = './wikitexts';

	function __construct($context = array()) {
		parent::__construct($context);
		if (!empty($context['storage.file.datadir']))
			$this->datadir = $context['storage.file.datadir'];
	}

	public function get($page) {
		return file_get_contents("{$this->datadir}/{$page}");
	}

	public function set($page, $text) {
		if (!is_dir($this->datadir))
			mkdir($this->datadir, 0755, true);
		$file = "{$this->datadir}/{$page}";
		$tmp  = "{$this->datadir}/.{$page}.tmp.".getmypid();
		file_put_contents($tmp, $text);
		rename($tmp, $file);
	}

	public function exists($page) {
		file_exists("{$this->datadir}/{$page}");
	}

	public function remove($page) {
		unlink("{$this->datadir}/{$page}");
	}

	public function get_list() {
		$dh = opendir($this->datadir);
		if (!$dh) return array();
	
		$ret = array();
		while ($ent = readdir($dh)) {
			if (substr($ent, 0, 1) == '.')
				continue;
			if (substr($ent, -1) == '~')
				continue;
			$ret []= $ent;
		}
		closedir($dh);
		sort($ret, SORT_NATURAL|SORT_FLAG_CASE);
		return $ret;
	}
}