<?php

require_once 'PHPUnit/Framework/TestCase.php';

class ParserTest extends PHPUnit_Framework_TestCase {
    protected function setUp() {
        $context = array(
            'sfjp.group_name' => 'unittest',
            'site_root_url' => 'http://sourceforge.jp',
            'internal_url_regex' => '^http://sourceforge\.jp/',
            'svn_base_url' => 'http://svn/view',
        );
        $this->p = new \sfjp\Wiki\Parser($context);
    }

    protected function tearDown() {

    }

    public function testContextKeyTransition() {
	    $v = 'hoge';
	    $this->p->setContext(array('plugin.order' => $v));
	    self::assertEquals($v, $this->p->getContext('plugin.order'));
	    self::assertEquals($v, $this->p->getContext('extension.acl_order'));

	    $v = 'fuga';
	    $this->p->setContext(array('extension.acl_order' => $v));
	    self::assertEquals($v, $this->p->getContext('plugin.order'));
	    self::assertEquals($v, $this->p->getContext('extension.acl_order'));
    }
}

// vim: set sts=4 sw=4 expandtab:
