<?php

require_once 'PHPUnit/Framework/TestCase.php';

class StorageTest extends PHPUnit_Framework_TestCase {
	protected $storage_path;
	protected $s;

	protected function setUp(){
		$this->storage_path = dirname(__FILE__) . "filestore-test";
		$this->s = new sfjp\Wiki\Storage\File(array('storage.file.datadir' => $this->storage_path));
	}

	protected function tearDown() {
		$this->cleanup();
	}

	protected function cleanup() {
		if (!is_dir($this->storage_path))
			return;
		$dh = opendir($this->storage_path);
		if (!$dh) return;
		while ($ent = readdir($dh)) {
			if ($ent == '.' || $ent == '..')
				continue;
			unlink("{$this->storage_path}/{$ent}");
		}
		closedir($dh);
		rmdir($this->storage_path);
	}

	public function testNew() {
		self::assertTrue(isset($this->s));
	}


	public function testGetSet() {
		$text = "hoge\nfuga\r\nyeah!";
		$this->s->set('page1', $text);
		self::assertEquals($text, $this->s->get('page1'));
	}

	public function testList() {
		$this->cleanup();
		$this->s->set('foo', 'foo 1');
		$this->s->set('Bar', 'bar 2');
		self::assertTrue(in_array('foo', $this->s->get_list()));
		self::assertTrue(in_array('Bar', $this->s->get_list()));
		self::assertTrue(!in_array('boo', $this->s->get_list()));
	}

	public function testRemove() {
		$this->s->set('hoge', '1');
		self::assertTrue(in_array('hoge', $this->s->get_list()));
		$this->s->remove('hoge');
		self::assertTrue(!in_array('hoge', $this->s->get_list()));
	}
}
