#!/usr/bin/env python

import xmlrpclib
import datetime
import sqlite3
import time
import sys

import databases
# see http://d.hatena.ne.jp/keyword/%a4%cf%a4%c6%a4%ca%a5%d6%a5%c3%a5%af%a5%de%a1%bc%a5%af%b7%ef%bf%f4%bc%e8%c6%c0API?kid=146686


def get_count(urls):    
    uri = "http://b.hatena.ne.jp/xmlrpc"
    server = xmlrpclib.ServerProxy(uri)
    t = server.bookmark.getCount(*urls)
    return t

def main():
    usage = """%s year_start month_start day_start
ex) %s 2010 10 26"""
    try:
        start_y = sys.argv[1]
        start_m = sys.argv[2]
        start_d = sys.argv[3]
    except IndexError:
        sys.exit(usage % (sys.argv[0], sys.argv[0]))

    DATABASE = "database/story_dat"
#    range_begin = datetime.datetime(2010, 10, 26)
#    range_end = datetime.datetime(2010, 11, 26)
    range_begin = datetime.datetime(start_y, start_m, start_d)
    range_end = range_begin + datetime.timedelta(31) # 31 days

    begin_t = time.mktime(range_begin.timetuple())
    end_t = time.mktime(range_end.timetuple())

    cmd = """select sid from stories where date >= ? and date < ? and sid in (
                      select sid from topics) order by date
        """
    con = sqlite3.connect(DATABASE)
    cur = con.cursor()
    cur.execute(cmd, (begin_t, end_t))

    urls = []
    counts = {}
    db = databases.HatebuDB()
    with db:
        for row in cur:
            sid = row[0]
            urls.append("http://sourceforge.jp/magazine/" + sid)
            if len(urls) == 50:
                results = get_count(urls)
                urls = []
                for url in results:
                    id = url.replace("http://sourceforge.jp/magazine/", "")
                    count = results[url]
                    db.add(id, count)

        if len(urls) > 0:
            results = get_count(urls)
            urls = []
            for url in results:
                id = url.replace("http://sourceforge.jp/magazine/", "")
                count = results[url]
                db.add(id, count)

if __name__ == "__main__":
    main()
