#!/usr/bin/env python

import sqlite3
import sys
import getopt
import os.path
import getpass

import otptools2

LOG_DB = "database/analytics_dat"
CACHE_DB = "database/urlcache_dat"

def login(otp, uname=""):
    if uname == "":
        try:
            uname = raw_input("user: ")
        except KeyboardInterrupt:
            sys.exit("\nabort.")
        try:
            passwd = getpass.getpass("login password:")
        except KeyboardInterrupt:
            sys.exit("\nabort.")
        if not otp.login(uname, passwd):
            sys.exit("login error!")
    otp.save_cookie()

def prepare_database():
    if os.path.exists(CACHE_DB):
        return
    con = sqlite3.connect(CACHE_DB)
    cur = con.cursor()

    cur.execute("""
    create table sid_cache (
      sid text unique,
      title text default ""
    );
""")

    cur.execute("""
    create table topics (
      sid text,
      topic text
    );
""")

    con.commit()
    cur.close()
    con.close()


def get_story_info(otp, sid):
    con = sqlite3.connect(CACHE_DB)
    cur = con.cursor()
    cur.execute("""select title from sid_cache where sid=?;""", (sid,) )
    tags = []
    title = ""
    result = cur.fetchone()
    if result is None:
        tags = otp.get_tags("/magazine.sourceforge.jp/article.pl?sid=" + sid)
        title = otp.get_title("/magazine.sourceforge.jp/article.pl?sid=" + sid)
        cur.execute("""insert into sid_cache (sid, title) values (?, ?);""",
                    (sid, title))
        for tag in tags:
            cur.execute("""insert into topics (sid, topic) values (?, ?);""",
                        (sid, tag))                     
        con.commit()
    else:
        title = result[0]
        cur.execute("""select topic from topics where sid=?""", (sid,))
        for row in cur:
            tags.append(row[0])
    cur.close()
    con.close()
    return (title, tags)

# main proc.
def main():
    usage = "%s [-c]" % sys.argv[0]
    (optlist, args) = getopt.getopt(sys.argv[1:], "c")

    if ('-c', '') in optlist:
        # create database
        prepare_database()
        return

    otp = otptools2.otptools("./cookies.txt")
    try:
        otp.load_cookie()
    except IOError:
        sys.stderr.write("cannot use cookie file. create.\n")

    if otp.get_cookie() == "":
        login(otp)
        otp.save_cookie()

    #test
    #test = "10/04/22/1028220"
    #(title, tags) = get_story_info(otp, test)
    #print title, tags
    

if __name__ == '__main__':
    main()
