package jp.sourceforge.pdt_tools.codeChecker.visitor;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.compiler.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.DeclareStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.Dispatch;
import org.eclipse.php.internal.core.compiler.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.EmptyStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameterByReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.GotoLabel;
import org.eclipse.php.internal.core.compiler.ast.nodes.GotoStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IgnoreError;
import org.eclipse.php.internal.core.compiler.ast.nodes.Include;
import org.eclipse.php.internal.core.compiler.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallArgumentsList;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.Quote;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReferenceExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReflectionArrayVariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReflectionCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReflectionStaticMethodInvocation;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReflectionVariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.compiler.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.WhileStatement;

public class TestLocalVisitor extends BaseVisitor {

	private List<String> listRead;
	private List<String> listWrite;
	private List<VariableReference> listOccurrence;
	private List<String> listGlobal;
	private List<String> listParam;
	private List<String> listRefParam;
	private List<String> listRefParams;
	private Stack<Expression> stackSkip;

	public TestLocalVisitor() {
		listRead = new LinkedList<String>();
		listWrite = new LinkedList<String>();
		listOccurrence = new LinkedList<VariableReference>();
		listGlobal = new LinkedList<String>();
		listParam = new LinkedList<String>();
		listRefParam = new LinkedList<String>();
		listRefParams = new LinkedList<String>();
		stackSkip = new Stack<Expression>();
	}

	public boolean isReadOnly(String name) {
		return listRead.contains(name) && !listWrite.contains(name);
	}

	public boolean isWriteOnly(String name) {
		return listWrite.contains(name) && !listRead.contains(name);
	}

	public boolean isUnusedParam(String name) {
		return listParam.contains(name) || listRefParam.contains(name);
	}

	public List<VariableReference> getOccurrence() {
		return listOccurrence;
	}

	@Override
	public boolean visit(ArrayCreation s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ArrayElement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ArrayVariableReference s) throws Exception {
		if (!stackSkip.isEmpty() && stackSkip.peek().equals(s)) {
			return super.visit(s);
		}
		if (!listGlobal.contains(s.getName())) {
			if (mode.peek().equals(READ)) {
				listRead.add(s.getName());
			} else {
				listWrite.add(s.getName());
			}
			listOccurrence.add(s);
		}
		return super.visit(s);
	}

	@Override
	public boolean visit(Assignment s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(BackTickExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(BreakStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(CastExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(CatchClause s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ConstantDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ClassDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ClassInstanceCreation s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(CloneExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ConditionalExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ConstantReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ContinueStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(DeclareStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(Dispatch s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(DoStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(EchoStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(EmptyStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ExpressionStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(FieldAccess s) throws Exception {
		stackSkip.push(s.getField());
		return super.visit(s);
	}

	@Override
	public boolean endvisit(FieldAccess s) throws Exception {
		stackSkip.pop();
		return super.endvisit(s);
	}

	@Override
	public boolean visit(ForEachStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(FormalParameter s) throws Exception {
		listParam.add(s.getName());
		if (s.getInitialization() != null) {
			listWrite.add(s.getName());
		}
		return false;
	}

	@Override
	public boolean visit(FormalParameterByReference s) throws Exception {
		listRefParam.add(s.getName());
		listRefParams.add(s.getName());
		if (s.getInitialization() != null) {
			listWrite.add(s.getName());
		}
		return false;
	}

	@Override
	public boolean visit(ForStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(GlobalStatement s) throws Exception {
		for (Expression e : s.getVariables()) {
			listGlobal.add(e.toString());
		}
		return super.visit(s);
	}

	@Override
	public boolean visit(IfStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(IgnoreError s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(Include s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(InfixExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(InstanceOfExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(InterfaceDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ListVariable s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(PHPCallArgumentsList s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(PHPCallExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(PHPFieldDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(PHPMethodDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean endvisit(PHPMethodDeclaration s) throws Exception {
		if ((s.getDeclaringTypeName() + "").equals("")) {
			listGlobal.clear();
		}
		return super.endvisit(s);
	}

	@Override
	public boolean visit(PostfixExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(PrefixExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(Quote s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReferenceExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReflectionArrayVariableReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReflectionCallExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReflectionStaticMethodInvocation s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReflectionVariableReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReturnStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(Scalar s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(SimpleReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(StaticConstantAccess s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(StaticDispatch s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(StaticFieldAccess s) throws Exception {
		stackSkip.push(s.getField());
		return super.visit(s);
	}

	@Override
	public boolean endvisit(StaticFieldAccess s) throws Exception {
		stackSkip.pop();
		return super.endvisit(s);
	}

	@Override
	public boolean visit(StaticMethodInvocation s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(StaticStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(SwitchCase s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(SwitchStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ThrowStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(TryStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(TypeReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(UnaryOperation s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(VariableReference s) throws Exception {
		if (!stackSkip.isEmpty() && stackSkip.peek().equals(s)) {
			return super.visit(s);
		}
		String name = s.getName();
		if (name.equalsIgnoreCase("$this")) {
			return super.visit(s);
		}
		if (!listGlobal.contains(name)) {
			if (mode.peek().equals(READ)) {
				listRead.add(name);
				listParam.remove(name);
				listRefParam.remove(name);
			} else {
				listWrite.add(name);
				listRefParam.remove(name);
				if (listRefParams.contains(name)) {
					listRead.add(name);
				}
			}
			listOccurrence.add(s);
		}
		return super.visit(s);
	}

	@Override
	public boolean visit(WhileStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(UseStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(UsePart s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(NamespaceDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(NamespaceReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(FullyQualifiedReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(GotoLabel s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(GotoStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(LambdaFunctionDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ASTNode s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(Expression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(MethodDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(Statement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(TypeDeclaration s) throws Exception {
		return super.visit(s);
	}

}
