package jp.sourceforge.pdt_tools.codeChecker;

import java.util.List;

import jp.sourceforge.pdt_tools.codeChecker.visitor.CodeVisitor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPSourceParserFactory;
import org.eclipse.ui.PlatformUI;

public class BuildParticipant implements IBuildParticipant {

	public void build(IBuildContext context) throws CoreException {
		if (context.getBuildType() != IBuildContext.RECONCILE_BUILD) {
			return;
		}
		ISourceModule sourceModule = context.getSourceModule();
		IModuleDeclaration moduleDeclaration = new PHPSourceParserFactory()
				.parse((IModuleSource) sourceModule,
						context.getProblemReporter());
		CodeVisitor visitor = new CodeVisitor(sourceModule);
		try {
			((ModuleDeclaration) moduleDeclaration).traverse(visitor);
			List<ProblemMarker> problems = visitor.getProblems();
			commitMarkers(sourceModule.getResource(), problems);
		} catch (Exception e) {
			CodeCheckerPlugin.log(e, "in reconciling "
					+ sourceModule.getPath().toString());
		}
	}

	private void commitMarkers(final IResource resource,
			final List<ProblemMarker> problems) throws CoreException {
		PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
			public void run() {
				try {
					IMarker[] markers = resource.findMarkers(
							CodeCheckerPlugin.MARKER_ID, false,
							IResource.DEPTH_INFINITE);
					for (int i = 0; i < markers.length; i++) {
						markers[i].delete();
					}
					for (ProblemMarker problemMarker : problems) {
						problemMarker.commit();
					}
				} catch (CoreException e) {
					e.printStackTrace();
				}
			}
		});
	}

}
